/*
 * Decompiled with CFR 0.152.
 */
package q.storage.columnar.api.impl;

import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.parquet.example.data.Group;
import shaded.org.apache.parquet.example.data.simple.BinaryValue;
import shaded.org.apache.parquet.example.data.simple.BooleanValue;
import shaded.org.apache.parquet.example.data.simple.DoubleValue;
import shaded.org.apache.parquet.example.data.simple.FloatValue;
import shaded.org.apache.parquet.example.data.simple.Int96Value;
import shaded.org.apache.parquet.example.data.simple.IntegerValue;
import shaded.org.apache.parquet.example.data.simple.LongValue;
import shaded.org.apache.parquet.example.data.simple.NanoTime;
import shaded.org.apache.parquet.example.data.simple.Primitive;
import shaded.org.apache.parquet.example.data.simple.SimpleGroup;
import shaded.org.apache.parquet.io.api.Binary;
import shaded.org.apache.parquet.io.api.RecordConsumer;
import shaded.org.apache.parquet.schema.GroupType;
import shaded.org.apache.parquet.schema.Type;

public class QingStorageRecord
extends Group {
    private final GroupType a;
    private final List[] b;

    public QingStorageRecord(GroupType groupType) {
        this.a = groupType;
        this.b = new List[groupType.getFields().size()];
        for (int i2 = 0; i2 < groupType.getFieldCount(); ++i2) {
            this.b[i2] = new ArrayList();
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = "";
        int n2 = 0;
        for (Type type : this.a.getFields()) {
            String object = type.getName();
            Object object2 = this.b[n2];
            ++n2;
            if (object2 == null || object2.size() <= 0) continue;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object e2 = object2.next();
                string2 = string2 + string + object;
                if (e2 == null) {
                    string2 = string2 + ": NULL\n";
                    continue;
                }
                if (e2 instanceof Group) {
                    string2 = string2 + "\n" + ((SimpleGroup)e2).toString(string + "  ");
                    continue;
                }
                string2 = string2 + ": " + e2.toString() + "\n";
            }
        }
        return string2;
    }

    public Group addGroup(int n2) {
        SimpleGroup simpleGroup = new SimpleGroup(this.a.getType(n2).asGroupType());
        this.add(n2, (Group)simpleGroup);
        return simpleGroup;
    }

    public Group getGroup(int n2, int n3) {
        return (Group)this.a(n2, n3);
    }

    private Object a(int n2, int n3) {
        List list;
        try {
            list = this.b[n2];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeException("not found " + n2 + "(" + this.a.getFieldName(n2) + ") in group:\n" + this);
        }
        try {
            return list.get(n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeException("not found " + n2 + "(" + this.a.getFieldName(n2) + ") element number " + n3 + " in group:\n" + this);
        }
    }

    private void a(int n2, Primitive primitive) {
        Type type = this.a.getType(n2);
        List list = this.b[n2];
        if (!type.isRepetition(Type.Repetition.REPEATED) && !list.isEmpty()) {
            throw new IllegalStateException("field " + n2 + " (" + type.getName() + ") can not have more than one value: " + list);
        }
        list.add(primitive);
    }

    public int getFieldRepetitionCount(int n2) {
        List list = this.b[n2];
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public String getValueToString(int n2, int n3) {
        return String.valueOf(this.a(n2, n3));
    }

    public String getString(int n2, int n3) {
        return ((BinaryValue)this.a(n2, n3)).getString();
    }

    public int getInteger(int n2, int n3) {
        return ((IntegerValue)this.a(n2, n3)).getInteger();
    }

    public long getLong(int n2, int n3) {
        return ((LongValue)this.a(n2, n3)).getLong();
    }

    public double getDouble(int n2, int n3) {
        return ((DoubleValue)this.a(n2, n3)).getDouble();
    }

    public float getFloat(int n2, int n3) {
        return ((FloatValue)this.a(n2, n3)).getFloat();
    }

    public boolean getBoolean(int n2, int n3) {
        return ((BooleanValue)this.a(n2, n3)).getBoolean();
    }

    public Binary getBinary(int n2, int n3) {
        return ((BinaryValue)this.a(n2, n3)).getBinary();
    }

    public NanoTime getTimeNanos(int n2, int n3) {
        return NanoTime.fromInt96((Int96Value)this.a(n2, n3));
    }

    public Binary getInt96(int n2, int n3) {
        return ((Int96Value)this.a(n2, n3)).getInt96();
    }

    public void add(int n2, int n3) {
        this.a(n2, new IntegerValue(n3));
    }

    public void add(int n2, long l2) {
        this.a(n2, new LongValue(l2));
    }

    public void add(int n2, String string) {
        this.a(n2, new BinaryValue(Binary.fromString(string)));
    }

    public void add(int n2, NanoTime nanoTime) {
        this.a(n2, nanoTime.toInt96());
    }

    public void add(int n2, boolean bl) {
        this.a(n2, new BooleanValue(bl));
    }

    public void add(int n2, Binary binary) {
        switch (this.getType().getType(n2).asPrimitiveType().getPrimitiveTypeName()) {
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                this.a(n2, new BinaryValue(binary));
                return;
            }
            case INT96: {
                this.a(n2, new Int96Value(binary));
                return;
            }
        }
        throw new UnsupportedOperationException(this.getType().asPrimitiveType().getName() + " not supported for Binary");
    }

    public void add(int n2, float f2) {
        this.a(n2, new FloatValue(f2));
    }

    public void add(int n2, double d2) {
        this.a(n2, new DoubleValue(d2));
    }

    public void add(int n2, Group group) {
        this.b[n2].add(group);
    }

    public GroupType getType() {
        return this.a;
    }

    public void writeValue(int n2, int n3, RecordConsumer recordConsumer) {
        ((Primitive)this.a(n2, n3)).writeValue(recordConsumer);
    }
}

