/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.apache.parquet.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SemanticVersion
implements Comparable<SemanticVersion> {
    private static final String FORMAT = "^(\\d+)\\.(\\d+)\\.(\\d+)((.*)(\\d+))?(\\-(.*))?$";
    private static final Pattern PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)((.*)(\\d+))?(\\-(.*))?$");
    public final int major;
    public final int minor;
    public final int patch;
    public final boolean prerelease;

    public SemanticVersion(int major, int minor, int patch) {
        Preconditions.checkArgument(major >= 0, "major must be >= 0");
        Preconditions.checkArgument(minor >= 0, "minor must be >= 0");
        Preconditions.checkArgument(patch >= 0, "patch must be >= 0");
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = false;
    }

    public SemanticVersion(int major, int minor, int patch, boolean isPrerelease) {
        Preconditions.checkArgument(major >= 0, "major must be >= 0");
        Preconditions.checkArgument(minor >= 0, "minor must be >= 0");
        Preconditions.checkArgument(patch >= 0, "patch must be >= 0");
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = isPrerelease;
    }

    public static SemanticVersion parse(String version) throws SemanticVersionParseException {
        int patch;
        int minor;
        int major;
        Matcher matcher = PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new SemanticVersionParseException(version + " does not match format " + FORMAT);
        }
        boolean prerelease = false;
        try {
            major = Integer.valueOf(matcher.group(1));
            minor = Integer.valueOf(matcher.group(2));
            patch = Integer.valueOf(matcher.group(3));
            int g2 = 4;
            while (g2 <= matcher.groupCount()) {
                prerelease |= matcher.group(g2) != null;
                ++g2;
            }
        }
        catch (NumberFormatException e2) {
            throw new SemanticVersionParseException(e2);
        }
        if (major < 0 || minor < 0 || patch < 0) {
            throw new SemanticVersionParseException(String.format("major(%d), minor(%d), and patch(%d) must all be >= 0", major, minor, patch));
        }
        return new SemanticVersion(major, minor, patch, prerelease);
    }

    @Override
    public int compareTo(SemanticVersion o2) {
        int cmp = SemanticVersion.compare(this.major, o2.major);
        if (cmp != 0) {
            return cmp;
        }
        cmp = SemanticVersion.compare(this.minor, o2.minor);
        if (cmp != 0) {
            return cmp;
        }
        cmp = SemanticVersion.compare(this.patch, o2.patch);
        if (cmp != 0) {
            return cmp;
        }
        return SemanticVersion.compare(o2.prerelease, this.prerelease);
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compare(boolean x, boolean y) {
        return x == y ? 0 : (x ? 1 : -1);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SemanticVersion that = (SemanticVersion)o2;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public String toString() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.patch;
    }

    public static class SemanticVersionParseException
    extends Exception {
        public SemanticVersionParseException() {
        }

        public SemanticVersionParseException(String message) {
            super(message);
        }

        public SemanticVersionParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public SemanticVersionParseException(Throwable cause) {
            super(cause);
        }
    }
}

