/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column;

import java.io.IOException;
import shaded.org.apache.parquet.bytes.BytesUtils;
import shaded.org.apache.parquet.column.ColumnDescriptor;
import shaded.org.apache.parquet.column.Dictionary;
import shaded.org.apache.parquet.column.ValuesType;
import shaded.org.apache.parquet.column.page.DictionaryPage;
import shaded.org.apache.parquet.column.values.ValuesReader;
import shaded.org.apache.parquet.column.values.bitpacking.ByteBitPackingValuesReader;
import shaded.org.apache.parquet.column.values.bitpacking.Packer;
import shaded.org.apache.parquet.column.values.boundedint.ZeroIntegerValuesReader;
import shaded.org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import shaded.org.apache.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesReader;
import shaded.org.apache.parquet.column.values.deltastrings.DeltaByteArrayReader;
import shaded.org.apache.parquet.column.values.dictionary.DictionaryValuesReader;
import shaded.org.apache.parquet.column.values.dictionary.PlainValuesDictionary;
import shaded.org.apache.parquet.column.values.plain.BinaryPlainValuesReader;
import shaded.org.apache.parquet.column.values.plain.BooleanPlainValuesReader;
import shaded.org.apache.parquet.column.values.plain.FixedLenByteArrayPlainValuesReader;
import shaded.org.apache.parquet.column.values.plain.PlainValuesReader;
import shaded.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesReader;
import shaded.org.apache.parquet.io.ParquetDecodingException;
import shaded.org.apache.parquet.schema.PrimitiveType;

public enum Encoding {
    PLAIN{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            switch (descriptor.getType()) {
                case BOOLEAN: {
                    return new BooleanPlainValuesReader();
                }
                case BINARY: {
                    return new BinaryPlainValuesReader();
                }
                case FLOAT: {
                    return new PlainValuesReader.FloatPlainValuesReader();
                }
                case DOUBLE: {
                    return new PlainValuesReader.DoublePlainValuesReader();
                }
                case INT32: {
                    return new PlainValuesReader.IntegerPlainValuesReader();
                }
                case INT64: {
                    return new PlainValuesReader.LongPlainValuesReader();
                }
                case INT96: {
                    return new FixedLenByteArrayPlainValuesReader(12);
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    return new FixedLenByteArrayPlainValuesReader(descriptor.getTypeLength());
                }
            }
            throw new ParquetDecodingException("no plain reader for type " + (Object)((Object)descriptor.getType()));
        }

        @Override
        public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
            switch (descriptor.getType()) {
                case BINARY: {
                    return new PlainValuesDictionary.PlainBinaryDictionary(dictionaryPage);
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    return new PlainValuesDictionary.PlainBinaryDictionary(dictionaryPage, descriptor.getTypeLength());
                }
                case INT96: {
                    return new PlainValuesDictionary.PlainBinaryDictionary(dictionaryPage, 12);
                }
                case INT64: {
                    return new PlainValuesDictionary.PlainLongDictionary(dictionaryPage);
                }
                case DOUBLE: {
                    return new PlainValuesDictionary.PlainDoubleDictionary(dictionaryPage);
                }
                case INT32: {
                    return new PlainValuesDictionary.PlainIntegerDictionary(dictionaryPage);
                }
                case FLOAT: {
                    return new PlainValuesDictionary.PlainFloatDictionary(dictionaryPage);
                }
            }
            throw new ParquetDecodingException("Dictionary encoding not supported for type: " + (Object)((Object)descriptor.getType()));
        }
    }
    ,
    RLE{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            int bitWidth = BytesUtils.getWidthFromMaxInt(this.getMaxLevel(descriptor, valuesType));
            if (bitWidth == 0) {
                return new ZeroIntegerValuesReader();
            }
            return new RunLengthBitPackingHybridValuesReader(bitWidth);
        }
    }
    ,
    BIT_PACKED{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            return new ByteBitPackingValuesReader(this.getMaxLevel(descriptor, valuesType), Packer.BIG_ENDIAN);
        }
    }
    ,
    PLAIN_DICTIONARY{

        @Override
        public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ValuesType valuesType, Dictionary dictionary) {
            return RLE_DICTIONARY.getDictionaryBasedValuesReader(descriptor, valuesType, dictionary);
        }

        @Override
        public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
            return PLAIN.initDictionary(descriptor, dictionaryPage);
        }

        @Override
        public boolean usesDictionary() {
            return true;
        }
    }
    ,
    DELTA_BINARY_PACKED{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            if (descriptor.getType() != PrimitiveType.PrimitiveTypeName.INT32) {
                throw new ParquetDecodingException("Encoding DELTA_BINARY_PACKED is only supported for type INT32");
            }
            return new DeltaBinaryPackingValuesReader();
        }
    }
    ,
    DELTA_LENGTH_BYTE_ARRAY{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            if (descriptor.getType() != PrimitiveType.PrimitiveTypeName.BINARY) {
                throw new ParquetDecodingException("Encoding DELTA_LENGTH_BYTE_ARRAY is only supported for type BINARY");
            }
            return new DeltaLengthByteArrayValuesReader();
        }
    }
    ,
    DELTA_BYTE_ARRAY{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            if (descriptor.getType() != PrimitiveType.PrimitiveTypeName.BINARY && descriptor.getType() != PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
                throw new ParquetDecodingException("Encoding DELTA_BYTE_ARRAY is only supported for type BINARY and FIXED_LEN_BYTE_ARRAY");
            }
            return new DeltaByteArrayReader();
        }
    }
    ,
    RLE_DICTIONARY{

        @Override
        public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ValuesType valuesType, Dictionary dictionary) {
            switch (descriptor.getType()) {
                case BINARY: 
                case FLOAT: 
                case DOUBLE: 
                case INT32: 
                case INT64: 
                case INT96: 
                case FIXED_LEN_BYTE_ARRAY: {
                    return new DictionaryValuesReader(dictionary);
                }
            }
            throw new ParquetDecodingException("Dictionary encoding not supported for type: " + (Object)((Object)descriptor.getType()));
        }

        @Override
        public boolean usesDictionary() {
            return true;
        }
    };


    int getMaxLevel(ColumnDescriptor descriptor, ValuesType valuesType) {
        int maxLevel;
        switch (valuesType) {
            case REPETITION_LEVEL: {
                maxLevel = descriptor.getMaxRepetitionLevel();
                break;
            }
            case DEFINITION_LEVEL: {
                maxLevel = descriptor.getMaxDefinitionLevel();
                break;
            }
            case VALUES: {
                if (descriptor.getType() == PrimitiveType.PrimitiveTypeName.BOOLEAN) {
                    maxLevel = 1;
                    break;
                }
            }
            default: {
                throw new ParquetDecodingException("Unsupported encoding for values: " + (Object)((Object)this));
            }
        }
        return maxLevel;
    }

    public boolean usesDictionary() {
        return false;
    }

    public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
        throw new UnsupportedOperationException(this.name() + " does not support dictionary");
    }

    public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
        throw new UnsupportedOperationException("Error decoding " + descriptor + ". " + this.name() + " is dictionary based");
    }

    public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ValuesType valuesType, Dictionary dictionary) {
        throw new UnsupportedOperationException(this.name() + " is not dictionary based");
    }
}

