/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.bitpacking;

import shaded.org.apache.parquet.column.values.bitpacking.BytePacker;
import shaded.org.apache.parquet.column.values.bitpacking.BytePackerFactory;
import shaded.org.apache.parquet.column.values.bitpacking.IntPacker;
import shaded.org.apache.parquet.column.values.bitpacking.IntPackerFactory;

public enum Packer {
    BIG_ENDIAN{

        @Override
        public IntPacker newIntPacker(int width) {
            return beIntPackerFactory.newIntPacker(width);
        }

        @Override
        public BytePacker newBytePacker(int width) {
            return beBytePackerFactory.newBytePacker(width);
        }
    }
    ,
    LITTLE_ENDIAN{

        @Override
        public IntPacker newIntPacker(int width) {
            return leIntPackerFactory.newIntPacker(width);
        }

        @Override
        public BytePacker newBytePacker(int width) {
            return leBytePackerFactory.newBytePacker(width);
        }
    };

    static BytePackerFactory beBytePackerFactory;
    static IntPackerFactory beIntPackerFactory;
    static BytePackerFactory leBytePackerFactory;
    static IntPackerFactory leIntPackerFactory;

    private static IntPackerFactory getIntPackerFactory(String name) {
        return (IntPackerFactory)Packer.getStaticField("shaded.org.apache.parquet.column.values.bitpacking." + name, "factory");
    }

    private static BytePackerFactory getBytePackerFactory(String name) {
        return (BytePackerFactory)Packer.getStaticField("shaded.org.apache.parquet.column.values.bitpacking." + name, "factory");
    }

    private static Object getStaticField(String className, String fieldName) {
        try {
            return Class.forName(className).getField(fieldName).get(null);
        }
        catch (IllegalArgumentException e2) {
            throw new RuntimeException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException(e3);
        }
        catch (NoSuchFieldException e4) {
            throw new RuntimeException(e4);
        }
        catch (SecurityException e5) {
            throw new RuntimeException(e5);
        }
        catch (ClassNotFoundException e6) {
            throw new RuntimeException(e6);
        }
    }

    public abstract IntPacker newIntPacker(int var1);

    public abstract BytePacker newBytePacker(int var1);

    static {
        beBytePackerFactory = Packer.getBytePackerFactory("ByteBitPackingBE");
        beIntPackerFactory = Packer.getIntPackerFactory("LemireBitPackingBE");
        leBytePackerFactory = Packer.getBytePackerFactory("ByteBitPackingLE");
        leIntPackerFactory = Packer.getIntPackerFactory("LemireBitPackingLE");
    }
}

