/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.boundedint;

import java.io.IOException;
import shaded.org.apache.parquet.io.ParquetDecodingException;

class BitReader {
    private int currentByte = 0;
    private int currentPosition = 8;
    private byte[] buf;
    private int currentBufferPosition = 0;
    private static final int[] byteGetValueMask;
    private static final int[] readMask;
    private int endBufferPosistion;

    BitReader() {
    }

    public void prepare(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.endBufferPosistion = offset + length;
        this.currentByte = 0;
        this.currentPosition = 8;
        this.currentBufferPosition = offset;
    }

    private static boolean extractBit(int val, int bit) {
        return (val & byteGetValueMask[bit]) != 0;
    }

    public int readNBitInteger(int bitsPerValue) {
        int currentValue = this.currentByte >>> this.currentPosition;
        int toShift = 8 - this.currentPosition;
        for (int bits = bitsPerValue + this.currentPosition; bits >= 8; bits -= 8) {
            this.currentByte = this.getNextByte();
            currentValue |= this.currentByte << toShift;
            toShift += 8;
        }
        this.currentPosition = (bitsPerValue + this.currentPosition) % 8;
        return currentValue &= readMask[bitsPerValue];
    }

    private int getNextByte() {
        if (this.currentBufferPosition < this.endBufferPosistion) {
            return this.buf[this.currentBufferPosition++] & 0xFF;
        }
        return 0;
    }

    public boolean readBit() throws IOException {
        if (this.currentPosition == 8) {
            this.currentByte = this.getNextByte();
            this.currentPosition = 0;
        }
        return BitReader.extractBit(this.currentByte, this.currentPosition++);
    }

    public int readByte() {
        this.currentByte |= this.getNextByte() << 8;
        int value = this.currentByte >>> this.currentPosition & 0xFF;
        this.currentByte >>>= 8;
        return value;
    }

    public int readUnsignedVarint() throws IOException {
        int b2;
        int value = 0;
        int i2 = 0;
        while (((b2 = this.readByte()) & 0x80) != 0) {
            value |= (b2 & 0x7F) << i2;
            if ((i2 += 7) <= 35) continue;
            throw new ParquetDecodingException("Variable length quantity is too long");
        }
        return value | b2 << i2;
    }

    static {
        int i2;
        byteGetValueMask = new int[8];
        readMask = new int[32];
        int currentMask = 1;
        for (i2 = 0; i2 < byteGetValueMask.length; ++i2) {
            BitReader.byteGetValueMask[i2] = currentMask;
            currentMask <<= 1;
        }
        currentMask = 0;
        for (i2 = 0; i2 < readMask.length; ++i2) {
            BitReader.readMask[i2] = currentMask;
            currentMask <<= 1;
            ++currentMask;
        }
    }
}

