/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.delta;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import shaded.org.apache.parquet.bytes.BytesUtils;
import shaded.org.apache.parquet.column.values.ValuesReader;
import shaded.org.apache.parquet.column.values.bitpacking.BytePacker;
import shaded.org.apache.parquet.column.values.bitpacking.Packer;
import shaded.org.apache.parquet.column.values.delta.DeltaBinaryPackingConfig;
import shaded.org.apache.parquet.io.ParquetDecodingException;

public class DeltaBinaryPackingValuesReader
extends ValuesReader {
    private int totalValueCount;
    private int valuesRead;
    private int minDeltaInCurrentBlock;
    private byte[] page;
    private int[] valuesBuffer;
    private int valuesBuffered;
    private ByteArrayInputStream in;
    private int nextOffset;
    private DeltaBinaryPackingConfig config;
    private int[] bitWidths;

    @Override
    public void initFromPage(int valueCount, byte[] page, int offset) throws IOException {
        this.in = new ByteArrayInputStream(page, offset, page.length - offset);
        this.config = DeltaBinaryPackingConfig.readConfig(this.in);
        this.page = page;
        this.totalValueCount = BytesUtils.readUnsignedVarInt(this.in);
        this.allocateValuesBuffer();
        this.bitWidths = new int[this.config.miniBlockNumInABlock];
        this.valuesBuffer[this.valuesBuffered++] = BytesUtils.readZigZagVarInt(this.in);
        while (this.valuesBuffered < this.totalValueCount) {
            this.loadNewBlockToBuffer();
        }
        this.nextOffset = page.length - this.in.available();
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    private void allocateValuesBuffer() {
        int totalMiniBlockCount = (int)Math.ceil((double)this.totalValueCount / (double)this.config.miniBlockSizeInValues);
        this.valuesBuffer = new int[totalMiniBlockCount * this.config.miniBlockSizeInValues + 1];
    }

    @Override
    public void skip() {
        this.checkRead();
        ++this.valuesRead;
    }

    @Override
    public int readInteger() {
        this.checkRead();
        return this.valuesBuffer[this.valuesRead++];
    }

    private void checkRead() {
        if (this.valuesRead >= this.totalValueCount) {
            throw new ParquetDecodingException("no more value to read, total value count is " + this.totalValueCount);
        }
    }

    private void loadNewBlockToBuffer() {
        int i2;
        try {
            this.minDeltaInCurrentBlock = BytesUtils.readZigZagVarInt(this.in);
        }
        catch (IOException e2) {
            throw new ParquetDecodingException("can not read min delta in current block", e2);
        }
        this.readBitWidthsForMiniBlocks();
        for (i2 = 0; i2 < this.config.miniBlockNumInABlock && this.valuesBuffered < this.totalValueCount; ++i2) {
            BytePacker packer = Packer.LITTLE_ENDIAN.newBytePacker(this.bitWidths[i2]);
            this.unpackMiniBlock(packer);
        }
        int valueUnpacked = i2 * this.config.miniBlockSizeInValues;
        int j2 = this.valuesBuffered - valueUnpacked;
        while (j2 < this.valuesBuffered) {
            int index;
            int n2 = index = j2++;
            this.valuesBuffer[n2] = this.valuesBuffer[n2] + (this.minDeltaInCurrentBlock + this.valuesBuffer[index - 1]);
        }
    }

    private void unpackMiniBlock(BytePacker packer) {
        for (int j2 = 0; j2 < this.config.miniBlockSizeInValues; j2 += 8) {
            this.unpack8Values(packer);
        }
    }

    private void unpack8Values(BytePacker packer) {
        int pos = this.page.length - this.in.available();
        packer.unpack8Values(this.page, pos, this.valuesBuffer, this.valuesBuffered);
        this.valuesBuffered += 8;
        this.in.skip(packer.getBitWidth());
    }

    private void readBitWidthsForMiniBlocks() {
        for (int i2 = 0; i2 < this.config.miniBlockNumInABlock; ++i2) {
            try {
                this.bitWidths[i2] = BytesUtils.readIntLittleEndianOnOneByte(this.in);
                continue;
            }
            catch (IOException e2) {
                throw new ParquetDecodingException("Can not decode bitwidth in block header", e2);
            }
        }
    }
}

