/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.plain;

import java.io.IOException;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.column.values.ValuesReader;
import shaded.org.apache.parquet.column.values.bitpacking.ByteBitPackingValuesReader;
import shaded.org.apache.parquet.column.values.bitpacking.Packer;

public class BooleanPlainValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(BooleanPlainValuesReader.class);
    private ByteBitPackingValuesReader in = new ByteBitPackingValuesReader(1, Packer.LITTLE_ENDIAN);

    @Override
    public boolean readBoolean() {
        return this.in.readInteger() != 0;
    }

    @Override
    public void skip() {
        this.in.readInteger();
    }

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("init from page at offset " + offset + " for length " + (in.length - offset));
        }
        this.in.initFromPage(valueCount, in, offset);
    }

    @Override
    public int getNextOffset() {
        return this.in.getNextOffset();
    }
}

