/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.rle;

import java.io.IOException;
import shaded.org.apache.parquet.Ints;
import shaded.org.apache.parquet.bytes.BytesInput;
import shaded.org.apache.parquet.column.Encoding;
import shaded.org.apache.parquet.column.values.ValuesWriter;
import shaded.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import shaded.org.apache.parquet.io.ParquetEncodingException;

public class RunLengthBitPackingHybridValuesWriter
extends ValuesWriter {
    private final RunLengthBitPackingHybridEncoder encoder;

    public RunLengthBitPackingHybridValuesWriter(int bitWidth, int initialCapacity, int pageSize) {
        this.encoder = new RunLengthBitPackingHybridEncoder(bitWidth, initialCapacity, pageSize);
    }

    @Override
    public void writeInteger(int v) {
        try {
            this.encoder.writeInt(v);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException(e2);
        }
    }

    @Override
    public void writeBoolean(boolean v) {
        this.writeInteger(v ? 1 : 0);
    }

    @Override
    public long getBufferedSize() {
        return this.encoder.getBufferedSize();
    }

    @Override
    public long getAllocatedSize() {
        return this.encoder.getAllocatedSize();
    }

    @Override
    public BytesInput getBytes() {
        try {
            BytesInput rle = this.encoder.toBytes();
            return BytesInput.concat(BytesInput.fromInt(Ints.checkedCast(rle.size())), rle);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException(e2);
        }
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.RLE;
    }

    @Override
    public void reset() {
        this.encoder.reset();
    }

    @Override
    public String memUsageString(String prefix) {
        return String.format("%s RunLengthBitPackingHybrid %d bytes", prefix, this.getAllocatedSize());
    }
}

