/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.HashCommon;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.AbstractDouble2IntFunction;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.Double2IntMap;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleSet;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.ObjectIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.ObjectSet;

public abstract class AbstractDouble2IntMap
extends AbstractDouble2IntFunction
implements Double2IntMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractDouble2IntMap() {
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Integer)ov);
    }

    @Override
    public boolean containsValue(int v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(double k2) {
        return this.keySet().contains(k2);
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Integer> m2) {
        int n2 = m2.size();
        Iterator<Map.Entry<? extends Double, ? extends Integer>> i2 = m2.entrySet().iterator();
        if (m2 instanceof Double2IntMap) {
            while (n2-- != 0) {
                Double2IntMap.Entry e2 = (Double2IntMap.Entry)i2.next();
                this.put(e2.getDoubleKey(), e2.getIntValue());
            }
        } else {
            while (n2-- != 0) {
                Map.Entry<? extends Double, ? extends Integer> e3 = i2.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet keySet() {
        return new AbstractDoubleSet(){

            @Override
            public boolean contains(double k2) {
                return AbstractDouble2IntMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractDouble2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2IntMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new AbstractDoubleIterator(){
                    final ObjectIterator<Map.Entry<Double, Integer>> i;
                    {
                        this.i = AbstractDouble2IntMap.this.entrySet().iterator();
                    }

                    @Override
                    public double nextDouble() {
                        return ((Double2IntMap.Entry)this.i.next()).getDoubleKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public IntCollection values() {
        return new AbstractIntCollection(){

            @Override
            public boolean contains(int k2) {
                return AbstractDouble2IntMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractDouble2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2IntMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new AbstractIntIterator(){
                    final ObjectIterator<Map.Entry<Double, Integer>> i;
                    {
                        this.i = AbstractDouble2IntMap.this.entrySet().iterator();
                    }

                    @Override
                    public int nextInt() {
                        return ((Double2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public ObjectSet<Map.Entry<Double, Integer>> entrySet() {
        return this.double2IntEntrySet();
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator i2 = this.entrySet().iterator();
        while (n2-- != 0) {
            h2 += ((Map.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i2 = this.entrySet().iterator();
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Double2IntMap.Entry e2 = (Double2IntMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getDoubleKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getIntValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static class BasicEntry
    implements Double2IntMap.Entry {
        protected double key;
        protected int value;

        public BasicEntry(Double key, Integer value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(double key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Double getKey() {
            return this.key;
        }

        @Override
        public double getDoubleKey() {
            return this.key;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public int getIntValue() {
            return this.value;
        }

        @Override
        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer setValue(Integer value) {
            return this.setValue((int)value);
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return this.key == (Double)e2.getKey() && this.value == (Integer)e2.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

