/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.HashCommon;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.AbstractFloat2IntFunction;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.Float2IntMap;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatSet;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.ObjectIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.ObjectSet;

public abstract class AbstractFloat2IntMap
extends AbstractFloat2IntFunction
implements Float2IntMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractFloat2IntMap() {
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Integer)ov);
    }

    @Override
    public boolean containsValue(int v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(float k2) {
        return this.keySet().contains(k2);
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Integer> m2) {
        int n2 = m2.size();
        Iterator<Map.Entry<? extends Float, ? extends Integer>> i2 = m2.entrySet().iterator();
        if (m2 instanceof Float2IntMap) {
            while (n2-- != 0) {
                Float2IntMap.Entry e2 = (Float2IntMap.Entry)i2.next();
                this.put(e2.getFloatKey(), e2.getIntValue());
            }
        } else {
            while (n2-- != 0) {
                Map.Entry<? extends Float, ? extends Integer> e3 = i2.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet keySet() {
        return new AbstractFloatSet(){

            @Override
            public boolean contains(float k2) {
                return AbstractFloat2IntMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractFloat2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2IntMap.this.clear();
            }

            @Override
            public FloatIterator iterator() {
                return new AbstractFloatIterator(){
                    final ObjectIterator<Map.Entry<Float, Integer>> i;
                    {
                        this.i = AbstractFloat2IntMap.this.entrySet().iterator();
                    }

                    @Override
                    public float nextFloat() {
                        return ((Float2IntMap.Entry)this.i.next()).getFloatKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public IntCollection values() {
        return new AbstractIntCollection(){

            @Override
            public boolean contains(int k2) {
                return AbstractFloat2IntMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractFloat2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2IntMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new AbstractIntIterator(){
                    final ObjectIterator<Map.Entry<Float, Integer>> i;
                    {
                        this.i = AbstractFloat2IntMap.this.entrySet().iterator();
                    }

                    @Override
                    public int nextInt() {
                        return ((Float2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public ObjectSet<Map.Entry<Float, Integer>> entrySet() {
        return this.float2IntEntrySet();
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator i2 = this.entrySet().iterator();
        while (n2-- != 0) {
            h2 += ((Map.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i2 = this.entrySet().iterator();
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Float2IntMap.Entry e2 = (Float2IntMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getFloatKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getIntValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static class BasicEntry
    implements Float2IntMap.Entry {
        protected float key;
        protected int value;

        public BasicEntry(Float key, Integer value) {
            this.key = key.floatValue();
            this.value = value;
        }

        public BasicEntry(float key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Float getKey() {
            return Float.valueOf(this.key);
        }

        @Override
        public float getFloatKey() {
            return this.key;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public int getIntValue() {
            return this.value;
        }

        @Override
        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer setValue(Integer value) {
            return this.setValue((int)value);
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return this.key == ((Float)e2.getKey()).floatValue() && this.value == (Integer)e2.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

