/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatIterators;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.ObjectIterators;

public abstract class AbstractFloatCollection
extends AbstractCollection<Float>
implements FloatCollection {
    protected AbstractFloatCollection() {
    }

    @Override
    public float[] toArray(float[] a2) {
        return this.toFloatArray(a2);
    }

    @Override
    public float[] toFloatArray() {
        return this.toFloatArray(null);
    }

    @Override
    public float[] toFloatArray(float[] a2) {
        if (a2 == null || a2.length < this.size()) {
            a2 = new float[this.size()];
        }
        FloatIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public boolean addAll(FloatCollection c2) {
        boolean retVal = false;
        FloatIterator i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (!this.add(i2.nextFloat())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean containsAll(FloatCollection c2) {
        FloatIterator i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (this.contains(i2.nextFloat())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(FloatCollection c2) {
        boolean retVal = false;
        int n2 = this.size();
        FloatIterator i2 = this.iterator();
        while (n2-- != 0) {
            if (c2.contains(i2.nextFloat())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(FloatCollection c2) {
        boolean retVal = false;
        int n2 = c2.size();
        FloatIterator i2 = c2.iterator();
        while (n2-- != 0) {
            if (!this.rem(i2.nextFloat())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public Object[] toArray() {
        Object[] a2 = new Object[this.size()];
        ObjectIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        if (a2.length < this.size()) {
            a2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public boolean addAll(Collection<? extends Float> c2) {
        boolean retVal = false;
        Iterator<? extends Float> i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (!this.add(i2.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean add(float k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public FloatIterator floatIterator() {
        return this.iterator();
    }

    @Override
    public abstract FloatIterator iterator();

    @Override
    public boolean remove(Object ok) {
        return this.rem(((Float)ok).floatValue());
    }

    @Override
    public boolean add(Float o2) {
        return this.add(o2.floatValue());
    }

    public boolean rem(Object o2) {
        return this.rem(((Float)o2).floatValue());
    }

    @Override
    public boolean contains(Object o2) {
        return this.contains(((Float)o2).floatValue());
    }

    @Override
    public boolean contains(float k2) {
        FloatIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k2 != iterator.nextFloat()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(float k2) {
        FloatIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k2 != iterator.nextFloat()) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        int n2 = c2.size();
        Iterator<?> i2 = c2.iterator();
        while (n2-- != 0) {
            if (this.contains(i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        boolean retVal = false;
        int n2 = this.size();
        FloatIterator i2 = this.iterator();
        while (n2-- != 0) {
            if (c2.contains(i2.next())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        boolean retVal = false;
        int n2 = c2.size();
        Iterator<?> i2 = c2.iterator();
        while (n2-- != 0) {
            if (!this.remove(i2.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        FloatIterator i2 = this.iterator();
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            float k2 = i2.nextFloat();
            s2.append(String.valueOf(k2));
        }
        s2.append("}");
        return s2.toString();
    }
}

