/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.behavior.accessrecord.domain;

import com.kingdee.bos.qing.behavior.accessrecord.dao.AccessRecordDao;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;

public class AccessRecordDomain {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private AccessRecordDao accessRecordDao;

    public AccessRecordDomain(ITransactionManagement tx, IDBExcuter dbExcuter, QingContext qingContext) {
        this.dbExcuter = dbExcuter;
        this.tx = tx;
        this.qingContext = qingContext;
    }

    public AccessRecordDao getRecordResourceDao() {
        if (this.accessRecordDao == null) {
            this.accessRecordDao = new AccessRecordDao(this.dbExcuter);
        }
        return this.accessRecordDao;
    }

    public void recordResourceOperation(String sourceId, String operationType, String pageId, String sourceType, String appType) {
        try {
            String userId = this.qingContext.getUserId();
            this.getRecordResourceDao().insertAccessRecord(userId, sourceId, operationType, pageId, sourceType, appType);
        }
        catch (Exception e) {
            LogUtil.error("insert access record error", e);
        }
    }

    public void deleteAccessRecord(String sourceId, String sourceType, String appType) throws AbstractQingIntegratedException, SQLException {
        this.getRecordResourceDao().deleteAccessRecord(sourceId, sourceType, appType);
    }
}

