/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.daterange;

import com.kingdee.bos.qing.common.daterange.RelativeDateRange;
import java.util.Calendar;

public class RuntimeRelativeDateRange {
    private static Long TestableTimestamp;
    private RelativeDateRange _relativeDateRange;
    private boolean _isDateTime;
    private long _dateStart;
    private long _dateEnd;

    public RuntimeRelativeDateRange(RelativeDateRange dateRange) {
        this(dateRange, false);
    }

    public RuntimeRelativeDateRange(RelativeDateRange relativeDateRange, boolean isDateTime) {
        this._relativeDateRange = relativeDateRange;
        this._isDateTime = isDateTime;
    }

    public long getDateStart() {
        return this._dateStart;
    }

    public long getDateEnd() {
        return this._dateEnd;
    }

    public long getDateEndOpenInterval() {
        return this._dateEnd + 1L;
    }

    public Calendar getCalendarStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this._dateStart);
        return calendar;
    }

    public Calendar getCalendarEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this._dateEnd);
        return calendar;
    }

    public Calendar getCalendarEndOpenInterval() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this._dateEnd + 1L);
        return calendar;
    }

    public void parseRange() {
        if (this._relativeDateRange == null) {
            throw new RuntimeException("There's no RelativeDateRange model.");
        }
        Calendar calendar1 = RuntimeRelativeDateRange.createCalendar();
        Calendar calendar2 = RuntimeRelativeDateRange.createCalendar();
        Long anchor = this._relativeDateRange.getAnchor();
        if (anchor != null) {
            calendar1.setTimeInMillis(anchor);
            calendar2.setTimeInMillis(anchor);
        }
        RelativeDateRange.RelativePeriodEnum period = this._relativeDateRange.getRelativePeriod();
        if (!(this._isDateTime || RelativeDateRange.RelativePeriodEnum.Hour != period && RelativeDateRange.RelativePeriodEnum.Minute != period)) {
            throw new RuntimeException("Invalid RelativeDateRange.");
        }
        Boolean upToNow = this._relativeDateRange.isUpToNow();
        if (upToNow.booleanValue()) {
            RuntimeRelativeDateRange.toBeginning(calendar1, period);
            if (!this._isDateTime) {
                RuntimeRelativeDateRange.toEnd(calendar2, RelativeDateRange.RelativePeriodEnum.Day);
            }
        } else {
            Integer whichPeriod = this._relativeDateRange.getWhichPeriod();
            if (whichPeriod == null) {
                Integer fromNowOn = this._relativeDateRange.getFromNowOn();
                if (fromNowOn == null || fromNowOn == 0) {
                    throw new RuntimeException("Invalid RelativeDateRange.");
                }
                if (fromNowOn > 0) {
                    RuntimeRelativeDateRange.offset(calendar2, period, fromNowOn);
                } else {
                    RuntimeRelativeDateRange.offset(calendar1, period, fromNowOn);
                }
            } else if (whichPeriod != 0) {
                RuntimeRelativeDateRange.offset(calendar1, period, whichPeriod);
                RuntimeRelativeDateRange.offset(calendar2, period, whichPeriod);
            }
            RuntimeRelativeDateRange.toBeginning(calendar1, period);
            RuntimeRelativeDateRange.toEnd(calendar2, period);
        }
        this._dateStart = calendar1.getTimeInMillis();
        this._dateEnd = calendar2.getTimeInMillis();
    }

    public static void setTestableTimestamp(Long ms) {
        TestableTimestamp = ms;
    }

    private static Calendar createCalendar() {
        Calendar calendar = Calendar.getInstance();
        if (TestableTimestamp != null) {
            calendar.setTimeInMillis(TestableTimestamp);
        }
        return calendar;
    }

    private static void offset(Calendar calendar, RelativeDateRange.RelativePeriodEnum period, int n) {
        switch (period) {
            case Year: {
                calendar.add(1, n);
                break;
            }
            case Quarter: {
                calendar.add(2, n * 3);
                break;
            }
            case Month: {
                calendar.add(2, n);
                break;
            }
            case Week: {
                calendar.add(5, n * 7);
                break;
            }
            case Day: {
                calendar.add(5, n);
                break;
            }
            case Hour: {
                calendar.add(11, n);
                break;
            }
            case Minute: {
                calendar.add(12, n);
                break;
            }
            default: {
                throw new RuntimeException("Unknown Period");
            }
        }
    }

    private static void toBeginning(Calendar calendar, RelativeDateRange.RelativePeriodEnum period) {
        int year = calendar.get(1);
        switch (period) {
            case Year: {
                calendar.set(year, 0, 1);
                break;
            }
            case Quarter: {
                int month = calendar.get(2) / 3 * 3;
                calendar.set(year, month, 1);
                break;
            }
            case Month: {
                calendar.set(5, 1);
                break;
            }
            case Week: {
                calendar.set(7, RuntimeRelativeDateRange.getFirstDayOfWeek(calendar));
                break;
            }
        }
        switch (period) {
            case Year: 
            case Quarter: 
            case Month: 
            case Week: 
            case Day: {
                calendar.set(11, 0);
            }
            case Hour: {
                calendar.set(12, 0);
            }
            case Minute: {
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
        }
    }

    private static Calendar toEnd(Calendar calendar, RelativeDateRange.RelativePeriodEnum period) {
        int year = calendar.get(1);
        switch (period) {
            case Year: {
                calendar.set(year, 11, 31);
                break;
            }
            case Quarter: {
                int month = calendar.get(2) / 3 * 3 + 2;
                calendar.set(year, month, 1);
                int day = calendar.getActualMaximum(5);
                calendar.set(5, day);
                break;
            }
            case Month: {
                int day = calendar.getActualMaximum(5);
                calendar.set(5, day);
                break;
            }
            case Week: {
                calendar.set(7, RuntimeRelativeDateRange.getFirstDayOfWeek(calendar));
                calendar.add(5, 6);
                break;
            }
        }
        switch (period) {
            case Year: 
            case Quarter: 
            case Month: 
            case Week: 
            case Day: {
                calendar.set(11, 23);
            }
            case Hour: {
                calendar.set(12, 59);
            }
            case Minute: {
                calendar.set(13, 59);
                calendar.set(14, 999);
            }
        }
        return calendar;
    }

    private static int getFirstDayOfWeek(Calendar calendar) {
        calendar.setFirstDayOfWeek(2);
        return 2;
    }
}

