/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.resource;

import com.kingdee.bos.qing.common.distribute.resource.IServerNodeChangedListener;
import com.kingdee.bos.qing.util.NetUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class QingServerNodeObserver {
    private List<IServerNodeChangedListener> nodeChangedListeners = new ArrayList<IServerNodeChangedListener>();
    protected AtomicBoolean isUsable = new AtomicBoolean(false);
    private String localIp = NetUtil.getLocalHostIp();

    public String getLocalIp() {
        return this.localIp;
    }

    public void addListener(IServerNodeChangedListener nodeChangedListener) {
        this.nodeChangedListeners.add(nodeChangedListener);
        Set<String> all = this.getAllServerNodeIps();
        all.remove(this.localIp);
        this.notifyInitialise(all);
    }

    protected void notifyServerRemove(String removeIp) {
        for (IServerNodeChangedListener listener : this.nodeChangedListeners) {
            listener.onServerRemove(removeIp);
        }
    }

    protected void notifyServerAdd(String serverIp) {
        for (IServerNodeChangedListener listener : this.nodeChangedListeners) {
            listener.onServerAdd(serverIp);
        }
    }

    protected void notifyInitialise(Set<String> otherServerIps) {
        for (IServerNodeChangedListener listener : this.nodeChangedListeners) {
            listener.onServerInitialise(otherServerIps);
        }
    }

    public abstract Set<String> getAllServerNodeIps();

    public abstract void initialize();
}

