/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.task;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.distribute.exception.TaskTransportException;
import com.kingdee.bos.qing.common.distribute.resource.ServerResourceMgr;
import com.kingdee.bos.qing.common.distribute.task.AbstractTaskChannel;
import com.kingdee.bos.qing.common.distribute.task.RemoteSubmitState;
import com.kingdee.bos.qing.common.distribute.task.TaskEvent;
import com.kingdee.bos.qing.common.distribute.task.TaskEventType;
import com.kingdee.bos.qing.common.distribute.task.TaskRequest;
import com.kingdee.bos.qing.common.distribute.task.TaskResponse;
import com.kingdee.bos.qing.common.distribute.task.TimeoutTaskReExecutor;
import com.kingdee.bos.qing.common.framework.model.QingServiceAsynDispatcherModel;
import com.kingdee.bos.qing.common.thread.GlobalScheduledExecutor;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.NetUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;

public class DistributeTaskMgr {
    public static final String TASK_LOG_INFO_PREFIX = "QingDistributeTask--";
    public static final String TASK_STATUS_KEY_PREFIX = "Distribute.QingTask-";
    private static final DistributeTaskMgr instance = new DistributeTaskMgr();
    private Map<String, AbstractTaskChannel> taskChannels = new HashMap<String, AbstractTaskChannel>(10);
    private String localIp;
    private volatile boolean isOpened = false;
    private ServerResourceMgr serverResourceMgr = ServerResourceMgr.getInstance();

    private DistributeTaskMgr() {
        boolean isEnable;
        this.isOpened = isEnable = SystemPropertyUtil.getBoolean("qing.distribute.task.enable", false);
        this.localIp = NetUtil.getLocalHostIp();
    }

    public static DistributeTaskMgr getInstance() {
        return instance;
    }

    public String getAppId() {
        return "appId";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regNewTaskChannel(String serverIp, AbstractTaskChannel taskChannel) {
        Map<String, AbstractTaskChannel> map = this.taskChannels;
        synchronized (map) {
            this.taskChannels.put(serverIp, taskChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskChannelExist(String serverIp) {
        Map<String, AbstractTaskChannel> map = this.taskChannels;
        synchronized (map) {
            return this.taskChannels.containsKey(serverIp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractTaskChannel getTaskChannel(String serverIp) {
        Map<String, AbstractTaskChannel> map = this.taskChannels;
        synchronized (map) {
            return this.taskChannels.get(serverIp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractTaskChannel removeAndCloseChannel(String serverIp) {
        AbstractTaskChannel taskChannel = null;
        Map<String, AbstractTaskChannel> map = this.taskChannels;
        synchronized (map) {
            taskChannel = this.taskChannels.remove(serverIp);
        }
        if (null != taskChannel) {
            taskChannel.close();
        }
        return taskChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractTaskChannel getFastestAckedChannel(String sessionId, String threadPoolName, long maxCosts) {
        HashSet<AbstractTaskChannel> taskChannelSet = new HashSet<AbstractTaskChannel>(5);
        Map<String, AbstractTaskChannel> map = this.taskChannels;
        synchronized (map) {
            taskChannelSet.addAll(this.taskChannels.values());
        }
        AbstractTaskChannel fastestChannel = null;
        long leastCosts = 0L;
        for (AbstractTaskChannel taskChannel : taskChannelSet) {
            long costs;
            if (taskChannel.isRecentBlockExist(sessionId, threadPoolName) || -1L == (costs = taskChannel.selectRecentRemoteCosts(sessionId, threadPoolName))) continue;
            if (null == fastestChannel) {
                fastestChannel = taskChannel;
                leastCosts = costs;
                continue;
            }
            if (costs >= leastCosts) continue;
            leastCosts = costs;
            fastestChannel = taskChannel;
        }
        if (fastestChannel != null && leastCosts < maxCosts) {
            return fastestChannel;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDispatch() {
        int size = 0;
        Map<String, AbstractTaskChannel> map = this.taskChannels;
        synchronized (map) {
            size = this.taskChannels.size();
        }
        return this.isOpened && size >= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteSubmitState directExecuteTask(QingContext qingContext, QingServiceAsynDispatcherModel dispatcherModel, String targetServerIp) {
        AbstractTaskChannel taskChannel = null;
        Map<String, AbstractTaskChannel> map = this.taskChannels;
        synchronized (map) {
            taskChannel = this.taskChannels.get(targetServerIp);
        }
        if (null == taskChannel) {
            return RemoteSubmitState.ERR_NO_AVAILABLE_CHANNEL;
        }
        TaskEvent taskEvent = new TaskEvent();
        taskEvent.setEventType(TaskEventType.SUBMIT);
        taskEvent.setTaskId(UUID.randomUUID().toString());
        TaskRequest request = new TaskRequest();
        request.setFromServer(this.localIp);
        request.setTaskModel(dispatcherModel);
        request.setQingContext(qingContext);
        taskEvent.setData(request);
        try {
            RemoteSubmitState submitState = taskChannel.publishTask(qingContext, taskEvent);
            switch (submitState) {
                case SUCCEED: {
                    if (dispatcherModel.getSourceServer() != null) break;
                    GlobalScheduledExecutor.schedule(new TimeoutTaskReExecutor(taskEvent, taskChannel));
                }
            }
            return submitState;
        }
        catch (TaskTransportException e) {
            LogUtil.error("", e);
            return RemoteSubmitState.ERR_SUBMIT_FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteSubmitState remoteExecuteTask(QingContext qingContext, QingServiceAsynDispatcherModel dispatcherModel, ThreadPoolManage.QingThreadPoolName threadPoolName) {
        if (!this.isOpened) {
            return RemoteSubmitState.ERR_NOT_OPEN;
        }
        AbstractTaskChannel bestChannel = this.getFastestAckedChannel(qingContext.getSessionID(), threadPoolName.name(), 1000L);
        if (null == bestChannel) {
            String serverIp = this.serverResourceMgr.getBestResourceServer(threadPoolName);
            if (null == serverIp) {
                return RemoteSubmitState.ERR_NO_AVAILABLE_CHANNEL;
            }
            Map<String, AbstractTaskChannel> map = this.taskChannels;
            synchronized (map) {
                bestChannel = this.taskChannels.get(serverIp);
            }
            if (!bestChannel.isAvailable() || bestChannel.isRecentBlockExist(qingContext.getSessionID(), threadPoolName.name())) {
                bestChannel = null;
            }
        }
        if (null != bestChannel) {
            TaskEvent taskEvent = new TaskEvent();
            taskEvent.setEventType(TaskEventType.SUBMIT);
            taskEvent.setTaskId(UUID.randomUUID().toString());
            TaskRequest request = new TaskRequest();
            request.setFromServer(this.localIp);
            request.setTaskModel(dispatcherModel);
            taskEvent.setData(request);
            try {
                RemoteSubmitState remoteSubmitState = bestChannel.publishTask(qingContext, taskEvent);
                switch (remoteSubmitState) {
                    case SUCCEED: {
                        if (dispatcherModel.getSourceServer() != null) break;
                        GlobalScheduledExecutor.schedule(new TimeoutTaskReExecutor(taskEvent, bestChannel));
                    }
                }
                return remoteSubmitState;
            }
            catch (TaskTransportException e) {
                LogUtil.error("", e);
                return RemoteSubmitState.ERR_SUBMIT_FAILED;
            }
        }
        return RemoteSubmitState.ERR_NO_AVAILABLE_CHANNEL;
    }

    public String getLocalIp() {
        return this.localIp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTaskResponse(String sourceServer, String taskId, TaskResponse response) {
        AbstractTaskChannel taskChannel = null;
        Map<String, AbstractTaskChannel> map = this.taskChannels;
        synchronized (map) {
            taskChannel = this.taskChannels.get(sourceServer);
        }
        if (null != taskChannel) {
            taskChannel.receiveTaskResponse(taskId, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTaskResponse(String sourceServer, TaskEvent response) {
        AbstractTaskChannel taskChannel = null;
        Map<String, AbstractTaskChannel> map = this.taskChannels;
        synchronized (map) {
            taskChannel = this.taskChannels.get(sourceServer);
        }
        if (null != taskChannel) {
            try {
                taskChannel.sendTaskResponse(response);
            }
            catch (TaskTransportException e) {
                LogUtil.error("", e);
            }
        }
    }
}

