/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.task;

import com.kingdee.bos.qing.common.distribute.task.TaskEvent;
import com.kingdee.bos.qing.common.distribute.task.TaskResponse;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RemoteTaskRecorder {
    private String sessionId;
    private Map<String, Long> recentResponseReceiveTime = new HashMap<String, Long>(10);
    private Map<String, Long> remoteTaskBlockedTime = new HashMap<String, Long>(10);
    private Map<String, Long> waitingTimeFromSubmitToBegin = new HashMap<String, Long>(10);
    private Map<String, TaskEvent> remoteSubmittedTasks = new HashMap<String, TaskEvent>(10);
    private Set<String> remoteExecutingTasks = new HashSet<String>(10);
    private Map<String, Long> taskPublishTimeMap = new HashMap<String, Long>(10);
    private Map<String, Integer> threadBlockSize = new HashMap<String, Integer>(3);

    public RemoteTaskRecorder(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public synchronized void updateThreadBlockSize(String threadPoolName, int blockSize) {
        this.threadBlockSize.put(threadPoolName, blockSize);
    }

    public synchronized void recordNewPublishedTask(TaskEvent taskEvent) {
        String taskId = taskEvent.getTaskId();
        this.remoteSubmittedTasks.put(taskId, taskEvent);
        this.taskPublishTimeMap.put(taskId, System.currentTimeMillis());
    }

    public synchronized void updateFinishedTask(String taskId) {
        this.remoteSubmittedTasks.remove(taskId);
        this.remoteExecutingTasks.remove(taskId);
    }

    public synchronized void clearSubmittedTaskForTimeout(String taskId) {
        LogUtil.warn("QingDistributeTask--clear record info for time out task,taskId:" + taskId);
        this.remoteSubmittedTasks.remove(taskId);
        this.taskPublishTimeMap.remove(taskId);
    }

    public synchronized void handlePublishError(String taskId) {
        this.remoteSubmittedTasks.remove(taskId);
        this.remoteExecutingTasks.remove(taskId);
    }

    public synchronized List<TaskEvent> getUnExecuteTasks() {
        ArrayList<TaskEvent> events = new ArrayList<TaskEvent>(10);
        events.addAll(this.remoteSubmittedTasks.values());
        return events;
    }

    public synchronized boolean isExecuting(String taskId) {
        return this.remoteExecutingTasks.contains(taskId);
    }

    public synchronized void updateBlockedTask(TaskResponse taskResponse) {
        String threadPoolName = taskResponse.getThreadPoolName();
        long recentTaskBlockedTime = System.currentTimeMillis();
        this.remoteTaskBlockedTime.put(threadPoolName, recentTaskBlockedTime);
    }

    public synchronized void updateBlockSize(TaskResponse taskResponse) {
        this.threadBlockSize.clear();
        this.threadBlockSize.putAll(taskResponse.getThreadWaitingTaskInSession());
    }

    public synchronized boolean isRecentBlockedExist(String threadPoolName) {
        Integer blockSize = this.threadBlockSize.get(threadPoolName);
        return null != blockSize && blockSize != 0;
    }

    public synchronized void updateBeginningTask(String taskId, TaskResponse response) {
        String threadPoolName = response.getThreadPoolName();
        long recentTaskResponseTime = System.currentTimeMillis();
        this.recentResponseReceiveTime.put(threadPoolName, recentTaskResponseTime);
        Long publishTime = this.taskPublishTimeMap.get(taskId);
        if (null != publishTime) {
            long costs = recentTaskResponseTime - publishTime;
            this.waitingTimeFromSubmitToBegin.put(threadPoolName, costs);
        } else {
            LogUtil.warn("QingDistributeTask--taskPublishTime not found\uff0ctaskId:" + taskId);
        }
        TaskEvent taskEvent = this.remoteSubmittedTasks.remove(taskId);
        if (null != taskEvent) {
            this.remoteExecutingTasks.add(taskId);
        }
        this.threadBlockSize.clear();
        this.threadBlockSize.putAll(response.getThreadWaitingTaskInSession());
    }

    public synchronized TaskEvent getTaskEvent(String taskId) {
        return this.remoteSubmittedTasks.get(taskId);
    }

    public synchronized long getRecentTaskCosts(String threadPoolName) {
        Long recentResponseTimeStamp = this.recentResponseReceiveTime.get(threadPoolName);
        if (null == recentResponseTimeStamp) {
            return -1L;
        }
        long currentTime = System.currentTimeMillis();
        long duration = currentTime - recentResponseTimeStamp;
        if (duration >= 1000L) {
            return -1L;
        }
        Long recentTaskCosts = this.waitingTimeFromSubmitToBegin.get(threadPoolName);
        if (null == recentTaskCosts) {
            return -1L;
        }
        return recentTaskCosts;
    }
}

