/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.task;

import com.kingdee.bos.qing.common.distribute.session.UserRequestSession;
import com.kingdee.bos.qing.common.distribute.task.DistributeTaskMgr;
import com.kingdee.bos.qing.common.distribute.task.TaskEvent;
import com.kingdee.bos.qing.common.distribute.task.TaskEventType;
import com.kingdee.bos.qing.common.distribute.task.TaskResponse;
import com.kingdee.bos.qing.common.framework.server.task.AsynServerRequestInvokeTask;
import com.kingdee.bos.qing.common.framework.server.task.IThreadTaskInvokeListener;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.thread.ThreadPoolMonitor;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.concurrent.TimeUnit;

public class TaskInvokeListenerImpl
implements IThreadTaskInvokeListener {
    private long taskBeginTime = -1L;
    private ThreadPoolManage.QingThreadPoolName invokeThreadPoolName;
    private UserRequestSession userSession;

    public TaskInvokeListenerImpl(ThreadPoolManage.QingThreadPoolName invokeThreadPoolName, UserRequestSession requestSession) {
        this.invokeThreadPoolName = invokeThreadPoolName;
        this.userSession = requestSession;
    }

    @Override
    public boolean onTaskBegin(AsynServerRequestInvokeTask task) {
        this.taskBeginTime = System.currentTimeMillis();
        String sourceServer = task.getSourceServer();
        String taskId = task.getTaskId();
        if (null != sourceServer) {
            String taskStatusKey = "Distribute.QingTask-" + taskId;
            long statusValue = QingSessionUtil.getGlobalQingSessionImpl().incrBy(taskStatusKey, 1);
            if (statusValue != 1L) {
                LogUtil.info("remote task abandoned by source server,taskId:" + taskId + ",source server:" + sourceServer);
                QingSessionUtil.getGlobalQingSessionImpl().remove(taskStatusKey);
                return false;
            }
            TaskResponse response = new TaskResponse();
            response.setStateCode(1);
            response.setRemoteServer(DistributeTaskMgr.getInstance().getLocalIp());
            response.setThreadPoolName(task.getThreadPoolName().name());
            ThreadPoolMonitor.ThreadPoolStatistic statistic = ThreadPoolMonitor.getInstance().getThreadPoolStatistic(task.getThreadPoolName());
            if (null != statistic) {
                response.setCurrentRunningSize(statistic.getRunningSize());
            }
            response.setSessionId(task.getContext().getSessionID());
            response.setThreadWaitingTaskInSession(this.userSession.threadBlockSize());
            TaskEvent taskEvent = new TaskEvent();
            taskEvent.setTaskId(taskId);
            taskEvent.setEventType(TaskEventType.RESPONSE);
            taskEvent.setData(response);
            DistributeTaskMgr.getInstance().sendTaskResponse(sourceServer, taskEvent);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskFinished(AsynServerRequestInvokeTask task) {
        try {
            String sourceServer = task.getSourceServer();
            if (null != sourceServer) {
                this.sendTaskFinishedResponse(task, this.userSession, sourceServer);
            }
            ServerRequestInvokeContext invokeContext = task.getInvokeContext();
            if (this.taskBeginTime != -1L && invokeContext.isNeedCalcCosts()) {
                long costs = System.currentTimeMillis() - this.taskBeginTime;
                if (costs > 5000L && this.invokeThreadPoolName == ThreadPoolManage.QingThreadPoolName.QING_SHORT_TIME_TASK_HANDLER) {
                    LogUtil.info("task spent time: " + costs + ", " + task.getTaskDesc());
                }
                UserRequestSession.ReqInvokeStatistic invokeStatistic = this.userSession.getReqStatistic(this.invokeThreadPoolName.name());
                invokeStatistic.refreshAvgCosts(costs);
                this.userSession.refreshThreadMaxUsage(this.invokeThreadPoolName.name(), invokeStatistic.getAvgCostsMs());
            }
        }
        finally {
            this.userSession.releaseToken(this.invokeThreadPoolName);
        }
    }

    private void sendTaskFinishedResponse(AsynServerRequestInvokeTask task, UserRequestSession requestSession, String sourceServer) {
        String taskStatusKey = "Distribute.QingTask-" + task.getTaskId();
        QingSessionUtil.getGlobalQingSessionImpl().expireAfter(taskStatusKey, 5, TimeUnit.MINUTES);
        TaskResponse response = new TaskResponse();
        response.setStateCode(2);
        response.setRemoteServer(DistributeTaskMgr.getInstance().getLocalIp());
        response.setThreadPoolName(task.getThreadPoolName().name());
        ThreadPoolMonitor.ThreadPoolStatistic statistic = ThreadPoolMonitor.getInstance().getThreadPoolStatistic(task.getThreadPoolName());
        if (null != statistic) {
            response.setCurrentRunningSize(statistic.getRunningSize() - 1);
        }
        response.setThreadWaitingTaskInSession(requestSession.threadBlockSize());
        response.setSessionId(task.getContext().getSessionID());
        TaskEvent taskEvent = new TaskEvent();
        taskEvent.setTaskId(task.getTaskId());
        taskEvent.setEventType(TaskEventType.RESPONSE);
        taskEvent.setData(response);
        DistributeTaskMgr.getInstance().sendTaskResponse(sourceServer, taskEvent);
    }
}

