/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.zk;

import com.kingdee.bos.qing.common.distribute.zk.ZKEnviroment;
import com.kingdee.bos.qing.common.distribute.zk.ZKProvider;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZKClient {
    private CuratorFramework client;
    private ZKEnviroment zkEnviroment;
    private static final String LOCK_TYPE = "funs";
    private static ConcurrentMap<String, String> accountBasePath = new ConcurrentHashMap<String, String>();
    private static final String UTF8 = "UTF-8";

    public ZKClient(ZKProvider provider) {
        this.client = provider.getClient();
        this.zkEnviroment = provider.getEnviroment();
    }

    public String createBasePath() throws AbstractQingException {
        String accountId = this.zkEnviroment.getLockSeperatorNode();
        String basePathKey = String.format("%s_%s", accountId, LOCK_TYPE);
        if (!accountBasePath.containsKey(basePathKey)) {
            String accountPath = this.zkEnviroment.getMutexLockPath() + "/" + accountId;
            this.createPersistentEmptyNode(accountPath);
            String basePath = accountPath + "/" + LOCK_TYPE;
            this.createPersistentEmptyNode(basePath);
            accountBasePath.put(basePathKey, basePath);
        }
        return (String)accountBasePath.get(basePathKey);
    }

    private void createPersistentEmptyNode(String path) throws AbstractQingException {
        if (!this.existed(path)) {
            this.createIgnoreExist(path, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    public String createIgnoreExist(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws AbstractQingException {
        try {
            return (String)((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(createMode)).withACL(acl)).forPath(path, data);
        }
        catch (KeeperException.NodeExistsException e) {
            return null;
        }
        catch (Exception e) {
            throw new QingLockRequireException(e.getMessage(), e);
        }
    }

    private boolean existed(String path) throws AbstractQingException {
        try {
            return this.client.checkExists().forPath(path) != null;
        }
        catch (Exception e) {
            throw new QingLockRequireException(e.getMessage(), e);
        }
    }

    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws AbstractQingException {
        try {
            return (String)((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(createMode)).withACL(acl)).forPath(path, data);
        }
        catch (Exception e) {
            throw new QingLockRequireException(e.getMessage(), e);
        }
    }

    public List<String> getChildren(String path) throws AbstractQingException {
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (Exception e) {
            throw new QingLockRequireException(e.getMessage(), e);
        }
    }

    public ExistsBuilder checkExists() {
        return this.client.checkExists();
    }

    public GetChildrenBuilder getChildrenBuiler() {
        return this.client.getChildren();
    }

    public void delete(String path, int value) throws AbstractQingException {
        try {
            ((BackgroundPathable)this.client.delete().withVersion(value)).forPath(path);
        }
        catch (Exception e) {
            throw new QingLockRequireException(e.getMessage(), e);
        }
    }

    public void setData(String path, String data, int version) throws AbstractQingException {
        try {
            ((BackgroundPathAndBytesable)this.client.setData().withVersion(version)).forPath(path, data.getBytes(UTF8));
        }
        catch (Exception e) {
            throw new QingLockRequireException(e.getMessage(), e);
        }
    }

    public String getDataWithWather(String path, Watcher wather) throws AbstractQingException {
        try {
            byte[] datas = (byte[])((BackgroundPathable)this.client.getData().usingWatcher(wather)).forPath(path);
            return new String(datas, UTF8);
        }
        catch (Exception e) {
            throw new QingLockRequireException(e.getMessage(), e);
        }
    }

    public String getDataWithVersion(String path, Stat stat) {
        try {
            byte[] datas = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(path);
            return new String(datas, UTF8);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getData(String path) {
        try {
            byte[] datas = (byte[])this.client.getData().forPath(path);
            return new String(datas, UTF8);
        }
        catch (Exception e) {
            return null;
        }
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public ZKEnviroment getZkEnviroment() {
        return this.zkEnviroment;
    }
}

