/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.zk.lock;

import com.kingdee.bos.qing.common.distribute.zk.lock.ZkInternalLock;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.LockInternals;
import org.apache.curator.framework.recipes.locks.LockInternalsDriver;
import org.apache.curator.framework.recipes.locks.LockInternalsSorter;
import org.apache.curator.framework.recipes.locks.StandardLockInternalsDriver;
import org.apache.curator.utils.PathUtils;

class ZkInternalMutex
implements InterProcessLock {
    private final ZkInternalLock internals;
    private final String basePath;
    private final ConcurrentMap<Thread, LockData> threadData = new ConcurrentHashMap<Thread, LockData>();
    private static final String LOCK_NAME = "lock-";

    public ZkInternalMutex(CuratorFramework client, String path) {
        this(client, path, (LockInternalsDriver)new StandardLockInternalsDriver());
    }

    public ZkInternalMutex(CuratorFramework client, String path, LockInternalsDriver driver) {
        this(client, path, LOCK_NAME, 1, driver);
    }

    public void acquire() throws AbstractQingException {
        if (!this.internalLock(-1L, null)) {
            throw new QingLockRequireException("Lost connection while trying to acquire lock: " + this.basePath);
        }
    }

    public boolean acquire(long time, TimeUnit unit) throws AbstractQingException {
        return this.internalLock(time, unit);
    }

    public boolean isAcquiredInThisProcess() {
        return this.threadData.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws AbstractQingException {
        Thread currentThread = Thread.currentThread();
        LockData lockData = (LockData)this.threadData.get(currentThread);
        if (lockData == null) {
            throw new IllegalMonitorStateException("You do not own the lock: " + this.basePath);
        }
        int newLockCount = lockData.lockCount.decrementAndGet();
        if (newLockCount > 0) {
            return;
        }
        if (newLockCount < 0) {
            throw new IllegalMonitorStateException("Lock count has gone negative for lock: " + this.basePath);
        }
        try {
            this.internals.releaseLock(lockData.lockPath);
        }
        finally {
            this.threadData.remove(currentThread);
        }
    }

    public Collection<String> getParticipantNodes() throws AbstractQingException {
        try {
            return LockInternals.getParticipantNodes((CuratorFramework)this.internals.getClient(), (String)this.basePath, (String)this.internals.getLockName(), (LockInternalsSorter)this.internals.getDriver());
        }
        catch (Exception e) {
            throw new QingLockRequireException(e.getMessage(), e);
        }
    }

    ZkInternalMutex(CuratorFramework client, String path, String lockName, int maxLeases, LockInternalsDriver driver) {
        this.basePath = PathUtils.validatePath((String)path);
        this.internals = new ZkInternalLock(client, driver, path, lockName, maxLeases);
    }

    public boolean isOwnedByCurrentThread() {
        LockData lockData = (LockData)this.threadData.get(Thread.currentThread());
        return lockData != null && lockData.lockCount.get() > 0;
    }

    protected byte[] getLockNodeBytes() {
        return null;
    }

    protected String getLockPath() {
        LockData lockData = (LockData)this.threadData.get(Thread.currentThread());
        return lockData != null ? lockData.lockPath : null;
    }

    private boolean internalLock(long time, TimeUnit unit) throws AbstractQingException {
        Thread currentThread = Thread.currentThread();
        LockData lockData = (LockData)this.threadData.get(currentThread);
        if (lockData != null) {
            lockData.lockCount.incrementAndGet();
            return true;
        }
        String lockPath = this.internals.attemptLock(time, unit, this.getLockNodeBytes());
        if (lockPath != null) {
            LockData newLockData = new LockData(currentThread, lockPath);
            this.threadData.put(currentThread, newLockData);
            return true;
        }
        return false;
    }

    private static class LockData {
        final Thread owningThread;
        final String lockPath;
        final AtomicInteger lockCount = new AtomicInteger(1);

        private LockData(Thread owningThread, String lockPath) {
            this.owningThread = owningThread;
            this.lockPath = lockPath;
        }
    }
}

