/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.manage;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.manage.AbstractClientCache;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.IResourceLock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.ResourceLockFactory;
import com.kingdee.bos.qing.common.lock.model.ClientResourceMapping;
import com.kingdee.bos.qing.common.lock.model.ResourceOccupancy;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.framework.IClientClosedStrategy;
import com.kingdee.bos.qing.msgbus.QingIframeNodeHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import com.kingdee.bos.qing.util.URLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientManager
extends AbstractClientCache {
    private static final String CLIENT_ALIVE_KEY = "ClientLastCheckTimestampByBrowser";
    private static final String CLIENT_CLOSED_KEY = "ClientClosed";
    private static final String CLIENT_MAP_KEY = "Client.Map";
    private static final String CLIENT_MAP_LOCK_KEY = "Qing.Client.Map.Lock.";
    private static final String PAGE_CLIENT_MAPPING_KEY = "Qing.Page.Client.Mapping.";
    public static final String CLIENT_APPID_KEY = "Client.AppID.";
    public static final String CLIENT_ATTRIBUTE_KEY_SESSIONID = "SessionID";
    public static final String CLIENT_ATTRIBUTE_KEY_USERID = "UserID";
    public static final String CLIENT_ATTRIBUTE_KEY_NEWOPENCLIENT = "NewOpenClient";
    public static final String CLIENT_ATTRIBUTE_KEY_TITLE = "Title";
    public static final String CLIENT_ATTRIBUTE_KEY_TARGETURL = "TargetURL";
    public static final String CLIENT_ATTRIBUTE_KEY_SAFETYCODE = "SafetyCode";
    public static final String CLIENT_ATTRIBUTE_KEY_SAFETYURL = "SafetyURL";
    public static final String CLOSE_CLIENT_ON_UPDATE_NEW_CLIENT = "Qing.need.remove.closedClient";
    private static final long CLIENTTIMEOUTMILLIS = SystemPropertyUtil.getLong("Qing.Client.Timeout", 120000L);
    private static List<IUpdateClientTimestapListener> updateClientTimestapListeners = new ArrayList<IUpdateClientTimestapListener>();

    public static void setClientAlive(QingContext qingContext, Collection<String> clientIDs) {
        if (clientIDs != null && clientIDs.size() > 0) {
            long lastVisitTimestap = System.currentTimeMillis();
            for (String clientID : clientIDs) {
                if (!StringUtils.isNotBlank(clientID)) continue;
                String cacheKey = ClientManager.getCacheKey(clientID);
                ClientManager.setClientAlive(qingContext, cacheKey, lastVisitTimestap);
            }
        }
        ClientManager.fireUpdateClientTimestap(qingContext);
    }

    private static void setClientAlive(QingContext qingContext, String cacheKey, long lastVisitTimestap) {
        IGlobalQingSession globalQingSession = ClientManager.getGlobalQingSession();
        globalQingSession.hRemove(cacheKey, CLIENT_CLOSED_KEY);
        globalQingSession.hSet(cacheKey, CLIENT_ALIVE_KEY, lastVisitTimestap + "");
        globalQingSession.hSet(cacheKey, CLIENT_ATTRIBUTE_KEY_SESSIONID, qingContext.getSessionID());
        globalQingSession.hSet(cacheKey, CLIENT_ATTRIBUTE_KEY_USERID, qingContext.getUserId());
        globalQingSession.expireAfter(CLIENT_APPID_KEY + cacheKey.substring("Qing.Client.".length()), 300, TimeUnit.SECONDS);
    }

    public static void setClientClosed(QingContext qingContext, Collection<String> clientIDs) {
        IClientClosedStrategy clientClosedStrategyImpl = CustomStrategyRegistrar.getStrategy(IClientClosedStrategy.class);
        if (clientIDs != null && !clientIDs.isEmpty()) {
            IGlobalQingSession globalQingSession = ClientManager.getGlobalQingSession();
            for (String clientID : clientIDs) {
                if (!StringUtils.isNotBlank(clientID)) continue;
                String cacheKey = ClientManager.getCacheKey(clientID);
                String appID = globalQingSession.get(CLIENT_APPID_KEY + clientID);
                String string = appID = appID == null ? "qing" : appID;
                if (clientClosedStrategyImpl != null) {
                    clientClosedStrategyImpl.closeClient(qingContext, appID, clientID);
                }
                globalQingSession.hSet(cacheKey, CLIENT_CLOSED_KEY, "TRUE");
            }
            ClientManager.removeClientMap(qingContext, clientIDs);
            ClientManager.unlockResources(clientIDs);
            QingIframeNodeHelper.inactivateNode(clientIDs, qingContext);
        }
    }

    private static void unlockResources(Collection<String> clientIds) {
        ResourceOccupancy resourceOccupancy = ClientManager.getGlobalQingSession().getCache("Qing.ResourceOccupancy", ResourceOccupancy.class);
        if (resourceOccupancy == null) {
            return;
        }
        Set<ClientResourceMapping> clientResourceMappings = resourceOccupancy.getClientResourceMappings();
        block0: for (String clientId : clientIds) {
            for (ClientResourceMapping clientResourceMapping : clientResourceMappings) {
                if (!clientId.equals(clientResourceMapping.getClientId())) continue;
                IResourceLock resourceLock = ResourceLockFactory.createLock(clientResourceMapping.getLockType(), clientResourceMapping.getLockKey(), clientResourceMapping.getIsStrict());
                resourceLock.unlock(clientResourceMapping.getResourceId());
                LogUtil.info("Resource occupancy: clientManager release resource successfully! The mapping: " + clientResourceMapping.toString());
                continue block0;
            }
        }
    }

    public static boolean isClientClosed(String clientID, boolean defaultStateIfNotExist, Map<String, Boolean> clientsClosed) {
        Boolean isClientClosed;
        if (clientsClosed != null && (isClientClosed = clientsClosed.get(clientID)) != null) {
            return isClientClosed;
        }
        if (StringUtils.isBlank(clientID)) {
            if (clientsClosed != null) {
                clientsClosed.put(clientID, true);
            }
            return true;
        }
        String cacheKey = ClientManager.getCacheKey(clientID);
        IGlobalQingSession globalQingSession = ClientManager.getGlobalQingSession();
        long currentTimeMillis = System.currentTimeMillis();
        String clientStatus = globalQingSession.hGet(cacheKey, CLIENT_CLOSED_KEY);
        if (clientStatus != null && "TRUE".equals(clientStatus)) {
            if (clientsClosed != null) {
                clientsClosed.put(clientID, true);
            }
            return true;
        }
        clientStatus = globalQingSession.hGet(cacheKey, CLIENT_ALIVE_KEY);
        if (clientStatus != null) {
            long lastVisitTimeStap = Long.parseLong(clientStatus);
            if (CLIENTTIMEOUTMILLIS > 0L && currentTimeMillis - lastVisitTimeStap > CLIENTTIMEOUTMILLIS) {
                if (clientsClosed != null) {
                    clientsClosed.put(clientID, true);
                }
                LogUtil.info("ClientManager.isClientClosed(): true. ClientID = " + clientID + ", Qing.Client.Timeout value is " + CLIENTTIMEOUTMILLIS + ". If there are any problems, Maybe you should to check the system time. (bos-web and qing)");
                return true;
            }
            if (clientsClosed != null) {
                clientsClosed.put(clientID, false);
            }
            return false;
        }
        return defaultStateIfNotExist;
    }

    public static void registerUpdateClientTimestapListener(IUpdateClientTimestapListener updateClientTimestapListener) {
        updateClientTimestapListeners.add(updateClientTimestapListener);
    }

    private static void fireUpdateClientTimestap(QingContext qingContext) {
        if (!updateClientTimestapListeners.isEmpty()) {
            for (IUpdateClientTimestapListener updateClientTimestapListener : updateClientTimestapListeners) {
                updateClientTimestapListener.updateClientTimestap(qingContext);
            }
        }
    }

    public static void initClientAlive(QingContext qingContext, String appID, String clientID, String title, String safetyCode, String safetyURL, String targetURL, String pageId, String qingMsgNodeId) {
        if (StringUtils.isNotBlank(clientID)) {
            IGlobalQingSession globalQingSession = ClientManager.getGlobalQingSession();
            String cacheKey = ClientManager.getCacheKey(clientID);
            globalQingSession.set(CLIENT_APPID_KEY + clientID, appID);
            long lastVisitTimestap = System.currentTimeMillis();
            ClientManager.setClientAlive(qingContext, cacheKey, lastVisitTimestap);
            globalQingSession.hSet(cacheKey, CLIENT_ATTRIBUTE_KEY_TITLE, title);
            if (safetyCode != null && safetyURL != null) {
                globalQingSession.hSet(cacheKey, CLIENT_ATTRIBUTE_KEY_SAFETYCODE, safetyCode);
                globalQingSession.hSet(cacheKey, CLIENT_ATTRIBUTE_KEY_SAFETYURL, safetyURL);
                globalQingSession.hSet(cacheKey, CLIENT_ATTRIBUTE_KEY_NEWOPENCLIENT, "TRUE");
            }
            globalQingSession.hSet(cacheKey, CLIENT_ATTRIBUTE_KEY_TARGETURL, targetURL);
            ClientManager.setClientMap(qingContext, clientID, title);
            LogUtil.info("Cachekey \uff1a " + cacheKey + "; Current safetyCode:" + safetyCode + "; Current safetyURL:" + safetyURL);
        }
        ClientManager.fireUpdateClientTimestap(qingContext);
        if (StringUtils.isNotBlank(clientID) && StringUtils.isNotBlank(qingMsgNodeId)) {
            QingIframeNodeHelper.activateNode(clientID, qingMsgNodeId, qingContext);
        }
        if (StringUtils.isNotBlank(pageId) && StringUtils.isNotBlank(clientID)) {
            String setKey = PAGE_CLIENT_MAPPING_KEY + pageId;
            String[] strings = new String[]{clientID};
            ClientManager.getGlobalQingSession().addToSet(setKey, strings, 86400, TimeUnit.SECONDS);
            LogUtil.info("Resource occupancy: add page client mapping successfully! mapping: pageId:" + pageId + "   clientId:" + clientID);
        }
    }

    public static String getTargetURL(QingContext qingContext, String clientID, String safetyCode, String queryString) {
        if (StringUtils.isBlank(clientID)) {
            return null;
        }
        IGlobalQingSession globalQingSession = ClientManager.getGlobalQingSession();
        String cacheKey = ClientManager.getCacheKey(clientID);
        String sessionIDInCache = globalQingSession.hGet(cacheKey, CLIENT_ATTRIBUTE_KEY_SESSIONID);
        String safetyCodeInCache = globalQingSession.hGet(cacheKey, CLIENT_ATTRIBUTE_KEY_SAFETYCODE);
        String safetyURL = globalQingSession.hGet(cacheKey, CLIENT_ATTRIBUTE_KEY_SAFETYURL);
        if (!qingContext.getSessionID().equals(sessionIDInCache)) {
            LogUtil.error("Cachekey \uff1a " + cacheKey + "; Session in cache:" + sessionIDInCache);
            return null;
        }
        if (!safetyCode.equals(safetyCodeInCache)) {
            LogUtil.error("Cachekey \uff1a " + cacheKey + "; Session in cache:" + sessionIDInCache + "; Current safetyCode:" + safetyCode + "; SafetyCode in cache:" + safetyCodeInCache);
            return null;
        }
        if (safetyURL == null) {
            LogUtil.error("Cachekey \uff1a " + cacheKey + "; Session in cache:" + sessionIDInCache + "; Current safetyCode:" + safetyCode + "; SafetyCode in cache:" + safetyCodeInCache + "; SafetyURL is null");
            return null;
        }
        safetyURL = URLUtil.appendParamToUrl(safetyURL, "safetyCode", safetyCode);
        safetyURL = URLUtil.appendParamToUrl(safetyURL, "clientID", clientID);
        if ((safetyURL = safetyURL.substring(safetyURL.indexOf(63) + 1)).equals(queryString)) {
            return globalQingSession.hGet(cacheKey, CLIENT_ATTRIBUTE_KEY_TARGETURL);
        }
        LogUtil.error("Cachekey \uff1a " + cacheKey + "; Session in cache:" + sessionIDInCache + "; Current safetyCode:" + safetyCode + "; SafetyCode in cache:" + safetyCodeInCache + "; Current safetyURL:" + safetyURL + "; SafetyCode in safetyURL:" + queryString);
        return null;
    }

    public static String getAttribute(String clientID, String attributeKey) {
        if (StringUtils.isNotBlank(clientID)) {
            IGlobalQingSession globalQingSession = ClientManager.getGlobalQingSession();
            String cacheKey = ClientManager.getCacheKey(clientID);
            return globalQingSession.hGet(cacheKey, attributeKey);
        }
        return null;
    }

    public static boolean isNewOpenClient(String clientID) {
        String cacheKey;
        IGlobalQingSession globalQingSession;
        String isNewOpenClient;
        if (StringUtils.isNotBlank(clientID) && (isNewOpenClient = (globalQingSession = ClientManager.getGlobalQingSession()).hGet(cacheKey = ClientManager.getCacheKey(clientID), CLIENT_ATTRIBUTE_KEY_NEWOPENCLIENT)) != null) {
            globalQingSession.hRemove(cacheKey, CLIENT_ATTRIBUTE_KEY_NEWOPENCLIENT);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setClientMap(QingContext qingContext, String clientID, String title) {
        ILock lock = LockFactory.createLocalLock(ClientManager.getClientMapLockKey(qingContext.getSessionID()));
        try {
            lock.lock();
            IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
            Map allClientMap = new HashMap<String, String>();
            String clientMapValue = qingSession.get(CLIENT_MAP_KEY);
            if (StringUtils.isNotBlank(clientMapValue)) {
                allClientMap = JsonUtil.decodeFromString(clientMapValue, Map.class);
                boolean removeClosedClientOnUpdate = SystemPropertyUtil.getBoolean(CLOSE_CLIENT_ON_UPDATE_NEW_CLIENT, false);
                if (removeClosedClientOnUpdate) {
                    HashSet<String> closedClients = new HashSet<String>();
                    for (Map.Entry entry : allClientMap.entrySet()) {
                        String existedClientId = (String)entry.getKey();
                        if (!ClientManager.isClientClosed(existedClientId, true, null)) continue;
                        closedClients.add(existedClientId);
                    }
                    allClientMap.keySet().removeAll(closedClients);
                }
            }
            allClientMap.put(clientID, title);
            clientMapValue = JsonUtil.encodeToString(allClientMap);
            qingSession.set(CLIENT_MAP_KEY, clientMapValue);
        }
        catch (Exception e) {
            LogUtil.error(e.getMessage(), e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeClientMap(QingContext qingContext, Collection<String> clientIDs) {
        ILock lock = LockFactory.createLocalLock(ClientManager.getClientMapLockKey(qingContext.getSessionID()));
        try {
            lock.lock();
            IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
            Map allClientMap = new HashMap();
            String clientMapValue = qingSession.get(CLIENT_MAP_KEY);
            if (StringUtils.isNotBlank(clientMapValue)) {
                allClientMap = JsonUtil.decodeFromString(clientMapValue, Map.class);
                for (String clientID : clientIDs) {
                    allClientMap.remove(clientID);
                }
            }
            if (allClientMap.isEmpty()) {
                qingSession.remove(CLIENT_MAP_KEY);
            } else {
                qingSession.set(CLIENT_MAP_KEY, JsonUtil.encodeToString(allClientMap));
            }
        }
        catch (Exception e) {
            LogUtil.error(e.getMessage(), e);
        }
        finally {
            lock.unlock();
        }
    }

    public static Map<String, String> getAllAliveClient(QingContext qingContext) {
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        HashMap<String, String> allAliveClientMap = new HashMap<String, String>();
        String clientMapValue = qingSession.get(CLIENT_MAP_KEY);
        HashSet<String> closedClientIDs = new HashSet<String>();
        if (StringUtils.isNotBlank(clientMapValue)) {
            Map allClientMap = JsonUtil.decodeFromString(clientMapValue, Map.class);
            for (Map.Entry entry : allClientMap.entrySet()) {
                String clientID = (String)entry.getKey();
                String clientTitle = (String)entry.getValue();
                if (!ClientManager.isClientClosed(clientID, true, null)) {
                    allAliveClientMap.put(clientID, clientTitle);
                    continue;
                }
                closedClientIDs.add(clientID);
            }
        }
        ClientManager.removeClientMap(qingContext, closedClientIDs);
        return allAliveClientMap;
    }

    public static String getClientMapLockKey(String sessionID) {
        return CLIENT_MAP_LOCK_KEY + sessionID;
    }

    public static interface IUpdateClientTimestapListener {
        public void updateClientTimestap(QingContext var1);
    }
}

