/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.manage;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.distribute.session.UserRequestSession;
import com.kingdee.bos.qing.common.distribute.session.UserSessionMgr;
import com.kingdee.bos.qing.common.distribute.task.DistributeTaskMgr;
import com.kingdee.bos.qing.common.distribute.task.RemoteSubmitState;
import com.kingdee.bos.qing.common.distribute.task.TaskEvent;
import com.kingdee.bos.qing.common.distribute.task.TaskRequest;
import com.kingdee.bos.qing.common.framework.model.QingServiceAsynDispatcherModel;
import com.kingdee.bos.qing.common.framework.server.annotation.iotask.IOTaskServiceHelper;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceHelper;
import com.kingdee.bos.qing.common.framework.server.annotation.rptexec.RptExecServiceHelper;
import com.kingdee.bos.qing.common.framework.server.dependency.QingServiceFactory;
import com.kingdee.bos.qing.common.thread.ThreadPoolMonitor;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.concurrent.ExecutionException;

public class ThreadTaskInvokeController {
    private static final ThreadTaskInvokeController instance = new ThreadTaskInvokeController();

    private ThreadTaskInvokeController() {
    }

    public static ThreadTaskInvokeController getInstance() {
        return instance;
    }

    public void executeRemoteTaskAsync(TaskEvent taskEvent, QingContext qingContext) throws IllegalAccessException, InstantiationException {
        TaskRequest taskRequest = (TaskRequest)taskEvent.getData();
        QingServiceAsynDispatcherModel dispatcherModel = taskRequest.getTaskModel();
        Object service = QingServiceFactory.getServiceImpl(dispatcherModel.getServiceType());
        if (service != null) {
            UserRequestSession userRequestSession = UserSessionMgr.getInstance().getOrCreateReqSession(qingContext.getSessionID(), qingContext.getUserId());
            userRequestSession.forceInvokeRemoteReq(taskEvent.getTaskId(), taskRequest, qingContext, service);
        }
    }

    public byte[] submitReq(QingServiceAsynDispatcherModel dispatcherModel, QingContext qingContext, boolean needWaitSomeTime) throws IllegalAccessException, InstantiationException, ExecutionException, InterruptedException {
        Object service = QingServiceFactory.getServiceImpl(dispatcherModel.getServiceType());
        if (service != null) {
            ThreadPoolManage.QingThreadPoolName poolName = this.getThreadPoolName(service, dispatcherModel.getMethodName());
            ThreadPoolMonitor.ThreadPoolStatistic statistic = ThreadPoolMonitor.getInstance().getThreadPoolStatistic(poolName);
            RemoteSubmitState submitState = null;
            if (null != statistic && statistic.isThreadPoolFull() && (submitState = DistributeTaskMgr.getInstance().remoteExecuteTask(qingContext, dispatcherModel, poolName)) == RemoteSubmitState.SUCCEED) {
                return null;
            }
            UserRequestSession userRequestSession = UserSessionMgr.getInstance().getOrCreateReqSession(qingContext.getSessionID(), qingContext.getUserId());
            boolean forceLocal = null != submitState;
            return userRequestSession.invokeTask(dispatcherModel, qingContext, service, needWaitSomeTime, forceLocal);
        }
        return null;
    }

    private ThreadPoolManage.QingThreadPoolName getThreadPoolName(Object service, String methodName) {
        ThreadPoolManage.QingThreadPoolName threadPoolName = ThreadPoolManage.QingThreadPoolName.QING_SHORT_TIME_TASK_HANDLER;
        if (LongTimeServiceHelper.isLongTimeService(service, methodName)) {
            threadPoolName = ThreadPoolManage.QingThreadPoolName.QING_LONG_TIME_TASK_HANDLER;
        } else if (RptExecServiceHelper.isRptExecService(service, methodName)) {
            threadPoolName = ThreadPoolManage.QingThreadPoolName.QING_RPT_EXEC_TASK_HANDLER;
        } else if (IOTaskServiceHelper.isIOTaskService(service, methodName)) {
            threadPoolName = ThreadPoolManage.QingThreadPoolName.QING_IO_MASTER_TASK_HANDLER;
        }
        return threadPoolName;
    }
}

