/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.funcimpl;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;

public class DateAndTimeTypeFunctions {
    private static final int[] PARAMS_DATE = new int[]{4};
    private static final int[] PARAMS_DATETIME = new int[]{3};
    private static final int[] PARAMS_TIME = new int[]{5};
    private static final int[] PARAMS_DATE_NUMBER = new int[]{4, 2};
    private static final int[] PARAMS_DATETIME_NUMBER = new int[]{3, 2};
    private static final int[] PARAMS_DATE_NUMBER_NUMBER = new int[]{4, 2, 2};
    private static final int[] PARAMS_DATETIME_NUMBER_NUMBER = new int[]{3, 2, 2};
    private static final int[] PARAMS_DATE_NUMBER_NUMBER_NUMBER = new int[]{4, 2, 2, 2};
    private static final int[] PARAMS_DATETIME_NUMBER_NUMBER_NUMBER = new int[]{3, 2, 2, 2};
    private static final int[] PARAMS_DATE_STRING = new int[]{4, 1};
    private static final int[] PARAMS_DATETIME_STRING = new int[]{3, 1};
    private static final int[] PARAMS_NUMBER_NUMBER_NUMBER = new int[]{2, 2, 2};
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;

    protected static Calendar destDay(Calendar calendar, String typeString, boolean bFirst, IExpr expr) throws ExecuteException {
        DateType type = DateType.valueOfOrThrowEx(typeString, expr);
        switch (type) {
            case MD: {
                if (bFirst) {
                    calendar.set(5, 1);
                    break;
                }
                calendar.set(5, calendar.getActualMaximum(5));
                break;
            }
            case WD: {
                calendar.set(4, calendar.get(4));
                if (bFirst) {
                    calendar.set(7, 1);
                    break;
                }
                calendar.set(7, 7);
                break;
            }
            case YD: {
                if (bFirst) {
                    calendar.set(6, 1);
                    break;
                }
                calendar.set(6, calendar.getActualMaximum(6));
                break;
            }
            default: {
                throw ExecuteException.unmatchedParamValTypeException(expr);
            }
        }
        return calendar;
    }

    static enum DateType {
        Y,
        YM,
        YD,
        M,
        MD,
        W,
        WD,
        D;


        static DateType valueOfOrThrowEx(String str, IExpr expr) throws ExecuteException {
            try {
                return DateType.valueOf(str);
            }
            catch (IllegalArgumentException e) {
                throw ExecuteException.unmatchedParamValTypeException(expr);
            }
        }
    }

    public static class LASTDAY
    extends AbstractFunctionExpr {
        public LASTDAY() {
            super("LASTDAY");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_DATE_STRING, PARAMS_DATETIME_STRING, PARAMS_DATE, PARAMS_DATETIME);
        }

        @Override
        public int getReturnDataType() {
            return 4;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Calendar calendar = (Calendar)this.getDateValue(this.getSubExprs()[0], ctx).clone();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            String type = this.getParamStringValueUseDefaultIfNotExist(ctx, 1, "YD");
            return DateAndTimeTypeFunctions.destDay(calendar, type, false, this);
        }
    }

    public static class FIRSTDAY
    extends AbstractFunctionExpr {
        public FIRSTDAY() {
            super("FIRSTDAY");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_DATE_STRING, PARAMS_DATETIME_STRING, PARAMS_DATE, PARAMS_DATETIME);
        }

        @Override
        public int getReturnDataType() {
            return 4;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Calendar calendar = (Calendar)this.getDateValue(this.getSubExprs()[0], ctx).clone();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            String type = this.getParamStringValueUseDefaultIfNotExist(ctx, 1, "YD");
            return DateAndTimeTypeFunctions.destDay(calendar, type, true, this);
        }
    }

    public static class NEXTDAY
    extends AbstractFunctionExpr {
        public NEXTDAY() {
            super("NEXTDAY");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_DATE, PARAMS_DATETIME, PARAMS_DATE_NUMBER, PARAMS_DATETIME_NUMBER, PARAMS_DATE_NUMBER_NUMBER, PARAMS_DATETIME_NUMBER_NUMBER, PARAMS_DATE_NUMBER_NUMBER_NUMBER, PARAMS_DATETIME_NUMBER_NUMBER_NUMBER);
        }

        @Override
        public int getReturnDataType() {
            return 4;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Calendar cal = (Calendar)this.getDateValue(this.getSubExprs()[0], ctx).clone();
            Double dateOffset = null;
            Integer yearOffset = null;
            Integer monthOffset = null;
            switch (this.getSubExprs().length) {
                case 2: {
                    dateOffset = this.getDoubleValue(this.getSubExprs()[1], ctx);
                    break;
                }
                case 3: {
                    dateOffset = this.getDoubleValue(this.getSubExprs()[1], ctx);
                    monthOffset = this.getIntValue(this.getSubExprs()[2], ctx);
                    break;
                }
                case 4: {
                    dateOffset = this.getDoubleValue(this.getSubExprs()[1], ctx);
                    monthOffset = this.getIntValue(this.getSubExprs()[2], ctx);
                    yearOffset = this.getIntValue(this.getSubExprs()[3], ctx);
                    break;
                }
            }
            if (dateOffset != null) {
                cal.setTimeInMillis(cal.getTimeInMillis() + (long)(dateOffset * 8.64E7));
                if (monthOffset != null) {
                    cal.add(2, monthOffset);
                }
                if (yearOffset != null) {
                    cal.add(1, yearOffset);
                }
            } else {
                cal.add(6, 1);
            }
            return cal;
        }
    }

    public static class NOW
    extends AbstractFunctionExpr {
        public NOW() {
            super("NOW");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            if (subExprs.length != 0) {
                throw NOW.exUnmatchedParamCount(this);
            }
        }

        @Override
        public int getReturnDataType() {
            return 3;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            return Calendar.getInstance();
        }
    }

    public static class TODAY
    extends AbstractFunctionExpr {
        public TODAY() {
            super("TODAY");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
        }

        @Override
        public int getReturnDataType() {
            return 4;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar;
        }
    }

    public static class DATEDIFF
    extends AbstractFunctionExpr {
        private static final int[] D_D_S = new int[]{4, 4, 1};
        private static final int[] DT_DT_S = new int[]{3, 3, 1};
        private static final int[] D_DT_S = new int[]{4, 3, 1};
        private static final int[] DT_D_S = new int[]{3, 4, 1};

        public DATEDIFF() {
            super("DATEDIFF");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, D_D_S, DT_DT_S, D_DT_S, DT_D_S);
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Calendar startDate = (Calendar)this.getDateValue(this.getSubExprs()[0], ctx).clone();
            Calendar endDate = (Calendar)this.getDateValue(this.getSubExprs()[1], ctx).clone();
            String type = this.getStringValue(this.getSubExprs()[2], ctx);
            boolean neg = false;
            if (endDate.before(startDate)) {
                neg = true;
                Calendar cTmp = startDate;
                startDate = endDate;
                endDate = cTmp;
            }
            int value = 0;
            DateType dateType = DateType.valueOfOrThrowEx(type, this.getSubExprs()[2]);
            switch (dateType) {
                case Y: {
                    int year2 = endDate.get(1);
                    int year = startDate.get(1);
                    value = year2 - year;
                    int month2 = endDate.get(2);
                    int month = startDate.get(2);
                    int day2 = endDate.get(5);
                    int day = startDate.get(5);
                    if (value <= 0 || month2 >= month && (month2 != month || day2 >= day)) break;
                    --value;
                    break;
                }
                case M: {
                    value = endDate.get(1) * 12 + endDate.get(2) - (startDate.get(1) * 12 + startDate.get(2));
                    if (endDate.get(5) >= startDate.get(5)) break;
                    --value;
                    break;
                }
                case D: {
                    value = (int)((endDate.getTimeInMillis() - startDate.getTimeInMillis()) / 86400000L);
                    break;
                }
                case MD: {
                    int d = startDate.get(5);
                    int d2 = endDate.get(5);
                    if (d2 >= d) {
                        value = d2 - d;
                        break;
                    }
                    Calendar c3 = (Calendar)endDate.clone();
                    c3.set(2, endDate.get(2) - 1);
                    value = d2 + c3.getActualMaximum(5) - d;
                    break;
                }
                case YM: {
                    int m = startDate.get(2);
                    int m2 = endDate.get(2);
                    if (m2 >= m) {
                        m2 -= m;
                        if (startDate.get(5) > endDate.get(5) && --m2 < 0) {
                            m2 += 12;
                        }
                    } else {
                        m2 += 12 - m;
                        if (startDate.get(5) > endDate.get(5)) {
                            --m2;
                        }
                    }
                    value = m2;
                    break;
                }
                case YD: {
                    int d = startDate.get(6);
                    int d2 = endDate.get(6);
                    if (endDate.get(2) + 1 == 3 && endDate.get(5) >= startDate.get(5) || endDate.get(2) + 1 != 3) {
                        Calendar c3 = (Calendar)endDate.clone();
                        c3.set(1, startDate.get(1));
                        d2 = c3.get(6);
                        value = d2 - d;
                        if (value >= 0) break;
                        c3.set(1, startDate.get(1) + 1);
                        d2 = c3.get(6);
                        value = d2 + c3.getActualMaximum(6) - d;
                        break;
                    }
                    if (endDate.get(2) + 1 != 3 || endDate.get(5) >= startDate.get(5)) break;
                    Calendar c3 = (Calendar)startDate.clone();
                    c3.set(1, endDate.get(1));
                    d = c3.get(6);
                    value = d2 - d;
                    if (value >= 0) break;
                    c3.set(1, endDate.get(1) - 1);
                    d = c3.get(6);
                    value = d2 + c3.getActualMaximum(6) - d;
                    break;
                }
                default: {
                    throw ExecuteException.unmatchedParamValTypeException(this.getSubExprs()[2]);
                }
            }
            return new BigDecimal(neg ? -value : value);
        }
    }

    public static class TIME
    extends AbstractFunctionExpr {
        private static BigDecimal secondsOfFullDay = new BigDecimal(86400);

        public TIME() {
            super("TIME");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER_NUMBER_NUMBER});
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            int hour = this.getIntValue(this.getSubExprs()[0], ctx) % 24;
            int minute = this.getIntValue(this.getSubExprs()[1], ctx) % 60;
            int second = this.getIntValue(this.getSubExprs()[2], ctx) % 60;
            if (hour < 0) {
                throw ExecuteException.unmatchedParamValTypeException(this.getSubExprs()[0]);
            }
            if (minute < 0) {
                throw ExecuteException.unmatchedParamValTypeException(this.getSubExprs()[1]);
            }
            if (second < 0) {
                throw ExecuteException.unmatchedParamValTypeException(this.getSubExprs()[2]);
            }
            BigDecimal totalSecond = new BigDecimal((hour * 60 + minute) * 60 + second);
            return totalSecond.divide(secondsOfFullDay, 8, RoundingMode.HALF_UP);
        }
    }

    public static class DATE
    extends AbstractFunctionExpr {
        public DATE() {
            super("DATE");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER_NUMBER_NUMBER});
        }

        @Override
        public int getReturnDataType() {
            return 4;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            int year = this.getIntValue(this.getSubExprs()[0], ctx);
            int month = this.getIntValue(this.getSubExprs()[1], ctx);
            int day = this.getIntValue(this.getSubExprs()[2], ctx);
            if (year < 0) {
                throw ExecuteException.unmatchedParamValTypeException(this.getSubExprs()[0]);
            }
            if (month < 1) {
                throw ExecuteException.unmatchedParamValTypeException(this.getSubExprs()[1]);
            }
            if (day < 1) {
                throw ExecuteException.unmatchedParamValTypeException(this.getSubExprs()[2]);
            }
            year = (year %= 10000) < 1900 ? year + 1900 : year;
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(year, month - 1, day, 0, 0, 0);
            calendar.set(14, 0);
            return calendar;
        }
    }

    public static class SECOND
    extends AbstractSingleFieldDateFunction {
        public SECOND() {
            super("SECOND");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_TIME, PARAMS_DATETIME);
        }

        @Override
        protected int doExecute(Calendar calendar) throws ExecuteException {
            return calendar.get(13);
        }
    }

    public static class MINUTE
    extends AbstractSingleFieldDateFunction {
        public MINUTE() {
            super("MINUTE");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_TIME, PARAMS_DATETIME);
        }

        @Override
        protected int doExecute(Calendar calendar) throws ExecuteException {
            return calendar.get(12);
        }
    }

    public static class HOUR
    extends AbstractSingleFieldDateFunction {
        public HOUR() {
            super("HOUR");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_TIME, PARAMS_DATETIME);
        }

        @Override
        protected int doExecute(Calendar calendar) throws ExecuteException {
            return calendar.get(11);
        }
    }

    public static class WEEKDAY
    extends AbstractFunctionExpr {
        public WEEKDAY() {
            super("WEEKDAY");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_DATE_NUMBER, PARAMS_DATETIME_NUMBER, PARAMS_DATE, PARAMS_DATETIME);
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Calendar calendar = this.getDateValue(this.getSubExprs()[0], ctx);
            int type = this.getParamIntValueUseDefaultIfNotExist(ctx, 1, 1);
            int dayOfWeek = calendar.get(7);
            switch (type) {
                case 1: {
                    return new BigDecimal(dayOfWeek);
                }
                case 2: {
                    return new BigDecimal((dayOfWeek + 5) % 7 + 1);
                }
                case 3: {
                    return new BigDecimal((dayOfWeek + 5) % 7);
                }
            }
            throw ExecuteException.unmatchedParamValTypeException(this.getSubExprs()[1]);
        }
    }

    public static class ISOWEEKDAY
    extends AbstractFunctionExpr {
        public ISOWEEKDAY() {
            super("ISOWEEKDAY");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_DATE, PARAMS_DATETIME);
        }

        @Override
        public final int getReturnDataType() {
            return 2;
        }

        @Override
        public final Object execute(IExecuteContext ctx) throws ExecuteException {
            Calendar calendar = this.getDateValue(this.getSubExprs()[0], ctx);
            int weekDay = calendar.get(7);
            int result = weekDay == 2 ? 1 : (weekDay == 3 ? 2 : (weekDay == 4 ? 3 : (weekDay == 5 ? 4 : (weekDay == 6 ? 5 : (weekDay == 7 ? 6 : 7)))));
            return new BigDecimal(result);
        }
    }

    public static class ISOWEEKYEAR
    extends AbstractIsoWeek {
        public ISOWEEKYEAR() {
            super("ISOWEEKYEAR");
        }

        @Override
        protected int execute(Calendar calendar) {
            int year = calendar.get(1);
            int month = calendar.get(2);
            int week = calendar.get(3);
            if (month == 0 && week >= 52) {
                --year;
            } else if (month == 11 && week == 1) {
                ++year;
            }
            return year;
        }
    }

    public static class ISOWEEK
    extends AbstractIsoWeek {
        public ISOWEEK() {
            super("ISOWEEK");
        }

        @Override
        protected int execute(Calendar calendar) {
            return calendar.get(3);
        }
    }

    private static abstract class AbstractIsoWeek
    extends AbstractFunctionExpr {
        protected AbstractIsoWeek(String name) {
            super(name);
        }

        @Override
        protected final void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_DATE, PARAMS_DATETIME);
        }

        @Override
        public final int getReturnDataType() {
            return 2;
        }

        @Override
        public final Object execute(IExecuteContext ctx) throws ExecuteException {
            Calendar calendar = this.getTarget(ctx);
            int result = this.execute(calendar);
            return new BigDecimal(result);
        }

        protected abstract int execute(Calendar var1);

        private Calendar getTarget(IExecuteContext ctx) throws ExecuteException {
            IExpr[] params = this.getParams();
            Calendar calendar = (Calendar)this.getDateValue(params[0], ctx).clone();
            calendar.setFirstDayOfWeek(2);
            calendar.setMinimalDaysInFirstWeek(4);
            return calendar;
        }
    }

    public static class WEEK
    extends AbstractFunctionExpr {
        static final String SUNDAY = "Sunday";
        static final String MONDAY = "Monday";

        public WEEK() {
            super("WEEK");
        }

        @Override
        protected final void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_DATE, PARAMS_DATETIME, PARAMS_DATE_STRING, PARAMS_DATETIME_STRING);
        }

        @Override
        public final int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            int firstDayOfWeek;
            String startWeekDay;
            IExpr[] params = this.getParams();
            String string = startWeekDay = params.length > 1 ? this.getStringValue(params[1], ctx) : SUNDAY;
            if (startWeekDay == null || startWeekDay.isEmpty() || SUNDAY.equalsIgnoreCase(startWeekDay)) {
                firstDayOfWeek = 1;
            } else if (MONDAY.equalsIgnoreCase(startWeekDay)) {
                firstDayOfWeek = 2;
            } else {
                throw ExecuteException.unexpectedParamValue(params[1]);
            }
            Calendar calendar = (Calendar)this.getDateValue(params[0], ctx).clone();
            long target = calendar.getTimeInMillis();
            calendar.set(2, 0);
            calendar.set(5, 1);
            int weekday = calendar.get(7);
            int firstWeekAddDays = weekday - firstDayOfWeek;
            calendar.add(5, -(firstWeekAddDays += firstWeekAddDays < 0 ? 7 : 0));
            long head = calendar.getTimeInMillis();
            int days = (int)((target - head) / 86400000L);
            int week = days / 7 + 1;
            return new BigDecimal(week);
        }
    }

    public static class MONTHDAYS
    extends AbstractSingleFieldDateFunction {
        public MONTHDAYS() {
            super("MONTHDAYS");
        }

        @Override
        protected int doExecute(Calendar calendar) throws ExecuteException {
            int days = calendar.getActualMaximum(5);
            return days;
        }
    }

    public static class QUARTER
    extends AbstractSingleFieldDateFunction {
        public QUARTER() {
            super("QUARTER");
        }

        @Override
        protected int doExecute(Calendar calendar) throws ExecuteException {
            int month = calendar.get(2);
            return month / 3 + 1;
        }
    }

    public static class DAY
    extends AbstractSingleFieldDateFunction {
        public DAY() {
            super("DAY");
        }

        @Override
        protected int doExecute(Calendar calendar) throws ExecuteException {
            return calendar.get(5);
        }
    }

    public static class MONTH
    extends AbstractSingleFieldDateFunction {
        public MONTH() {
            super("MONTH");
        }

        @Override
        protected int doExecute(Calendar calendar) throws ExecuteException {
            return calendar.get(2) + 1;
        }
    }

    public static class YEAR
    extends AbstractSingleFieldDateFunction {
        public YEAR() {
            super("YEAR");
        }

        @Override
        protected int doExecute(Calendar calendar) throws ExecuteException {
            return calendar.get(1);
        }
    }

    private static abstract class AbstractSingleFieldDateFunction
    extends AbstractFunctionExpr {
        public AbstractSingleFieldDateFunction(String name) {
            super(name);
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_DATE, PARAMS_DATETIME);
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Calendar calendar = this.getDateValue(this.getSubExprs()[0], ctx);
            return new BigDecimal(this.doExecute(calendar));
        }

        protected abstract int doExecute(Calendar var1) throws ExecuteException;
    }
}

