/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.funcimpl;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.ConstanceExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;

public class LogicTypeFunctions {

    protected static final class ReturnTypeDecisionMaker {
        private boolean currentTypeCanFollow = false;
        private int dataType = 0;
        private IExpr functionExpr;

        private ReturnTypeDecisionMaker(IExpr functionExpr) {
            this.functionExpr = functionExpr;
        }

        public ReturnTypeDecisionMaker append(IExpr expr) throws ParserException {
            this.currentTypeCanFollow = ConstanceExpr.NULL.equals(expr);
            if (this.currentTypeCanFollow) {
                return this;
            }
            if (this.dataType == 0 && expr.getReturnDataType() != 0) {
                this.dataType = expr.getReturnDataType();
            } else if (expr.getReturnDataType() != this.dataType) {
                throw new ParserException(14, expr.getCharIndexAtFormula());
            }
            if (this.dataType == 0) {
                throw new ParserException(14, expr.getCharIndexAtFormula());
            }
            return this;
        }

        public int getDataType() throws ParserException {
            if (this.dataType == 0) {
                throw new ParserException(14, this.functionExpr.getCharIndexAtFormula());
            }
            return this.dataType;
        }
    }

    public static class NOT
    extends AbstractFunctionExpr {
        private static final int[] PARAMS_BOOLEAN = new int[]{6};

        public NOT() {
            super("NOT");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_BOOLEAN});
        }

        @Override
        public int getReturnDataType() {
            return 6;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Boolean condition = this.getBooleanValue(this.getSubExprs()[0], ctx);
            return condition == false;
        }
    }

    public static class OR
    extends AbstractFunctionExpr {
        public OR() {
            super("OR");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            if (subExprs.length == 0) {
                throw OR.exUnmatchedParamCount(this);
            }
            for (IExpr expr : subExprs) {
                if (6 == expr.getReturnDataType()) continue;
                throw OR.exUnmatchedDataType(this);
            }
        }

        @Override
        public int getReturnDataType() {
            return 6;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            for (IExpr expr : this.getSubExprs()) {
                Boolean condition = this.getBooleanValue(expr, ctx);
                if (!condition.booleanValue()) continue;
                return true;
            }
            return false;
        }
    }

    public static class AND
    extends AbstractFunctionExpr {
        public AND() {
            super("AND");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            if (subExprs.length == 0) {
                throw AND.exUnmatchedParamCount(this);
            }
            for (IExpr expr : subExprs) {
                if (6 == expr.getReturnDataType()) continue;
                throw AND.exUnmatchedDataType(this);
            }
        }

        @Override
        public int getReturnDataType() {
            return 6;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            for (IExpr expr : this.getSubExprs()) {
                Boolean condition = this.getBooleanValue(expr, ctx);
                if (condition.booleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    public static class CASE
    extends AbstractFunctionExpr {
        private int dataType;

        public CASE() {
            super("CASE");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            if (subExprs.length < 2) {
                throw CASE.exUnmatchedParamCount(this);
            }
            boolean hasDefaultValue = subExprs.length % 2 == 1;
            int conditionLength = hasDefaultValue ? subExprs.length - 1 : subExprs.length;
            ReturnTypeDecisionMaker maker = new ReturnTypeDecisionMaker(this);
            for (int i = 0; i < conditionLength; i += 2) {
                if (!CASE.isDataTypeCompatible(6, subExprs[i].getReturnDataType())) {
                    throw CASE.exUnmatchedDataType(subExprs[i]);
                }
                maker.append(subExprs[i + 1]);
            }
            if (hasDefaultValue) {
                maker.append(subExprs[subExprs.length - 1]);
            }
            this.dataType = maker.getDataType();
        }

        @Override
        public int getReturnDataType() {
            return this.dataType;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            boolean hasDefaultValue = this.getSubExprs().length % 2 == 1;
            int conditionLength = hasDefaultValue ? this.getSubExprs().length - 1 : this.getSubExprs().length;
            for (int i = 0; i < conditionLength; i += 2) {
                boolean condition = this.getBooleanValue(this.getSubExprs()[i], ctx);
                if (!condition) continue;
                return this.getSubExprs()[i + 1].execute(ctx);
            }
            if (hasDefaultValue) {
                return this.getSubExprs()[this.getSubExprs().length - 1].execute(ctx);
            }
            return null;
        }
    }

    public static class IF
    extends AbstractFunctionExpr {
        private static final int[] PARAMS_BOOLEAN_UNSURE_UNSURE = new int[]{6, 0, 0};
        private int dataType = 0;

        public IF() {
            super("IF");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsCommonImpl(subExprs, PARAMS_BOOLEAN_UNSURE_UNSURE);
            this.dataType = new ReturnTypeDecisionMaker(this).append(subExprs[1]).append(subExprs[2]).getDataType();
        }

        @Override
        public int getReturnDataType() {
            return this.dataType;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            boolean condition = this.getBooleanValue(this.getSubExprs()[0], ctx);
            if (condition) {
                return this.getSubExprs()[1].execute(ctx);
            }
            return this.getSubExprs()[2].execute(ctx);
        }
    }
}

