/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.jsengine;

import com.kingdee.bos.qing.common.jsengine.IJsRtEnv;
import com.kingdee.bos.qing.common.jsengine.exception.JavaScriptException;
import com.kingdee.bos.qing.common.jsengine.mock.Console;
import com.kingdee.bos.qing.common.jsengine.mock.Image;
import com.kingdee.bos.qing.common.jsengine.model.rhino.JavaModelWrapFactory;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;

class RhinoJSEnv
implements IJsRtEnv {
    private ScriptableObject sharedReadOnlyWindowScope;
    private boolean scriptsThreadsafe;
    private Map<String, Object> prePutObjects;
    private String[] preloadedScripts;

    public RhinoJSEnv(Map<String, Object> prePutObjects, String ... preloadedScripts) throws JavaScriptException {
        this(true, prePutObjects, preloadedScripts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RhinoJSEnv(boolean scriptsThreadsafe, Map<String, Object> prePutObjects, String ... preloadedScripts) throws JavaScriptException {
        this.scriptsThreadsafe = scriptsThreadsafe;
        this.prePutObjects = prePutObjects;
        this.preloadedScripts = preloadedScripts;
        if (scriptsThreadsafe) {
            Context jsContext = Context.enter();
            try {
                jsContext.setOptimizationLevel(9);
                this.sharedReadOnlyWindowScope = this.initWindowScope(jsContext, prePutObjects, preloadedScripts);
            }
            finally {
                jsContext.exit();
            }
        }
    }

    @Override
    public Object executeFunction(String function, Object ... args) {
        try {
            Context jsContext = Context.enter();
            jsContext.setOptimizationLevel(9);
            ScriptableObject windowScope = this.sharedReadOnlyWindowScope;
            if (!this.scriptsThreadsafe) {
                windowScope = this.initWindowScope(jsContext, this.prePutObjects, this.preloadedScripts);
            }
            jsContext.setWrapFactory((WrapFactory)new JavaModelWrapFactory());
            jsContext.getWrapFactory().setJavaPrimitiveWrap(false);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.javaToJS((Object)args[i], (Scriptable)windowScope);
                }
            }
            Scriptable scope = jsContext.newObject((Scriptable)windowScope);
            Function fun = (Function)windowScope.get(function, (Scriptable)windowScope);
            Object val = fun.call(jsContext, scope, null, args);
            if (val instanceof NativeJavaObject) {
                Object object = ((NativeJavaObject)val).unwrap();
                return object;
            }
            Object object = val;
            return object;
        }
        catch (JavaScriptException e) {
            throw new IllegalStateException(e);
        }
        finally {
            Context.exit();
        }
    }

    private void putReadOnlyObject(ScriptableObject windowScope, String name, Object obj) {
        windowScope.put(name, (Scriptable)windowScope, obj);
        windowScope.setAttributes(name, 1);
    }

    private ScriptableObject initWindowScope(Context jsContext, Map<String, Object> prePutObjects, String ... preloadedScripts) throws JavaScriptException {
        ScriptableObject windowScope = jsContext.initStandardObjects(null, true);
        this.putReadOnlyObject(windowScope, "console", new Console());
        if (prePutObjects != null && !prePutObjects.isEmpty()) {
            for (Map.Entry<String, Object> entry : prePutObjects.entrySet()) {
                this.putReadOnlyObject(windowScope, entry.getKey(), entry.getValue());
            }
        }
        this.importJavaClass(jsContext, windowScope);
        this.loadJsFile(jsContext, windowScope, preloadedScripts);
        return windowScope;
    }

    private void loadJsFile(Context jsContext, ScriptableObject windowScope, String ... preloadedScripts) throws JavaScriptException {
        block6: {
            if (preloadedScripts == null) break block6;
            for (String preloadScript : preloadedScripts) {
                URL resource = this.getClass().getResource(preloadScript);
                InputStream inputStream = this.getClass().getResourceAsStream(preloadScript);
                if (resource == null) {
                    throw new JavaScriptException("Cannot load resources " + preloadScript + ", get resource return null!");
                }
                InputStreamReader reader = null;
                try {
                    File scriptFile = new File(resource.getFile());
                    reader = new InputStreamReader(inputStream, "utf-8");
                    jsContext.evaluateReader((Scriptable)windowScope, (Reader)reader, scriptFile.getName(), 0, null);
                }
                catch (Exception e) {
                    try {
                        throw new JavaScriptException((Throwable)e, "Load resources " + preloadScript + " failed!");
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close(reader);
                        throw throwable;
                    }
                }
                CloseUtil.close(reader);
            }
        }
    }

    private void importJavaClass(Context jsContext, ScriptableObject windowScope) {
        try {
            String fullClassName = Image.class.getName();
            String js = "var Image = Packages." + fullClassName + ";";
            jsContext.evaluateString((Scriptable)windowScope, js, "importJavaClass", 0, null);
        }
        catch (Exception e) {
            LogUtil.error("load Image Object Error", e);
        }
    }
}

