/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.limitation;

import com.kingdee.bos.qing.common.limitation.ConfiguredTokenSizeSuggester;
import com.kingdee.bos.qing.common.limitation.ITokenSizeSuggester;
import com.kingdee.bos.qing.common.limitation.LimitScene;
import com.kingdee.bos.qing.common.limitation.TokenLimiter;
import com.kingdee.bos.qing.common.memory.MemRuntimeMonitor;
import com.kingdee.bos.qing.common.memory.MemWarningLevel;
import com.kingdee.bos.qing.common.memory.MemoryObserver;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class DynamicTokenLimiter
extends TokenLimiter {
    private volatile int maxTokenSize = -1;
    private int availableTokens;
    private ITokenSizeSuggester sizeSuggester;
    private ReentrantLock tokenLock = new ReentrantLock();
    private Condition condition = this.tokenLock.newCondition();
    private long lastTouchTime;
    private int tokenUsed = 0;
    private MemoryObserver observer;

    DynamicTokenLimiter(LimitScene scene, ITokenSizeSuggester sizeSuggester) {
        this.scene = scene;
        this.sizeSuggester = sizeSuggester != null ? sizeSuggester : new ConfiguredTokenSizeSuggester(scene);
        this.lastTouchTime = System.currentTimeMillis();
        this.observer = new MemoryListener();
        MemRuntimeMonitor.getInstance().registerIfAbsent(this.observer);
    }

    @Override
    public void releaseToken() {
        this.touch();
        if (this.maxTokenSize == -1) {
            return;
        }
        this.tokenLock.lock();
        try {
            --this.tokenUsed;
            if (this.availableTokens >= this.maxTokenSize) {
                LogUtil.info("Qing-QueryToken:current dynamic token state when released\uff1atokenUsed=" + this.tokenUsed + ",availableToken=" + this.availableTokens);
                this.condition.signalAll();
                return;
            }
            ++this.availableTokens;
            LogUtil.info("Qing-QueryToken:current dynamic token state when released\uff1atokenUsed=" + this.tokenUsed + ",availableToken=" + this.availableTokens + ",maxTokenSize=" + this.maxTokenSize);
            this.condition.signalAll();
        }
        finally {
            this.tokenLock.unlock();
        }
    }

    @Override
    public void acquireToken() throws InterruptedException {
        this.touch();
        if (this.maxTokenSize == -1) {
            MemWarningLevel warningLevel = MemRuntimeMonitor.getInstance().getCurrentMemLevel();
            this.availableTokens = this.maxTokenSize = this.sizeSuggester.suggestSize(warningLevel);
        }
        this.tokenLock.lock();
        try {
            while (this.availableTokens <= 0) {
                LogUtil.warn("Qing-QueryToken:no available token,scene" + (Object)((Object)this.scene) + ",tokenUsed=" + this.tokenUsed + ",maxTokenSize=" + this.maxTokenSize);
                this.condition.await();
            }
            ++this.tokenUsed;
            --this.availableTokens;
            LogUtil.info("Qing-QueryToken:current dynamic token state when acquire succeed\uff1atokenUsed=" + this.tokenUsed + ",availableToken=" + this.availableTokens + ",maxTokenSize=" + this.maxTokenSize);
        }
        catch (InterruptedException e) {
            throw e;
        }
        finally {
            this.tokenLock.unlock();
        }
    }

    private class MemoryListener
    implements MemoryObserver {
        private MemoryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyMemoryWarning(MemWarningLevel warningLevel, double currentOldSpaceRatio) {
            int maxTokenBefore = DynamicTokenLimiter.this.maxTokenSize;
            DynamicTokenLimiter.this.maxTokenSize = DynamicTokenLimiter.this.sizeSuggester.suggestSize(warningLevel);
            DynamicTokenLimiter.this.tokenLock.lock();
            try {
                if (DynamicTokenLimiter.this.maxTokenSize < maxTokenBefore) {
                    int reduceCount = maxTokenBefore - DynamicTokenLimiter.this.maxTokenSize;
                    DynamicTokenLimiter.this.availableTokens = DynamicTokenLimiter.this.availableTokens - reduceCount > 0 ? DynamicTokenLimiter.this.availableTokens - reduceCount : 0;
                } else if (DynamicTokenLimiter.this.maxTokenSize > maxTokenBefore) {
                    if (DynamicTokenLimiter.this.maxTokenSize <= DynamicTokenLimiter.this.tokenUsed) {
                        DynamicTokenLimiter.this.availableTokens = 0;
                    } else {
                        DynamicTokenLimiter.this.availableTokens = DynamicTokenLimiter.this.maxTokenSize - DynamicTokenLimiter.this.tokenUsed;
                        DynamicTokenLimiter.this.condition.signalAll();
                    }
                }
                LogUtil.info("Qing-QueryToken:current max token size:" + DynamicTokenLimiter.this.maxTokenSize + ",available token:" + DynamicTokenLimiter.this.availableTokens + ",tokenUsed:" + DynamicTokenLimiter.this.tokenUsed);
                long timeDuration = System.currentTimeMillis() - DynamicTokenLimiter.this.lastTouchTime;
                if (DynamicTokenLimiter.this.tokenUsed == 0) {
                    if (timeDuration >= 60000L) {
                        DynamicTokenLimiter.this.destroy(DynamicTokenLimiter.this.scene, this.getObserverId());
                    }
                } else if (timeDuration >= 3600000L) {
                    DynamicTokenLimiter.this.destroy(DynamicTokenLimiter.this.scene, this.getObserverId());
                }
            }
            finally {
                DynamicTokenLimiter.this.tokenLock.unlock();
            }
        }

        @Override
        public MemWarningLevel lowestLevel() {
            return MemWarningLevel.NORMAL;
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public String getObserverId() {
            return (Object)((Object)DynamicTokenLimiter.this.scene) + "_" + DynamicTokenLimiter.class.getName();
        }
    }
}

