/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.limitation;

import com.kingdee.bos.qing.common.limitation.IRateLimiter;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;

public class LockRateLimiter
implements IRateLimiter {
    private static final String LOCK_LIMITER_PREFIX = "qing_lock_limiter_";
    private static final Long ACQUIRE_SLEEP_MILLIS = 60000L;
    private final String lockKey;
    private final int maxPermits;
    private ILock lock;

    public LockRateLimiter(String key, int maxPermits) {
        this.lockKey = LOCK_LIMITER_PREFIX + key;
        this.maxPermits = maxPermits;
    }

    @Override
    public synchronized void acquire() {
        while (!this.tryAcquire()) {
            try {
                Thread.sleep(ACQUIRE_SLEEP_MILLIS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public synchronized boolean tryAcquire() {
        return this.tryAcquire(0L);
    }

    @Override
    public synchronized boolean tryAcquire(long timeout) {
        if (this.lock != null) {
            throw new IllegalStateException();
        }
        long average = timeout / (long)this.maxPermits;
        for (int i = 0; i < this.maxPermits; ++i) {
            try {
                boolean locked;
                this.lock = LockFactory.createLock(this.lockKey + "_" + i);
                boolean bl = locked = average == 0L ? this.lock.tryLock() : this.lock.tryLock(average);
                if (locked) {
                    return true;
                }
                this.lock = null;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Override
    public synchronized void release() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }
}

