/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.lock.impl;

import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class ReentrantJvmLockFactory
extends LockFactory {
    @Override
    protected ILock innerCreateLock(String lockKey) {
        return new ReentrantJvmLock(lockKey);
    }

    @Override
    protected ILock innerCreateGlobalLock(String lockKey) {
        return new ReentrantJvmLock(lockKey);
    }

    private static class CountableLock
    extends ReentrantLock {
        private AtomicInteger holdThreadNumber = new AtomicInteger(0);

        private CountableLock() {
        }

        public void increaseHold() {
            if (this.getHoldCount() >= 1) {
                return;
            }
            this.holdThreadNumber.incrementAndGet();
        }

        public void descreteHoldOnFail() {
            this.holdThreadNumber.decrementAndGet();
        }

        @Override
        public void unlock() {
            super.unlock();
            if (this.getHoldCount() == 0) {
                this.holdThreadNumber.decrementAndGet();
            }
        }

        public int getHoldThreadNumber() {
            return this.holdThreadNumber.get();
        }
    }

    private static class ReentrantJvmLock
    implements ILock {
        private static Object globalLock = new Object();
        private static final Map<String, CountableLock> jvmLockMap = new HashMap<String, CountableLock>();
        private String lockKey;

        public ReentrantJvmLock(String lockKey) {
            this.lockKey = lockKey;
        }

        @Override
        public void lock() throws QingLockRequireException {
            CountableLock lock = this.getLockerAndIncreateHold(this.lockKey, true);
            boolean lockError = false;
            try {
                lock.lock();
            }
            catch (Exception e) {
                lockError = true;
                throw new QingLockRequireException("lock error", e);
            }
            finally {
                if (lockError) {
                    lock.descreteHoldOnFail();
                }
            }
        }

        @Override
        public boolean tryLock(long timeout) throws QingLockRequireException {
            CountableLock lock = this.getLockerAndIncreateHold(this.lockKey, true);
            boolean succeed = false;
            try {
                succeed = lock.tryLock(timeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new QingLockRequireException("try lock error", e);
            }
            finally {
                if (!succeed) {
                    lock.descreteHoldOnFail();
                }
            }
            return succeed;
        }

        @Override
        public boolean tryLock() throws QingLockRequireException {
            CountableLock lock = this.getLockerAndIncreateHold(this.lockKey, true);
            boolean succeed = false;
            try {
                succeed = lock.tryLock();
            }
            catch (Exception e) {
                throw new QingLockRequireException("try lock error", e);
            }
            finally {
                if (!succeed) {
                    lock.descreteHoldOnFail();
                }
            }
            return succeed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            CountableLock lock = this.getLockerAndIncreateHold(this.lockKey, false);
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
            Object object = globalLock;
            synchronized (object) {
                lock = jvmLockMap.get(this.lockKey);
                if (null != lock && lock.getHoldThreadNumber() == 0) {
                    jvmLockMap.remove(this.lockKey);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CountableLock getLockerAndIncreateHold(String lockKey, boolean forLock) {
            CountableLock lock = null;
            Object object = globalLock;
            synchronized (object) {
                lock = jvmLockMap.get(lockKey);
                if (null == lock) {
                    lock = new CountableLock();
                    jvmLockMap.put(lockKey, lock);
                }
                if (forLock) {
                    lock.increaseHold();
                }
            }
            return lock;
        }
    }
}

