/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.client;

import com.kingdee.bos.qing.common.rpc.client.IQRpcInvokeResultGroupFuture;
import com.kingdee.bos.qing.common.rpc.client.QRpcInvokeCallBack;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokeFuture;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokeResult;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class InvocationResultGroupFutureImpl
implements IQRpcInvokeResultGroupFuture {
    private String id;
    private Map<Long, QRpcInvokeFuture> futureMap = new ConcurrentHashMap<Long, QRpcInvokeFuture>();

    public InvocationResultGroupFutureImpl(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public QRpcInvokeFuture newFuture(long msgSeq, QRpcInvokeCallBack callBack) {
        QRpcInvokeFuture future = new QRpcInvokeFuture(msgSeq, this.id, callBack);
        this.futureMap.put(msgSeq, future);
        return future;
    }

    @Override
    public boolean hasWaitingFuture() {
        return !this.futureMap.isEmpty();
    }

    @Override
    public boolean existSubFuture(long msgSeq) {
        return this.futureMap.containsKey(msgSeq);
    }

    @Override
    public void removeFuture(long msgSeq) {
        this.futureMap.remove(msgSeq);
    }

    @Override
    public void setFutureResult(long seq, QRpcInvokeResult invokeResult) {
        QRpcInvokeFuture future = this.futureMap.remove(seq);
        if (null != future) {
            LogUtil.info("QingRPC:set invoke result:" + invokeResult);
            future.setResult(invokeResult);
        }
    }

    @Override
    public Set<Long> getCurrentWaitingSeqs() {
        return new HashSet<Long>(this.futureMap.keySet());
    }
}

