/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.client;

import com.kingdee.bos.qing.common.rpc.client.QRpcClient;
import com.kingdee.bos.qing.common.rpc.common.QRpcSystemApp;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRpcClientFactory
extends BasePooledObjectFactory<QRpcClient> {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String remoteServerIP;
    private int serverPort;
    private QRpcSystemApp systemApp;

    public QRpcClientFactory(QRpcSystemApp systemApp, String remoteServerIP, int serverPort) {
        this.remoteServerIP = remoteServerIP;
        this.serverPort = serverPort;
        this.systemApp = systemApp;
    }

    public QRpcClient create() throws Exception {
        return new QRpcClient(this.systemApp);
    }

    public PooledObject<QRpcClient> wrap(QRpcClient QRpcClient2) {
        return new DefaultPooledObject((Object)QRpcClient2);
    }

    public void destroyObject(PooledObject<QRpcClient> p) throws Exception {
        QRpcClient qRpcClient = (QRpcClient)p.getObject();
        qRpcClient.close();
    }

    public boolean validateObject(PooledObject<QRpcClient> p) {
        QRpcClient qRpcClient = (QRpcClient)p.getObject();
        return qRpcClient.isAlive();
    }

    public void activateObject(PooledObject<QRpcClient> p) throws Exception {
        QRpcClient qRpcClient = (QRpcClient)p.getObject();
        if (!qRpcClient.isAlive()) {
            qRpcClient.close();
            this.log.info("QingRPC:begin connect to server,host:" + this.remoteServerIP + ", port:" + this.serverPort);
            qRpcClient.connect(this.remoteServerIP, this.serverPort, 5000);
        }
    }
}

