/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.codec;

import com.kingdee.bos.qing.common.rpc.codec.VersionCodec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcMsgCodecFactory {
    private static Logger log = LoggerFactory.getLogger((String)RpcMsgCodecFactory.class.getName());
    private static Map<Byte, VersionCodec> codecMap = new ConcurrentHashMap<Byte, VersionCodec>(2);
    private static Map<String, VersionCodec> classToCodecMap = new ConcurrentHashMap<String, VersionCodec>(2);

    public static void regCodec(byte version, VersionCodec codec) {
        log.info("register rpc message codec, version:" + version + ", msgType:" + codec.getMsgClassType());
        codecMap.put(version, codec);
        classToCodecMap.put(codec.getMsgClassType().getName(), codec);
    }

    public static VersionCodec getCodecByVersion(byte version) {
        return codecMap.get(version);
    }

    public static VersionCodec getCodecByClass(Class msgClass) {
        return classToCodecMap.get(msgClass.getName());
    }
}

