/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.common;

import com.kingdee.bos.qing.common.rpc.client.QRpcInvokeCallBack;
import com.kingdee.bos.qing.common.rpc.common.IRpcInvokerProxy;
import com.kingdee.bos.qing.common.rpc.exception.QRpcInvokeErrorWithStatus;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class QRpcInvocationHandler
implements InvocationHandler {
    private IRpcInvokerProxy invokerRef;
    private boolean syncInvoke = true;
    private long timeoutInMilli = 60000L;
    private QRpcInvokeCallBack invokeCallBack;

    public QRpcInvocationHandler(IRpcInvokerProxy invokerRef, long timeoutInMilli) {
        this(invokerRef, true, timeoutInMilli, null);
    }

    public QRpcInvocationHandler(IRpcInvokerProxy invokerRef, boolean syncInvoke, long timeoutInMilli) {
        this(invokerRef, syncInvoke, timeoutInMilli, null);
    }

    public QRpcInvocationHandler(IRpcInvokerProxy invokerRef, boolean syncInvoke, long timeoutInMilli, QRpcInvokeCallBack invokeCallBack) {
        this.invokerRef = invokerRef;
        this.syncInvoke = syncInvoke;
        if (timeoutInMilli > 0L) {
            this.timeoutInMilli = timeoutInMilli;
        }
        this.invokeCallBack = invokeCallBack;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws QRpcInvokeErrorWithStatus {
        if (this.syncInvoke) {
            return this.invokerRef.invokeMethod(method.getName(), args, this.timeoutInMilli);
        }
        this.invokerRef.asyncInvokeMethod(method.getName(), args, this.invokeCallBack);
        return null;
    }
}

