/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.common;

import com.kingdee.bos.qing.common.rpc.client.QRpcClient;
import com.kingdee.bos.qing.common.rpc.client.QRpcClientPool;
import com.kingdee.bos.qing.common.rpc.client.QRpcInvokeCallBack;
import com.kingdee.bos.qing.common.rpc.common.IRpcInvokerProxy;
import com.kingdee.bos.qing.common.rpc.common.QRpcConfiguration;
import com.kingdee.bos.qing.common.rpc.common.QRpcSystem;
import com.kingdee.bos.qing.common.rpc.common.QRpcSystemApp;
import com.kingdee.bos.qing.common.rpc.exception.QRpcCodecException;
import com.kingdee.bos.qing.common.rpc.exception.QRpcConnectException;
import com.kingdee.bos.qing.common.rpc.exception.QRpcInvokeErrorWithStatus;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvocation;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokeResult;
import com.kingdee.bos.qing.common.rpc.model.QRpcResultStatus;

public class RemoteInvokerProxy
implements IRpcInvokerProxy {
    private String remoteInvokerId;
    private String remoteHost;
    private int port;
    private QRpcSystemApp appName;
    private boolean keepRpcClient;
    private QRpcClient rpcClient;

    public RemoteInvokerProxy(QRpcSystemApp appName, String remoteInvokerId, String remoteHost) {
        this.appName = appName;
        this.remoteInvokerId = remoteInvokerId;
        this.remoteHost = remoteHost;
        this.port = QRpcConfiguration.getServerPort();
        this.keepRpcClient = false;
    }

    public RemoteInvokerProxy(QRpcSystemApp appName, String remoteInvokerId, String remoteHost, int port) {
        this(appName, remoteInvokerId, remoteHost, port, false);
    }

    public RemoteInvokerProxy(QRpcSystemApp appName, String remoteInvokerId, String remoteHost, int port, boolean keepRpcClient) {
        this.appName = appName;
        this.remoteInvokerId = remoteInvokerId;
        this.remoteHost = remoteHost;
        this.port = port;
        this.keepRpcClient = keepRpcClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncInvokeMethod(String methodName, Object[] args, QRpcInvokeCallBack callBack) {
        QRpcClient rpcClient = null;
        try {
            rpcClient = this.getOrBorrowRpcClient();
            QRpcInvocation invocation = new QRpcInvocation();
            invocation.setArguments(args);
            invocation.setInvokerId(this.remoteInvokerId);
            invocation.setMethod(methodName);
            invocation.setAppName(this.appName);
            invocation.setRequestContext(QRpcSystem.getSystem(this.appName).getContextCodec().encodeContext());
            rpcClient.asyncSendReq(invocation, callBack);
        }
        catch (QRpcCodecException e) {
            QRpcInvokeResult invokeResult = new QRpcInvokeResult();
            invokeResult.setStatus(QRpcResultStatus.SEND_FAILED);
            invokeResult.setError(e);
            callBack.onInvoked(invokeResult);
        }
        catch (QRpcConnectException e) {
            QRpcInvokeResult invokeResult = new QRpcInvokeResult();
            invokeResult.setStatus(QRpcResultStatus.CONNECT_ERROR);
            invokeResult.setError(e);
            callBack.onInvoked(invokeResult);
        }
        finally {
            if (!this.keepRpcClient) {
                QRpcClientPool.getInstance().returnClient(rpcClient);
            }
        }
    }

    private QRpcClient getOrBorrowRpcClient() throws QRpcConnectException {
        if (null != this.rpcClient && this.rpcClient.isAlive()) {
            return this.rpcClient;
        }
        if (this.keepRpcClient) {
            this.rpcClient = QRpcClientPool.getInstance().borrowClient(this.appName, this.remoteHost, this.port);
            return this.rpcClient;
        }
        return QRpcClientPool.getInstance().borrowClient(this.appName, this.remoteHost, this.port);
    }

    @Override
    public Object invokeMethod(String methodName, Object[] args, long timeoutInMilli) throws QRpcInvokeErrorWithStatus {
        if (timeoutInMilli <= 0L) {
            timeoutInMilli = 60000L;
        }
        QRpcClient rpcClient = null;
        try {
            rpcClient = this.getOrBorrowRpcClient();
            QRpcInvocation invocation = new QRpcInvocation();
            invocation.setArguments(args);
            invocation.setInvokerId(this.remoteInvokerId);
            invocation.setMethod(methodName);
            invocation.setAppName(this.appName);
            invocation.setRequestContext(QRpcSystem.getSystem(this.appName).getContextCodec().encodeContext());
            QRpcInvokeResult invokeResult = rpcClient.sendReq(invocation, timeoutInMilli);
            QRpcResultStatus status = invokeResult.getStatus();
            if (status != QRpcResultStatus.SUCCEED) {
                throw new QRpcInvokeErrorWithStatus(invokeResult.getErrInfo(), status, invokeResult.getInvokeError());
            }
            Object object = invokeResult.getData();
            return object;
        }
        catch (QRpcCodecException e) {
            throw new QRpcInvokeErrorWithStatus(QRpcResultStatus.SEND_FAILED, (Throwable)e);
        }
        catch (QRpcConnectException e) {
            throw new QRpcInvokeErrorWithStatus(QRpcResultStatus.CONNECT_ERROR, (Throwable)e);
        }
        finally {
            if (!this.keepRpcClient) {
                QRpcClientPool.getInstance().returnClient(rpcClient);
            }
        }
    }

    @Override
    public void close() {
        if (null != this.rpcClient) {
            QRpcClientPool.getInstance().returnClient(this.rpcClient);
        }
    }
}

