/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.handler;

import com.kingdee.bos.qing.common.rpc.common.QRpcInvoker;
import com.kingdee.bos.qing.common.rpc.common.QRpcSystem;
import com.kingdee.bos.qing.common.rpc.handler.IRpcMessageHandler;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvocation;
import com.kingdee.bos.qing.common.rpc.model.QRpcMessage;
import com.kingdee.bos.qing.util.LogUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;

public class QRpcMessageHandler
implements IRpcMessageHandler<QRpcMessage> {
    @Override
    public void handleMsg(QRpcMessage rpcMessage, ChannelHandlerContext ctx) {
        byte msgType = rpcMessage.getMsgType();
        switch (msgType) {
            case 1: {
                this.handleInvocation(ctx, rpcMessage);
                break;
            }
            case 2: {
                ReferenceCountUtil.release((Object)rpcMessage);
                break;
            }
            case 0: {
                ctx.writeAndFlush((Object)rpcMessage);
                break;
            }
            default: {
                ctx.fireChannelRead((Object)rpcMessage);
            }
        }
    }

    private void handleInvocation(ChannelHandlerContext ctx, QRpcMessage rpcMessage) {
        LogUtil.info("QingRPC:handle qing rpc invocation ,seq=" + rpcMessage.getSeq() + ",content=" + rpcMessage.getData().toString());
        QRpcInvocation rpcInvocation = rpcMessage.getTypeMsg(QRpcInvocation.class);
        QRpcInvoker invoker = QRpcSystem.getSystem(rpcInvocation.getAppName()).getInvoker(rpcInvocation.getInvokerId());
        invoker.invoke(ctx, rpcMessage, rpcInvocation);
    }
}

