/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.model;

import com.kingdee.bos.qing.common.rpc.codec.CodecProtocol;
import com.kingdee.bos.qing.common.rpc.codec.serialization.SerializationType;
import com.kingdee.bos.qing.common.rpc.model.QRpcHeartBeat;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvocation;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokeResult;

public class QRpcMessage {
    private byte compressType = CodecProtocol.getCompressionType().getType();
    private byte serializeType = SerializationType.KRYO_V2.getType();
    private byte version = (byte)12;
    private Object msg;
    private long seq;
    private byte msgType = (byte)-1;

    public QRpcMessage(long seq, Object msg) {
        this.msg = msg;
        this.seq = seq;
        this.initMsgType(msg);
    }

    private void initMsgType(Object msg) {
        if (msg instanceof QRpcInvocation) {
            this.msgType = 1;
        } else if (msg instanceof QRpcInvokeResult) {
            this.msgType = 0;
        } else if (msg instanceof QRpcHeartBeat) {
            this.msgType = (byte)2;
        }
    }

    public QRpcMessage(long seq, byte compressType, byte serializeType, byte version, Object msg) {
        this.seq = seq;
        this.compressType = compressType;
        this.serializeType = serializeType;
        this.version = version;
        this.msg = msg;
        this.initMsgType(msg);
    }

    public byte getMsgType() {
        return this.msgType;
    }

    public byte getCompressType() {
        return this.compressType;
    }

    public byte getSerializeType() {
        return this.serializeType;
    }

    public byte getVersion() {
        return this.version;
    }

    public <T> T getTypeMsg(Class<T> type) {
        return type.cast(this.msg);
    }

    public Object getData() {
        return this.msg;
    }

    public long getSeq() {
        return this.seq;
    }
}

