/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.xml;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.impl.XmlDomReader;
import com.kingdee.bos.qing.common.xml.impl.XmlDomWriter;
import com.kingdee.bos.qing.common.xml.impl.XmlElement;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class XmlUtil {
    private XmlUtil() {
    }

    public static IXmlElement loadRootElement(InputStream stream) throws IOException, XmlParsingException {
        XmlDomReader reader = new XmlDomReader();
        return reader.read(stream);
    }

    public static IXmlElement loadRootElementFromFile(File file) throws IOException, XmlParsingException {
        IXmlElement iXmlElement;
        FileInputStream fis = new FileInputStream(file);
        try {
            iXmlElement = XmlUtil.loadRootElement(fis);
        }
        catch (Throwable throwable) {
            CloseUtil.close(fis);
            throw throwable;
        }
        CloseUtil.close(fis);
        return iXmlElement;
    }

    public static void save(IXmlElement xmlNode, OutputStream stream) throws IOException {
        XmlDomWriter writer = new XmlDomWriter();
        writer.write(xmlNode, stream);
    }

    public static void saveFile(IXmlElement xmlNode, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            XmlUtil.save(xmlNode, fos);
        }
        catch (Throwable throwable) {
            CloseUtil.close(fos);
            throw throwable;
        }
        CloseUtil.close(fos);
    }

    public static byte[] toByteArray(IXmlElement xmlNode) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            XmlUtil.save(xmlNode, outputStream);
        }
        catch (IOException e) {
            LogUtil.error(e.getMessage(), e);
        }
        return outputStream.toByteArray();
    }

    public static String toString(IXmlElement node) {
        try {
            return new String(XmlUtil.toByteArray(node), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static IXmlElement createNode(String name) {
        return new XmlElement(name);
    }

    public static IXmlElement getChild(IXmlElement parentNode, String name) {
        return parentNode.getChild(name);
    }

    public static IXmlElement getChildNotNull(IXmlElement parentNode, String name) throws NullException {
        IXmlElement childNode = parentNode.getChild(name);
        if (childNode == null) {
            throw new NullException("Node <" + parentNode.getName() + "> has no child: " + name);
        }
        return childNode;
    }

    public static List<IXmlElement> getChildren(IXmlElement parentNode, String name) {
        return parentNode.searchChildren(name);
    }

    public static List<IXmlElement> getChildren(IXmlElement parentNode) {
        return parentNode.getChildren();
    }

    public static String readAttrNotNull(IXmlElement xmlNode, String attributeKey) throws NullException {
        String attributeValue = xmlNode.getAttribute(attributeKey);
        if (attributeValue == null) {
            throw new NullException("Node <" + xmlNode.getName() + "> has no attribute: " + attributeKey);
        }
        return attributeValue;
    }

    public static void writeAttrNotNull(IXmlElement xmlNode, String attributeKey, String attributeValue) {
        if (attributeValue == null) {
            throw new RuntimeException("attributeValue must be not null.");
        }
        xmlNode.setAttribute(attributeKey, attributeValue);
    }

    public static String readAttrWhenExist(IXmlElement xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttribute(attributeKey);
        return attributeValue;
    }

    public static void writeAttrWhenExist(IXmlElement xmlNode, String attributeKey, String attributeValue) {
        if (attributeValue != null) {
            xmlNode.setAttribute(attributeKey, attributeValue);
        }
    }

    public static Boolean readAttrBoolWhenExist(IXmlElement xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttribute(attributeKey);
        if (attributeValue != null) {
            return Boolean.parseBoolean(attributeValue);
        }
        return null;
    }

    public static void writeAttrBoolWhenExist(IXmlElement xmlNode, String attributeKey, Boolean attributeValue) {
        if (attributeValue != null) {
            xmlNode.setAttribute(attributeKey, attributeValue.toString());
        }
    }

    public static boolean readAttrDefaultFalse(IXmlElement xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttribute(attributeKey);
        return attributeValue == null ? false : Boolean.parseBoolean(attributeValue);
    }

    public static void writeAttrDefaultFalse(IXmlElement xmlNode, String attributeKey, boolean attributeValue) {
        if (attributeValue) {
            xmlNode.setAttribute(attributeKey, Boolean.toString(true));
        }
    }

    public static boolean readAttrDefaultTrue(IXmlElement xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttribute(attributeKey);
        return attributeValue == null ? true : Boolean.parseBoolean(attributeValue);
    }

    public static void writeAttrDefaultTrue(IXmlElement xmlNode, String attributeKey, boolean attributeValue) {
        if (!attributeValue) {
            xmlNode.setAttribute(attributeKey, Boolean.toString(false));
        }
    }

    public static int readAttrInt(IXmlElement xmlNode, String attributeKey) throws NullException {
        String attributeValue = xmlNode.getAttribute(attributeKey);
        if (attributeValue == null) {
            throw new NullException("Node <" + xmlNode.getName() + "> has no attribute: " + attributeKey);
        }
        try {
            return Integer.parseInt(attributeValue);
        }
        catch (NumberFormatException ex) {
            throw new NullException("Node <" + xmlNode.getName() + "> has no numerical attribute: " + attributeKey);
        }
    }

    public static void writeAttrInt(IXmlElement xmlNode, String attributeKey, int attributeValue) {
        xmlNode.setAttribute(attributeKey, Integer.toString(attributeValue));
    }

    public static Integer readAttrIntWhenExist(IXmlElement xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttribute(attributeKey);
        if (attributeValue == null) {
            return null;
        }
        try {
            return Integer.parseInt(attributeValue);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static void writeAttrIntWhenExist(IXmlElement xmlNode, String attributeKey, Integer attributeValue) {
        if (attributeValue != null) {
            xmlNode.setAttribute(attributeKey, String.valueOf(attributeValue));
        }
    }

    public static long readAttrLong(IXmlElement xmlNode, String attributeKey) throws NullException {
        String attributeValue = xmlNode.getAttribute(attributeKey);
        if (attributeValue == null) {
            throw new NullException("Node <" + xmlNode.getName() + "> has no attribute: " + attributeKey);
        }
        try {
            return Long.parseLong(attributeValue);
        }
        catch (NumberFormatException ex) {
            throw new NullException("Node <" + xmlNode.getName() + "> has no numerical attribute: " + attributeKey);
        }
    }

    public static void writeAttrLong(IXmlElement xmlNode, String attributeKey, long attributeValue) {
        xmlNode.setAttribute(attributeKey, Long.toString(attributeValue));
    }

    public static Long readAttrLongWhenExist(IXmlElement xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttribute(attributeKey);
        if (attributeValue == null) {
            return null;
        }
        try {
            return Long.parseLong(attributeValue);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static void writeAttrLongWhenExist(IXmlElement xmlNode, String attributeKey, Long attributeValue) {
        if (attributeValue != null) {
            xmlNode.setAttribute(attributeKey, String.valueOf(attributeValue));
        }
    }

    public static void addCdata(IXmlElement xmlNode, String value) {
        if (value == null || value.indexOf("]]>") < 0) {
            xmlNode.addCData(value);
            return;
        }
        String[] arrValue = value.split("]]>", -1);
        int length = arrValue.length;
        for (int i = 0; i < length; ++i) {
            String str = arrValue[i];
            if (i != 0) {
                str = ">" + str;
            }
            xmlNode.addCData(str);
            if (i == length - 1) continue;
            xmlNode.addCData("]]");
        }
    }

    public static String getCdata(IXmlElement xmlNode) {
        return xmlNode.getText();
    }

    public static class NullException
    extends Exception {
        private static final long serialVersionUID = -8145245827944452494L;

        public NullException(String message) {
            super(message);
        }
    }
}

