/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.config;

import com.kingdee.bos.qing.common.memory.MemWarningLevel;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.bos.qing.datasource.join.config.WarningCondition;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QingJoinConfig {
    private static QingJoinConfig qingJoinConfig = new QingJoinConfig();
    private final String configKey = "qing.join.config";
    private IXmlElement root = null;
    private List<WarningCondition> warningConditions;
    private long maxJoinLimit;
    private long safeJoinLimit;
    private double delayMemRadio;
    private int memScanInterval;
    private int longJoinTimeThreadShold;
    private int workNodeSize;
    private MemWarningLevel maxLimitCheckTriggerLevel;
    private int timeout;
    private long smallJoinThreadShold;
    private int maxRetryParallise;
    private MemWarningLevel retryTriggerLevel;
    private int maxSurvival;
    private int maxRetryTimes;
    private boolean isMemMonitorOpened = false;

    private QingJoinConfig() {
        InputStream in = this.loadFromSystemProp();
        if (null == in) {
            in = QingJoinConfig.class.getResourceAsStream("/JoinConfig.xml");
        }
        if (null == in) {
            in = this.loadFromFile();
        }
        try {
            if (null != in) {
                this.load(in);
            }
            this.readConfig();
        }
        catch (Throwable throwable) {
            CloseUtil.close(in);
            throw throwable;
        }
        CloseUtil.close(in);
    }

    private void readConfig() {
        this.maxJoinLimit = Long.parseLong(this.getAttrValue("MaxJoinCount", "value", "10000000"));
        this.safeJoinLimit = Long.parseLong(this.getAttrValue("SafeJoinCount", "value", "500000"));
        this.delayMemRadio = Double.parseDouble(this.getAttrValue("DelayMemRatio", "value", "0.7"));
        this.memScanInterval = Integer.parseInt(this.getAttrValue("MemoryMonitor", "interval", "3"));
        this.longJoinTimeThreadShold = Integer.parseInt(this.getAttrValue("LongTimeJoining", "value", "180"));
        this.workNodeSize = Integer.parseInt(this.getAttrValue("WorkNode", "size", "0"));
        this.maxLimitCheckTriggerLevel = MemWarningLevel.valueOf(this.getAttrValue("MaxJoinCount", "triggerLevel", "YELLOW"));
        this.timeout = Integer.parseInt(this.getAttrValue("Timeout", "value", "600"));
        this.smallJoinThreadShold = Integer.parseInt(this.getAttrValue("SmallJoinThreadShold", "value", "50000"));
        this.isMemMonitorOpened = Boolean.parseBoolean(this.getAttrValue("MemoryMonitor", "open", "true"));
        this.readWarningCondition();
        this.readRetryConfig();
    }

    public boolean isMemMonitorOpened() {
        return this.isG1GarbageCollector() && this.isMemMonitorOpened;
    }

    private boolean isG1GarbageCollector() {
        List<MemoryPoolMXBean> poolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : poolMXBeans) {
            if (!memoryPoolMXBean.getName().toUpperCase().contains("G1")) continue;
            return true;
        }
        return false;
    }

    private void readRetryConfig() {
        this.maxRetryParallise = Integer.parseInt(this.getAttrValue("Retry", "maxRetryParalise", "-1"));
        String retryTriggerValue = this.getAttrValue("Retry", "triggerLevel", "");
        if (!retryTriggerValue.isEmpty()) {
            this.retryTriggerLevel = MemWarningLevel.valueOf(retryTriggerValue);
        }
        this.maxSurvival = Integer.parseInt(this.getAttrValue("Retry", "maxSurvival", "0"));
        this.maxRetryTimes = Integer.parseInt(this.getAttrValue("Retry", "maxRetryTimes", "3"));
    }

    public MemWarningLevel getRetryTriggerLevel() {
        return this.retryTriggerLevel;
    }

    public int getMaxSurvival() {
        return this.maxSurvival;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public int getMaxRetryParallise() {
        return this.maxRetryParallise;
    }

    public long getSmallJoinThreadShold() {
        return this.smallJoinThreadShold;
    }

    public static synchronized QingJoinConfig getInstance() {
        return qingJoinConfig;
    }

    private String getAttrValue(String elementName, String attrName, String defaultValue) {
        if (null == this.root) {
            return defaultValue;
        }
        IXmlElement element = this.root.getChild(elementName);
        if (null == element) {
            return defaultValue;
        }
        try {
            String value = element.getAttribute(attrName);
            return null == value ? defaultValue : value;
        }
        catch (Exception e) {
            LogUtil.warn(e.getMessage() + "get attribute value failed:" + elementName + "." + attrName);
            return defaultValue;
        }
    }

    public double getDelayMemRatio() {
        return this.delayMemRadio;
    }

    public long getSafeJoinDataLimit() {
        return this.safeJoinLimit;
    }

    public long getMaxJoinDataLimit() {
        return this.maxJoinLimit;
    }

    public int getWorkNodeSize() {
        return this.workNodeSize;
    }

    public MemWarningLevel getMaxJoinDataTriggerLevel() {
        return this.maxLimitCheckTriggerLevel;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getLongJoinTime() {
        return this.longJoinTimeThreadShold;
    }

    public int getMemScanInterval() {
        return this.memScanInterval;
    }

    private void readWarningCondition() {
        this.warningConditions = new ArrayList<WarningCondition>();
        List<IXmlElement> warningElements = this.getWarningElements();
        if (null == warningElements) {
            this.addDefaultWarningCondition();
        } else {
            this.parseWarningElements(warningElements);
        }
        Collections.sort(this.warningConditions);
    }

    public List<WarningCondition> getWarningConditions() {
        return this.warningConditions;
    }

    private void parseWarningElements(List<IXmlElement> warningElements) {
        try {
            for (IXmlElement warningElement : warningElements) {
                double ratio = Double.parseDouble(warningElement.getAttribute("ratio"));
                int times = Integer.parseInt(warningElement.getAttribute("times"));
                MemWarningLevel level = MemWarningLevel.valueOf(warningElement.getAttribute("level"));
                this.warningConditions.add(new WarningCondition(ratio, level, times));
            }
        }
        catch (Exception e) {
            LogUtil.error("memory warning config data is invalid", e);
            this.addDefaultWarningCondition();
        }
    }

    private void addDefaultWarningCondition() {
        this.warningConditions.clear();
        this.warningConditions.add(new WarningCondition(0.6, MemWarningLevel.BLUE, 3));
        this.warningConditions.add(new WarningCondition(0.7, MemWarningLevel.YELLOW, 3));
        this.warningConditions.add(new WarningCondition(0.8, MemWarningLevel.ORANGE, 3));
        this.warningConditions.add(new WarningCondition(0.9, MemWarningLevel.RED, 1));
    }

    private List<IXmlElement> getWarningElements() {
        IXmlElement parent;
        if (null != this.root && null != (parent = this.root.getChild("MemoryMonitor"))) {
            return parent.searchChildren("warning");
        }
        return null;
    }

    private void load(InputStream inputStream) {
        try {
            this.root = XmlUtil.loadRootElement(inputStream);
        }
        catch (Exception e) {
            LogUtil.error("create join config  error", e);
        }
    }

    private InputStream loadFromFile() {
        String path = System.getProperty("bos.config");
        if (path != null) {
            File brother = new File(path);
            path = brother.getParent();
            String filePath = path + File.separator + "JoinConfig.xml";
            try {
                return new FileInputStream(new File(filePath));
            }
            catch (FileNotFoundException e) {
                LogUtil.error("file not found:" + filePath, e);
            }
        }
        return null;
    }

    private InputStream loadFromSystemProp() {
        String joinConfigXml = System.getProperty("qing.join.config");
        ByteArrayInputStream in = null;
        if (null != joinConfigXml && !joinConfigXml.trim().isEmpty()) {
            in = new ByteArrayInputStream(joinConfigXml.getBytes(Charset.forName("UTF-8")));
        }
        return in;
    }
}

