/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.resource.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.integrated.IIntegratedHelperStrategy;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.resource.model.QueryResourceVo;
import com.kingdee.bos.qing.resource.model.ScheduleFromTypeEnum;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import com.kingdee.bos.qing.util.DateUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ResourceInfoDao {
    private IDBExcuter dbExcuter;

    public ResourceInfoDao(IDBExcuter idbExcuter) {
        this.dbExcuter = idbExcuter;
    }

    public List<String> getAllContactInfo() throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT  FR.FDISPLAYNAME || '/' || FR.FFROMID ||  '/' || FR.FUSERID ||  '/' ||FR.FFROMTYPE AS  CONCAT_INFO  FROM T_QING_FILE_RESOURCE FR WHERE FR.FUSERID = '1526838315662231552' ";
        return this.dbExcuter.query(sql, new Object[0], new ResultHandler<List<String>>(){

            @Override
            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> lists = new ArrayList<String>();
                while (rs.next()) {
                    lists.add(rs.getString("CONCAT_INFO"));
                }
                return lists;
            }
        });
    }

    public Integer getFileResourceCount(String userId, String searchText) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT COUNT(1) AS COUNT_FILE_RESOURCE FROM T_QING_FILE_RESOURCE FR WHERE FR.FUSERID = ? ");
        sqlBuilder.append("AND (FR.FFROMTYPE='FONTLIBRARY' OR FR.FFROMTYPE='IMAGELIBRARY' OR FR.FFROMTYPE='THEME' OR FR.FFROMTYPE='THEMESCHEDULE' OR FR.FFROMTYPE='THEMESOURCECONVERT' OR FR.FFROMTYPE='PUBLISHED' OR FR.FFROMTYPE='CARDTHUMBNAIL'OR FR.FFROMTYPE='TIMINGPUSH')");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        if (StringUtils.isNotBlank(searchText)) {
            sqlBuilder.append(" AND (UPPER(FR.FDISPLAYNAME) LIKE ?)");
            queryValue.add("%" + searchText.toUpperCase() + "%");
        }
        return this.dbExcuter.query(sqlBuilder.toString(), queryValue.toArray(), new ResultHandler<Integer>(){

            @Override
            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("count_file_resource");
                }
                return 0;
            }
        });
    }

    public Integer getScheduleResourceCount(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT COUNT(1) AS SCHEDULECOUNT FROM T_QING_SCHEDULE_EXECUTE SE WHERE SE.FUSERID= ?  AND (SE.FMETHODNAME='extractThemeData' OR SE.FMETHODNAME='updateLappThumbnail' OR SE.FMETHODNAME='emailPublishExecute' OR SE.FMETHODNAME='pushExecute')  AND SE.FEXECUTETIME>=? AND SE.FEXECUTETIME<=? ";
        return this.dbExcuter.query(sql, new Object[]{userId, DateUtils.getTimeMin(new Date()), DateUtils.getTimeMax(new Date())}, new ResultHandler<Integer>(){

            @Override
            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("SCHEDULECOUNT");
                }
                return 0;
            }
        });
    }

    public Integer getAllScheduleResourceCount(String userId, String searchText, Integer currentStatus, Integer currentScheduleType, Long startDateTimeStamp, Long endDateTimeStamp) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT COUNT(1) AS SCHEDULECOUNT FROM T_QING_SCHEDULE_EXECUTE SE ");
        StringBuilder conditionBuilder = new StringBuilder();
        conditionBuilder.append(" WHERE SE.FUSERID= ? ");
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(userId);
        if (QueryResourceVo.QueryStatus.EXECUTESTATE_SUCCESS.isStatus(currentStatus)) {
            conditionBuilder.append(" AND SE.FEXECUTESTATE = 1 ");
        } else if (QueryResourceVo.QueryStatus.EXECUTESTATE_DEFEAT.isStatus(currentStatus)) {
            conditionBuilder.append(" AND (SE.FEXECUTESTATE = 2 OR SE.FEXECUTESTATE = 4) ");
        } else if (QueryResourceVo.QueryStatus.EXECUTESTATE_PROGRESS.isStatus(currentStatus)) {
            conditionBuilder.append(" AND SE.FEXECUTESTATE = 0 ");
        } else if (QueryResourceVo.QueryStatus.EXECUTESTATE_UNMATCHED.isStatus(currentStatus)) {
            conditionBuilder.append(" AND SE.FEXECUTESTATE = 5 ");
        } else if (QueryResourceVo.QueryStatus.EXECUTESTATE_PART_ERROR.isStatus(currentStatus)) {
            conditionBuilder.append(" AND SE.FEXECUTESTATE = 6 ");
        }
        if (QueryResourceVo.QueryScheduleType.SCHEDULETYPE_ETD.isType(currentScheduleType)) {
            conditionBuilder.append(" AND SE.FMETHODNAME='extractThemeData' ");
        } else if (QueryResourceVo.QueryScheduleType.SCHEDULETYPE_LT.isType(currentScheduleType)) {
            conditionBuilder.append(" AND SE.FMETHODNAME='updateLappThumbnail' ");
        } else if (QueryResourceVo.QueryScheduleType.SCHEDULETYPE_PCH.isType(currentScheduleType)) {
            sqlBuilder.append(" LEFT JOIN T_QING_PUSH_CONFIG_INFO PCI ON SE.FSOURCEID=PCI.FID ");
            conditionBuilder.append(" AND SE.FMETHODNAME='pushExecute' AND PCI.FPUSHTARGET='0' ");
        } else if (QueryResourceVo.QueryScheduleType.SCHEDULETYPE_PEWC.isType(currentScheduleType)) {
            sqlBuilder.append(" LEFT JOIN T_QING_PUSH_CONFIG_INFO PCI ON SE.FSOURCEID=PCI.FID ");
            conditionBuilder.append(" AND SE.FMETHODNAME='pushExecute' AND PCI.FPUSHTARGET='1' ");
        } else if (QueryResourceVo.QueryScheduleType.SCHEDULETYPE_PDD.isType(currentScheduleType)) {
            sqlBuilder.append(" LEFT JOIN T_QING_PUSH_CONFIG_INFO PCI ON SE.FSOURCEID=PCI.FID ");
            conditionBuilder.append(" AND SE.FMETHODNAME='pushExecute' AND PCI.FPUSHTARGET='3' ");
        } else if (QueryResourceVo.QueryScheduleType.SCHEDULETYPE_PE.isType(currentScheduleType)) {
            conditionBuilder.append(" AND SE.FMETHODNAME='emailPublishExecute' ");
        } else {
            conditionBuilder.append(" AND (SE.FMETHODNAME='extractThemeData' OR SE.FMETHODNAME='updateLappThumbnail' OR SE.FMETHODNAME='emailPublishExecute' OR SE.FMETHODNAME='pushExecute') ");
        }
        if (StringUtils.isNotBlank(searchText)) {
            conditionBuilder.append(" AND UPPER(SE.FSCHEDULENAME || SE.FSOURCENAME) LIKE ? ");
            queryValue.add("%" + searchText.toUpperCase() + "%");
        }
        StringBuilder sqlBuilderOfEnd = new StringBuilder();
        sqlBuilderOfEnd.append(" AND SE.FEXECUTETIME>=? AND SE.FEXECUTETIME<=? ");
        conditionBuilder.append((CharSequence)sqlBuilderOfEnd);
        queryValue.add(new Date(startDateTimeStamp));
        queryValue.add(new Date(endDateTimeStamp));
        sqlBuilder.append((CharSequence)conditionBuilder);
        return this.dbExcuter.query(sqlBuilder.toString(), queryValue.toArray(), new ResultHandler<Integer>(){

            @Override
            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("SCHEDULECOUNT");
                }
                return 0;
            }
        });
    }

    public List<FileResourceVO> findFileResourceInfoByUserId(String sql, Object[] objects) throws AbstractQingIntegratedException, SQLException {
        return this.dbExcuter.query(sql, objects, new ResultHandler<List<FileResourceVO>>(){

            @Override
            public List<FileResourceVO> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper = CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<FileResourceVO> list = new ArrayList<FileResourceVO>();
                while (rs.next()) {
                    FileResourceVO resourceFile = new FileResourceVO();
                    resourceFile.setFromId(rs.getString("FFROMID"));
                    resourceFile.setDisplayName(rs.getString("FDISPLAYNAME"));
                    resourceFile.setFileSizeNoFormat(rs.getString("FFILESIZE"));
                    long fcreatedate = rs.getTimestamp("FCREATEDATE").getTime();
                    resourceFile.setCreateDate(fcreatedate);
                    String formatDateTime = IntegratedHelper.formatDateTime(new Date(fcreatedate));
                    resourceFile.setCreateDateFormat(formatDateTime);
                    String fromType = rs.getString("FFROMTYPE");
                    resourceFile.setFromType(fromType);
                    resourceFile.setUserId(rs.getString("FUSERID"));
                    String concatInfo = rs.getString("FROMPATH");
                    resourceFile.setConcatInfo(concatInfo);
                    list.add(resourceFile);
                }
                return list;
            }
        });
    }

    private String[] splitConcatInfos(String concatInfo) {
        return concatInfo.split("/", -1);
    }

    public List<ScheduleExecuteVO> findScheduleResourceInfoByUserId(String sql, Object[] objects) throws AbstractQingIntegratedException, SQLException {
        return this.dbExcuter.query(sql, objects, new ResultHandler<List<ScheduleExecuteVO>>(){

            @Override
            public List<ScheduleExecuteVO> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper = CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<ScheduleExecuteVO> list = new ArrayList<ScheduleExecuteVO>();
                while (rs.next()) {
                    ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                    scheduleExecute.setId(rs.getString("FID"));
                    scheduleExecute.setUserId(rs.getString("FUSERID"));
                    scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
                    scheduleExecute.setSourceId(rs.getString("FSOURCEID"));
                    scheduleExecute.setSourceName(rs.getString("FSOURCENAME"));
                    scheduleExecute.setMethodName(rs.getString("FMETHODNAME"));
                    scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    long fexecutetime = rs.getTimestamp("FEXECUTETIME").getTime();
                    scheduleExecute.setExecuteTime(fexecutetime);
                    String executeTimeFormat = IntegratedHelper.formatDateTime(new Date(fexecutetime));
                    scheduleExecute.setExecuteTimeFormat(executeTimeFormat);
                    if (rs.getTimestamp("FENDTIME") != null) {
                        long fendtime = rs.getTimestamp("FENDTIME").getTime();
                        scheduleExecute.setEndTime(fendtime);
                        String endTimeFormat = IntegratedHelper.formatDateTime(new Date(fendtime));
                        scheduleExecute.setEndTimeFormat(endTimeFormat);
                    }
                    String[] infos = ResourceInfoDao.this.splitConcatInfos(rs.getString("SCHEDULEOPERATION"));
                    Integer scheduleResourceTypeIndex = 0;
                    if (ScheduleFromTypeEnum.PUSH.name().equals(infos[scheduleResourceTypeIndex])) {
                        ResourceInfoDao.this.processPushScheduleResourceInfo(scheduleExecute, infos);
                    } else if (ScheduleFromTypeEnum.THEME.name().equals(infos[scheduleResourceTypeIndex])) {
                        ResourceInfoDao.this.processExtraThemeDataScheduleResourceInfo(scheduleExecute, infos);
                    } else if (ScheduleFromTypeEnum.LAPPTHUMBNAIL.name().equals(infos[scheduleResourceTypeIndex])) {
                        ResourceInfoDao.this.processLAppThumbnailScheduleResourceInfo(scheduleExecute, infos);
                    } else if (ScheduleFromTypeEnum.EMAIL.name().equals(infos[scheduleResourceTypeIndex])) {
                        ResourceInfoDao.this.processEmailScheduleResourceInfo(scheduleExecute, infos);
                    } else if (ScheduleFromTypeEnum.IMAGELIBRARY.name().equals(infos[scheduleResourceTypeIndex])) {
                        ResourceInfoDao.this.processImageLibraryScheduleResourceInfo(scheduleExecute, infos);
                    }
                    list.add(scheduleExecute);
                }
                return list;
            }
        });
    }

    private void processPushScheduleResourceInfo(ScheduleExecuteVO scheduleExecuteVO, String[] infos) {
        Integer configIdIndex = 1;
        Integer pushTypeIndex = 2;
        scheduleExecuteVO.setSourceTargetType(infos[pushTypeIndex]);
        scheduleExecuteVO.setSourceExist(StringUtils.isNotBlank(infos[configIdIndex]));
        if (!StringUtils.isNotBlank(infos[configIdIndex])) {
            String prompt = Messages.getMLS("pushConfigDeleted", "\u5b9a\u65f6\u63a8\u9001\u914d\u7f6e\u5df2\u5220\u9664", Messages.ProjectName.QING_COMMON);
            scheduleExecuteVO.setSourceName(prompt + ":" + scheduleExecuteVO.getSourceName());
        }
    }

    private void processExtraThemeDataScheduleResourceInfo(ScheduleExecuteVO scheduleExecuteVO, String[] infos) {
        Integer themeIdIndex = 1;
        Integer themeNameIndex = 2;
        Integer themeGroupNameIndex = 3;
        if (StringUtils.isNotBlank(infos[themeIdIndex])) {
            scheduleExecuteVO.setSourceExist(true);
            scheduleExecuteVO.setSourcePathName(infos[themeGroupNameIndex] + "/" + infos[themeNameIndex]);
        } else {
            String prompt = Messages.getMLS("subjectDeleted", "\u4e1a\u52a1\u4e3b\u9898\u5df2\u5220\u9664", Messages.ProjectName.QING_COMMON);
            scheduleExecuteVO.setSourceName(prompt + ":" + scheduleExecuteVO.getSourceName());
        }
    }

    private void processLAppThumbnailScheduleResourceInfo(ScheduleExecuteVO scheduleExecuteVO, String[] infos) {
        Integer publishIdIndex = 1;
        Integer publishNameIndex = 2;
        Integer publishPathIndex = 3;
        Integer publishTypeIndex = 4;
        Integer publishGroupName = 5;
        if (StringUtils.isNotBlank(infos[publishIdIndex])) {
            scheduleExecuteVO.setSourcePath(infos[publishPathIndex]);
            scheduleExecuteVO.setSourceTargetType(infos[publishTypeIndex]);
            scheduleExecuteVO.setSourceExist(StringUtils.isNotBlank(infos[publishIdIndex]));
        } else {
            String prompt = Messages.getMLS("publishDeleted", "\u53d1\u5e03\u8bb0\u5f55\u5df2\u5220\u9664", Messages.ProjectName.QING_COMMON);
            scheduleExecuteVO.setSourceName(prompt + ":" + scheduleExecuteVO.getSourceName());
        }
    }

    private void processEmailScheduleResourceInfo(ScheduleExecuteVO scheduleExecuteVO, String[] infos) {
        Integer publishEmailIdIndex = 1;
        String PUSH_TARGET_TYPE_EMAIL = "-1";
        if (StringUtils.isNotBlank(infos[publishEmailIdIndex])) {
            scheduleExecuteVO.setSourceExist(true);
            scheduleExecuteVO.setSourceTargetType("-1");
        } else {
            String prompt = Messages.getMLS("pushConfigDeleted", "\u5b9a\u65f6\u63a8\u9001\u914d\u7f6e\u5df2\u5220\u9664", Messages.ProjectName.QING_COMMON);
            scheduleExecuteVO.setSourceName(prompt + ":" + scheduleExecuteVO.getSourceName());
        }
    }

    private void processImageLibraryScheduleResourceInfo(ScheduleExecuteVO scheduleExecuteVO, String[] infos) {
    }
}

