/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.resource.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.filesystem.manager.fileresource.domain.FileResourceDomain;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.resource.AbstractResourceManager;
import com.kingdee.bos.qing.resource.dao.ResourceInfoDao;
import com.kingdee.bos.qing.resource.domain.IResInfoManagerDomain;
import com.kingdee.bos.qing.resource.domain.ResInfoManagerDomainFactory;
import com.kingdee.bos.qing.resource.exception.ResourceManagementException;
import com.kingdee.bos.qing.resource.model.QueryResourceVo;
import com.kingdee.bos.qing.resource.model.ResInfoManagerType;
import com.kingdee.bos.qing.resource.model.ResourceInfoFieldEnum;
import com.kingdee.bos.qing.resource.model.ResourceInfoVO;
import com.kingdee.bos.qing.resource.model.ResourceSortOrderEnum;
import com.kingdee.bos.qing.resource.model.ResourceTypeEnum;
import com.kingdee.bos.qing.schedule.domain.ScheduleExecuteDomain;
import com.kingdee.bos.qing.schedule.model.AppTypeEnum;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.DateUtils;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.pagination.PaginationRequestData;
import com.kingdee.bos.qing.util.pagination.PaginationUtil;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceInfoDomain {
    private AbstractResourceManager resourceManager;
    private FileResourceDomain fileResourceDomain;
    private ScheduleExecuteDomain scheduleExecuteDomain;
    private ResourceInfoDao resourceInfoDao;
    private QingContext qingContext;

    public ResourceInfoDomain(AbstractResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public ResourceInfoDomain(AbstractResourceManager resourceManager, QingContext qingContext, IDBExcuter dbExcuter) {
        this.resourceManager = resourceManager;
        this.qingContext = qingContext;
        this.resourceInfoDao = new ResourceInfoDao(dbExcuter);
    }

    public FileResourceDomain getFileResourceDomain() {
        if (this.fileResourceDomain == null) {
            this.fileResourceDomain = this.resourceManager.getFileResourceDomain();
        }
        return this.fileResourceDomain;
    }

    public ScheduleExecuteDomain getScheduleExecuteDomain() {
        if (this.scheduleExecuteDomain == null) {
            this.scheduleExecuteDomain = this.resourceManager.getScheduleExecuteDomain();
        }
        return this.scheduleExecuteDomain;
    }

    public ResourceInfoVO resourceInfoStatistics() throws AbstractQingIntegratedException, ResourceManagementException {
        int otherUserTenantUseScheduleCount;
        BigDecimal otherUserTenantUseFileSize;
        ResourceInfoVO resourceInfo = new ResourceInfoVO();
        int userFreeFileSize = this.getFileResourceDomain().getUserFreeFileSize();
        int tenantFreeFileSize = this.getFileResourceDomain().getTenantFreeFileSize();
        BigDecimal userFreeFileSizeByte = new BigDecimal(0x100000L * (long)userFreeFileSize);
        BigDecimal tenantFreeFileSizeByte = new BigDecimal(0x100000L * (long)tenantFreeFileSize);
        BigDecimal tenantPayFileSize = this.getFileResourceDomain().findPaySizeByTenantId().multiply(new BigDecimal(0x100000L));
        BigDecimal tenantFileSize = tenantPayFileSize.add(tenantFreeFileSizeByte);
        BigDecimal tenantUseFileSize = this.getFileResourceDomain().findSumTenantUseFileSizeByTenantId();
        resourceInfo.setTenantFreeFileSize("" + tenantFreeFileSize);
        resourceInfo.setTenantPayFileSize(this.byteToMBStr(tenantPayFileSize));
        resourceInfo.setTenantFileSize(this.byteToMBStr(tenantFileSize));
        resourceInfo.setTenantUseFileSize(this.byteToMBStr(tenantUseFileSize));
        BigDecimal userUseFileSize = this.getFileResourceDomain().findSumFileSizeByUserId();
        BigDecimal bigDecimal = otherUserTenantUseFileSize = userUseFileSize.compareTo(userFreeFileSizeByte) < 0 ? tenantUseFileSize : tenantUseFileSize.subtract(userUseFileSize.subtract(userFreeFileSizeByte));
        if (otherUserTenantUseFileSize.compareTo(tenantFileSize) > 0) {
            otherUserTenantUseFileSize = tenantFileSize;
        }
        resourceInfo.setUserFreeFileSize("" + userFreeFileSize);
        resourceInfo.setUserUseFileSize(this.byteToMBStr(userUseFileSize));
        resourceInfo.setOtherUserTenantUseFileSize(this.byteToMBStr(otherUserTenantUseFileSize));
        BigDecimal totalFileSizeByte = tenantFileSize.add(userFreeFileSizeByte);
        resourceInfo.setTotalFileSize(this.byteToIntMBStr(totalFileSizeByte));
        resourceInfo.setAvaFileSize(this.byteToMBStr(userFreeFileSizeByte.add(tenantFileSize).subtract(userUseFileSize).subtract(otherUserTenantUseFileSize)));
        resourceInfo.setUserAvaFileSize(this.byteToMBStr(userFreeFileSizeByte.subtract(userUseFileSize)));
        resourceInfo.setTenantAvaFileSize(this.byteToMBStr(tenantFileSize.subtract(tenantUseFileSize)));
        resourceInfo.setUserUseFileSizePercent(userFreeFileSizeByte.compareTo(BigDecimal.ZERO) == 0 ? 0.0 : userUseFileSize.divide(userFreeFileSizeByte, 2, 4).doubleValue());
        resourceInfo.setTenantOTherUserFileSizePercent(otherUserTenantUseFileSize.divide(userFreeFileSizeByte.add(tenantFileSize), 2, 4).doubleValue());
        resourceInfo.setUserFreeFileSizePercent(userFreeFileSizeByte.divide(totalFileSizeByte, 2, 4).doubleValue());
        resourceInfo.setTenantUseFileSizePercent(tenantFileSize.compareTo(BigDecimal.ZERO) == 0 ? 0.0 : tenantUseFileSize.divide(tenantFileSize, 2, 4).doubleValue());
        int userFreeScheduleCount = this.getScheduleExecuteDomain().getUserFreeScheduleCount();
        int tenantFreeScheduleCount = this.getScheduleExecuteDomain().getTenantFreeScheduleCount();
        int tenantPayScheduleCount = this.getScheduleExecuteDomain().findPaySizeByTenantId();
        int tenantScheduleCount = tenantPayScheduleCount + tenantFreeScheduleCount;
        int tenantUseScheduleCount = this.getScheduleExecuteDomain().getTenantUseScheduleCountByTenant(DateUtils.getTimeMin(new Date()), DateUtils.getTimeMax(new Date()), AppTypeEnum.qing);
        int userUseScheduleCount = this.getScheduleExecuteDomain().getUserUseScheduleCountByUserId(DateUtils.getTimeMin(new Date()), DateUtils.getTimeMax(new Date()), AppTypeEnum.qing);
        int n = otherUserTenantUseScheduleCount = userUseScheduleCount < userFreeScheduleCount ? tenantUseScheduleCount : tenantUseScheduleCount - (userUseScheduleCount - userFreeScheduleCount);
        if (otherUserTenantUseScheduleCount > tenantScheduleCount) {
            otherUserTenantUseScheduleCount = tenantScheduleCount;
        }
        resourceInfo.setTenantFreeScheduleCount(tenantFreeScheduleCount);
        resourceInfo.setTenantPayScheduleCount(tenantPayScheduleCount);
        resourceInfo.setTenantScheduleCount(tenantScheduleCount);
        resourceInfo.setTenantUseScheduleCount(tenantUseScheduleCount);
        resourceInfo.setOtherUserTenantUseScheduleCount(otherUserTenantUseScheduleCount);
        resourceInfo.setUserFreeScheduleCount(userFreeScheduleCount);
        resourceInfo.setUserUseScheduleCount(userUseScheduleCount);
        resourceInfo.setTotalScheduleCount(userFreeScheduleCount + tenantScheduleCount);
        resourceInfo.setAvaScheduleCount(userFreeScheduleCount + tenantScheduleCount - userUseScheduleCount - otherUserTenantUseScheduleCount);
        resourceInfo.setUserAvaScheduleCount(userFreeScheduleCount - userUseScheduleCount);
        resourceInfo.setTenantAvaScheduleCount(tenantScheduleCount - tenantUseScheduleCount);
        resourceInfo.setUserUseScheduleCountPercent(this.percentToDouble(userUseScheduleCount, userFreeScheduleCount));
        resourceInfo.setTenantOTherScheduleCountPercent(this.percentToDouble(otherUserTenantUseScheduleCount, userFreeScheduleCount + tenantScheduleCount));
        resourceInfo.setUserFreeScheduleCountPercent(this.percentToDouble(userFreeScheduleCount, userFreeScheduleCount + tenantScheduleCount));
        resourceInfo.setTenantUseScheduleCountPercent(this.percentToDouble(tenantUseScheduleCount, tenantScheduleCount));
        return resourceInfo;
    }

    public Map<String, Object> getFileUsageInfoByPaging(String resourceType, Integer targetPage, Integer pageSize, String sortField, String sortOrder, String searchText) throws AbstractQingIntegratedException, ResourceManagementException, SQLException {
        if (ResourceTypeEnum.FILE.name().equals(resourceType)) {
            return this.getFileUsageInfoByPaging(targetPage, pageSize, sortField, sortOrder, searchText);
        }
        throw new ResourceManagementException("Unsupport resource type :" + resourceType);
    }

    public Map<String, Object> getTodayScheduleInfoByPaging(String resourceType, Integer targetPage, Integer pageSize, String sortField, String sortOrder) throws AbstractQingIntegratedException, ResourceManagementException, SQLException {
        if (ResourceTypeEnum.SCHEDULE.name().equals(resourceType)) {
            return this.getTodayScheduleInfoByPaging(targetPage, pageSize, sortField, sortOrder);
        }
        throw new ResourceManagementException("Unsupport resource type :" + resourceType);
    }

    private String unionSql(List<String> sqls) {
        StringBuilder sqlUnion = new StringBuilder();
        for (String sql : sqls) {
            sqlUnion.append("( ");
            sqlUnion.append(sql);
            sqlUnion.append(") ");
            sqlUnion.append(" UNION ");
        }
        return sqlUnion.substring(0, sqlUnion.length() - 7);
    }

    private String generateFileTypeResourceQuerySql(String sqlUnion, String sortField, String sortOrder, Integer offset, Integer pageSize) {
        if (StringUtils.isBlank(sortField)) {
            sortField = "FILESIZE";
        }
        if (StringUtils.isBlank(sortOrder)) {
            sortOrder = "DESC";
        }
        StringBuilder lastSql = new StringBuilder();
        String limitPage = "SELECT TOP " + pageSize + "," + offset + " ";
        String selectPart = " RS.FFROMID, RS.FUSERID, RS.FDISPLAYNAME, RS.FFROMTYPE, RS.FCREATEDATE, RS.FFILESIZE, RS.FROMPATH FROM ";
        String asRs = " AS RS ";
        StringBuilder orderBy = new StringBuilder(" ORDER BY ");
        if (ResourceInfoFieldEnum.DISPLAYNAME.name().equalsIgnoreCase(sortField)) {
            orderBy.append(" RS.FDISPLAYNAME ");
        } else {
            orderBy.append(" F" + ResourceInfoFieldEnum.fromPersistence(sortField) + " ");
        }
        if (ResourceSortOrderEnum.ASC.name().equalsIgnoreCase(sortOrder)) {
            orderBy.append(" ASC ");
        } else {
            orderBy.append(" DESC ");
        }
        lastSql.append(limitPage);
        lastSql.append(selectPart);
        lastSql.append(" (");
        lastSql.append(sqlUnion);
        lastSql.append(") ");
        lastSql.append(asRs);
        lastSql.append((CharSequence)orderBy);
        return lastSql.toString();
    }

    private Map<String, Object> getFileUsageInfoByPaging(Integer targetPage, Integer pageSize, String sortField, String sortOrder, String searchText) throws AbstractQingIntegratedException, ResourceManagementException, SQLException {
        Map<ResInfoManagerType, Constructor<? extends IResInfoManagerDomain>> classMap = ResInfoManagerDomainFactory.getResInfoManagerDomainClassMap();
        HashMap<ResInfoManagerType, IResInfoManagerDomain> instanceMap = new HashMap<ResInfoManagerType, IResInfoManagerDomain>(3);
        ArrayList<String> sqlList = new ArrayList<String>();
        ArrayList<String> searchTextList = new ArrayList<String>();
        for (ResInfoManagerType type : classMap.keySet()) {
            IResInfoManagerDomain infoDomain = ResInfoManagerDomainFactory.createResInfoManagerDomain(this.resourceManager.getQingContext(), this.resourceManager.getDBExcuter(), this.resourceManager.getTx(), type);
            ArrayList<String> sqls = new ArrayList<String>();
            ArrayList<String> searchKeys = new ArrayList<String>();
            infoDomain.buildFileUsageQuerySQL(searchText, sqls, searchKeys);
            sqlList.addAll(sqls);
            searchTextList.addAll(searchKeys);
            instanceMap.put(type, infoDomain);
        }
        Integer totalRow = this.resourceInfoDao.getFileResourceCount(this.qingContext.getUserId(), searchText);
        String unionSql = this.unionSql(sqlList);
        PaginationRequestData paginationData = PaginationUtil.getCorrectRequestData(totalRow, targetPage, pageSize);
        String sqlLast = this.generateFileTypeResourceQuerySql(unionSql, sortField, sortOrder, paginationData.getOffSet(), paginationData.getPageSize());
        List<FileResourceVO> list = this.resourceInfoDao.findFileResourceInfoByUserId(sqlLast, searchTextList.toArray());
        for (FileResourceVO fileResourceVO : list) {
            String type = fileResourceVO.getFromType();
            IResInfoManagerDomain concatInfoHandler = this.getConcatInfoHandler(instanceMap, ResourceFromType.valueOf(type));
            concatInfoHandler.handleConcatInfo(fileResourceVO);
            long fileSize = Long.parseLong(fileResourceVO.getFileSizeNoFormat());
            fileResourceVO.setFileSize(this.convertUnit(fileSize));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("totalRow", paginationData.getTotalRow());
        map.put("targetPage", paginationData.getTargetPage());
        map.put("pageSize", paginationData.getPageSize());
        map.put("infos", list);
        return map;
    }

    private String convertUnit(long fileSize) {
        if (fileSize <= 0x100000L) {
            BigDecimal bigDecimal = new BigDecimal(fileSize).divide(new BigDecimal(1024), 2, RoundingMode.HALF_UP);
            return bigDecimal + "KB";
        }
        BigDecimal bigDecimal = new BigDecimal(fileSize).divide(new BigDecimal(0x100000), 2, RoundingMode.HALF_UP);
        return bigDecimal + "MB";
    }

    private IResInfoManagerDomain getConcatInfoHandler(Map<ResInfoManagerType, IResInfoManagerDomain> mapping, ResourceFromType resourceFromType) {
        switch (resourceFromType) {
            case IMAGELIBRARY: {
                return mapping.get((Object)ResInfoManagerType.IMAGE_LIBRARY);
            }
            case THEME: 
            case THEMESOURCECONVERT: 
            case THEMESCHEDULE: {
                return mapping.get((Object)ResInfoManagerType.THEME);
            }
            case PUBLISHED: 
            case CARDTHUMBNAIL: 
            case TIMINGPUSH: {
                return mapping.get((Object)ResInfoManagerType.PUBLISH);
            }
            case FONTLIBRARY: {
                return mapping.get((Object)ResInfoManagerType.FONT_LIB);
            }
        }
        LogUtil.warn("\u8d44\u6e90\u9650\u989d\u89e3\u6790\u8def\u5f84\u5f02\u5e38\uff0c\u672a\u53d1\u73b0\u53ef\u7528\u89e3\u6790\u5668\uff1a" + resourceFromType.name());
        throw new RuntimeException();
    }

    private Map<String, Object> getTodayScheduleInfoByPaging(Integer targetPage, Integer pageSize, String sortField, String sortOrder) throws AbstractQingIntegratedException, ResourceManagementException, SQLException {
        Map<ResInfoManagerType, Constructor<? extends IResInfoManagerDomain>> classMap = ResInfoManagerDomainFactory.getResInfoManagerDomainClassMap();
        ArrayList<ScheduleExecuteVO> list = new ArrayList();
        ArrayList<String> sqlList = new ArrayList<String>();
        ArrayList<Date> dateList = new ArrayList<Date>();
        for (ResInfoManagerType type : classMap.keySet()) {
            IResInfoManagerDomain infoDomain = ResInfoManagerDomainFactory.createResInfoManagerDomain(this.resourceManager.getQingContext(), this.resourceManager.getDBExcuter(), this.resourceManager.getTx(), type);
            ArrayList<String> sqls = new ArrayList<String>();
            ArrayList<Date> dates = new ArrayList<Date>();
            infoDomain.buildScheduleRecordQuerySQL(sqls, dates);
            sqlList.addAll(sqls);
            dateList.addAll(dates);
        }
        String unionSql = this.unionSql(sqlList);
        Integer totalRow = this.resourceInfoDao.getScheduleResourceCount(this.qingContext.getUserId());
        PaginationRequestData paginationData = PaginationUtil.getCorrectRequestData(totalRow, targetPage, pageSize);
        String lastSql = this.generateScheduleTypeResourceQuerySql(unionSql, sortField, sortOrder, paginationData.getOffSet(), paginationData.getPageSize());
        list = this.resourceInfoDao.findScheduleResourceInfoByUserId(lastSql, dateList.toArray());
        this.handleScheduleExecuteVOField(list);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("infos", list);
        map.put("totalRow", paginationData.getTotalRow());
        map.put("targetPage", paginationData.getTargetPage());
        map.put("pageSize", paginationData.getPageSize());
        return map;
    }

    public Map<String, Object> getAllScheduleTypeResourceInfoList(Integer targetPage, Integer pageSize, String sortField, String sortOrder, QueryResourceVo queryResourceVo) throws AbstractQingIntegratedException, ResourceManagementException, SQLException {
        Map<ResInfoManagerType, Constructor<? extends IResInfoManagerDomain>> classMap = ResInfoManagerDomainFactory.getResInfoManagerDomainClassMap();
        ArrayList<ScheduleExecuteVO> list = new ArrayList(16);
        ArrayList<String> sqlList = new ArrayList<String>(16);
        ArrayList<Object> paramList = new ArrayList<Object>(16);
        for (ResInfoManagerType type : classMap.keySet()) {
            IResInfoManagerDomain infoDomain = ResInfoManagerDomainFactory.createResInfoManagerDomain(this.resourceManager.getQingContext(), this.resourceManager.getDBExcuter(), this.resourceManager.getTx(), type);
            ArrayList<String> sqls = new ArrayList<String>();
            ArrayList<Object> params = new ArrayList<Object>();
            infoDomain.processAllScheduleExecuteListQuerySQL(sqls, params, queryResourceVo.getSearchText(), queryResourceVo.getCurrentStatus(), queryResourceVo.getCurrentScheduleType(), queryResourceVo.getStartDateTimeStamp(), queryResourceVo.getEndDateTimeStamp());
            sqlList.addAll(sqls);
            paramList.addAll(params);
        }
        String unionSql = this.unionSql(sqlList);
        Integer totalRow = this.resourceInfoDao.getAllScheduleResourceCount(this.qingContext.getUserId(), queryResourceVo.getSearchText(), queryResourceVo.getCurrentStatus(), queryResourceVo.getCurrentScheduleType(), queryResourceVo.getStartDateTimeStamp(), queryResourceVo.getEndDateTimeStamp());
        PaginationRequestData paginationData = PaginationUtil.getCorrectRequestData(totalRow, targetPage, pageSize);
        String lastSql = this.generateScheduleTypeResourceQuerySql(unionSql, sortField, sortOrder, paginationData.getOffSet(), paginationData.getPageSize());
        list = this.resourceInfoDao.findScheduleResourceInfoByUserId(lastSql, paramList.toArray());
        this.handleScheduleExecuteVOField(list);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("infos", list);
        map.put("totalRow", paginationData.getTotalRow());
        map.put("targetPage", paginationData.getTargetPage());
        map.put("pageSize", paginationData.getPageSize());
        return map;
    }

    private void handleScheduleExecuteVOField(List<ScheduleExecuteVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (ScheduleExecuteVO scheduleExecuteVO : list) {
            if (!"updateLappThumbnail".equals(scheduleExecuteVO.getMethodName())) continue;
            String sourceName = scheduleExecuteVO.getSourceName();
            if (sourceName.length() > 36) {
                sourceName = sourceName.substring(0, sourceName.length() - 36);
            }
            scheduleExecuteVO.setSourceName(sourceName);
        }
    }

    private String generateScheduleTypeResourceQuerySql(String sqlUnion, String sortField, String sortOrder, Integer offset, Integer pageSize) {
        if (StringUtils.isBlank(sortField)) {
            sortField = "executeTime";
        }
        if (StringUtils.isBlank(sortOrder)) {
            sortOrder = "desc";
        }
        StringBuilder lastSql = new StringBuilder();
        String asRs = " AS RS ";
        StringBuilder orderPart = new StringBuilder(" ORDER BY ");
        String limitPagePart = "SELECT TOP " + pageSize + "," + offset + " ";
        String selectPart = " RS.FID, RS.FUSERID, RS.FSCHEDULENAME, RS.FSOURCEID, RS.FSOURCENAME, RS.FEXECUTESTATE, RS.FEXECUTETIME, RS.FENDTIME, RS.FMETHODNAME, RS.SCHEDULEOPERATION FROM ";
        orderPart.append(" F").append(ResourceInfoFieldEnum.fromPersistence(sortField)).append(" ");
        if (ResourceSortOrderEnum.ASC.name().equals(sortOrder)) {
            orderPart.append(ResourceSortOrderEnum.ASC.name()).append(" ");
        } else {
            orderPart.append(ResourceSortOrderEnum.DESC.name()).append(" ");
        }
        lastSql.append(limitPagePart);
        lastSql.append(selectPart);
        lastSql.append(" ( ");
        lastSql.append(sqlUnion);
        lastSql.append(")");
        lastSql.append(asRs);
        lastSql.append((CharSequence)orderPart);
        return lastSql.toString();
    }

    private String byteToMBStr(BigDecimal bigDecimalByte) {
        BigDecimal bigDecimal = bigDecimalByte.divide(new BigDecimal(0x100000), 2, 4);
        return bigDecimal.toString();
    }

    private String byteToIntMBStr(BigDecimal bigDecimalByte) {
        return String.valueOf(bigDecimalByte.divide(new BigDecimal(0x100000), 0, 4).intValue());
    }

    private double percentToDouble(int dividend, int divisor) {
        if (divisor == 0) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(dividend).divide(new BigDecimal(divisor), 2, 4);
        return bigDecimal.doubleValue();
    }

    public boolean hasResourceManager() {
        return this.resourceManager.hasResourceManager();
    }

    public int getLicenseStorageSize() throws AbstractQingIntegratedException, SQLException {
        return this.resourceManager.getLicenseStorageSize();
    }
}

