/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url) {
        String charset = "UTF-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        String result = null;
        try {
            HttpEntity resEntity;
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception e) {
            LogUtil.error("error in doPost, map: ", e);
        }
        finally {
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> headers, String bodyJson) {
        HttpClient httpclient = HttpUtil.createIgnoreSSLHttpClient();
        try {
            HttpPost httppost = new HttpPost(url);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httppost.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            try {
                if (bodyJson != null && bodyJson != "") {
                    StringEntity stringEntity = new StringEntity(bodyJson, "Utf-8");
                    stringEntity.setContentType("application/json");
                    httppost.setEntity((HttpEntity)stringEntity);
                }
                HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                HttpEntity resEntity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)resEntity);
                EntityUtils.consume((HttpEntity)resEntity);
                String string = result;
                return string;
            }
            catch (IOException e) {
                LogUtil.error("postByJson() occours an exception!", e);
                httpclient.getConnectionManager().shutdown();
            }
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postByForm(String url, Map<String, String> headers, Map<String, String> formParams) {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        try {
            HttpPost httppost = new HttpPost(url);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httppost.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            try {
                if (formParams != null && !formParams.isEmpty()) {
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry<String, String> entry : formParams.entrySet()) {
                        params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                    }
                    UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
                    urlEncodedFormEntity.setContentType("application/x-www-form-urlencoded");
                    httppost.setEntity((HttpEntity)urlEncodedFormEntity);
                }
                HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                HttpEntity httpEntity = response.getEntity();
                String string = EntityUtils.toString((HttpEntity)httpEntity);
                EntityUtils.consume((HttpEntity)httpEntity);
                String string2 = string;
                return string2;
            }
            catch (IOException e) {
                LogUtil.error("postByForm() occours an exception!", e);
                httpclient.getConnectionManager().shutdown();
            }
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFile(String url, Map<String, String> headers, InputStream inputStream, String fileName) {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        try {
            HttpPost httppost = new HttpPost(url);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httppost.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            try {
                InputStreamBody bin = new InputStreamBody(inputStream, fileName);
                StringBody comment = new StringBody(fileName, ContentType.TEXT_PLAIN);
                MultipartEntityBuilder reqEntity = MultipartEntityBuilder.create();
                reqEntity.addPart("file1", (ContentBody)bin);
                reqEntity.addPart("filename1", (ContentBody)comment);
                httppost.setEntity(reqEntity.build());
                HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    HttpEntity resEntity = response.getEntity();
                    String result = EntityUtils.toString((HttpEntity)resEntity);
                    EntityUtils.consume((HttpEntity)resEntity);
                    String string = result;
                    return string;
                }
            }
            catch (IOException e) {
                LogUtil.error("postFile() occours an exception!", e);
            }
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }

    public static String getRemoteClientIp(HttpServletRequest request) {
        String ip = request.getHeader("X-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip.contains(",")) {
            return ip.split(",")[0];
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String url, Map<String, String> headers, OutputStream outputStream) {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        try {
            HttpGet httpGet = new HttpGet(url);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpGet.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            try {
                HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    HttpEntity resEntity = response.getEntity();
                    IOUtil.copy(resEntity.getContent(), outputStream);
                    EntityUtils.consume((HttpEntity)resEntity);
                }
            }
            catch (IOException e) {
                LogUtil.error("downloadFile() occours an exception!", e);
            }
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse restfulForEntity(String url, Map<String, String> headers, String bodyJson) {
        block11: {
            HttpClient httpclient = HttpUtil.createIgnoreSSLHttpClient();
            try {
                HttpPost httppost = new HttpPost(url);
                if (headers != null) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        httppost.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
                    }
                }
                try {
                    HttpResponse response;
                    if (bodyJson != null && bodyJson != "") {
                        StringEntity stringEntity = new StringEntity(bodyJson, "Utf-8");
                        stringEntity.setContentType("application/json");
                        httppost.setEntity((HttpEntity)stringEntity);
                    }
                    HttpResponse httpResponse = response = httpclient.execute((HttpUriRequest)httppost);
                    return httpResponse;
                }
                catch (IOException e) {
                    try {
                        LogUtil.error("restfulForEntity occours an IOException!", e);
                    }
                    catch (Exception e2) {
                        LogUtil.error("restfulForEntity occours an exception!", e2);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    httpclient.getConnectionManager().shutdown();
                }
            }
            finally {
                httpclient.getConnectionManager().shutdown();
            }
        }
        return null;
    }

    public static HttpClient createIgnoreSSLHttpClient() {
        HttpRequestRetryHandler myRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                return false;
            }
        };
        SSLContext sslcontext = null;
        try {
            sslcontext = HttpUtil.createIgnoreVerifySSL();
        }
        catch (Exception e) {
            LogUtil.error("createIgnoreVerifySSL error", e);
        }
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        CloseableHttpClient client = HttpClients.custom().setRetryHandler(myRetryHandler).setConnectionManager((HttpClientConnectionManager)connManager).build();
        return client;
    }

    public static SSLContext createIgnoreVerifySSL() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("TLSv1.2");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sc.init(null, new TrustManager[]{trustManager}, null);
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> headers, Map<String, String> paramMap, String bodyJson) {
        block13: {
            HttpClient httpclient = HttpUtil.createIgnoreSSLHttpClient();
            try {
                URIBuilder uriBuilder = new URIBuilder(url);
                if (paramMap != null) {
                    for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                        String key = entry.getKey();
                        String string = entry.getValue();
                        uriBuilder.addParameter(key, string);
                    }
                }
                URI uri = uriBuilder.build();
                HttpGetWithEntity httpGet = new HttpGetWithEntity(uri);
                if (headers != null) {
                    for (Map.Entry entry : headers.entrySet()) {
                        httpGet.setHeader((String)entry.getKey(), String.valueOf(entry.getValue()));
                    }
                }
                try {
                    if (bodyJson != null && bodyJson != "") {
                        StringEntity stringEntity = new StringEntity(bodyJson, "Utf-8");
                        stringEntity.setContentType("application/json");
                        httpGet.setEntity((HttpEntity)stringEntity);
                    }
                    HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                    HttpEntity httpEntity = response.getEntity();
                    String result = EntityUtils.toString((HttpEntity)httpEntity);
                    EntityUtils.consume((HttpEntity)httpEntity);
                    String string = result;
                    return string;
                }
                catch (IOException e) {
                    try {
                        LogUtil.error("get response occours an exception!", e);
                    }
                    catch (URISyntaxException e2) {
                        LogUtil.error("URI builder occours an exception!", e2);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    httpclient.getConnectionManager().shutdown();
                }
            }
            finally {
                httpclient.getConnectionManager().shutdown();
            }
        }
        return null;
    }

    private static class HttpGetWithEntity
    extends HttpEntityEnclosingRequestBase {
        private static final String METHOD_NAME = "GET";

        public String getMethod() {
            return METHOD_NAME;
        }

        public HttpGetWithEntity() {
        }

        public HttpGetWithEntity(URI uri) {
            this.setURI(uri);
        }

        HttpGetWithEntity(String uri) {
            this.setURI(URI.create(uri));
        }
    }
}

