/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class URLUtil {
    public static String appendParamToUrl(String sUrl, String sParamKey, String sParamValue) {
        if (sParamValue != null && !"".equals(sParamValue.trim())) {
            sUrl = sUrl + (sUrl.indexOf("?") < 0 ? "?" : "&");
            sUrl = sUrl + sParamKey;
            sUrl = sUrl + "=";
            try {
                sParamValue = URLEncoder.encode(sParamValue, "utf-8");
                sParamValue = sParamValue.replace("+", "%20");
                sUrl = sUrl + sParamValue;
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.error(e.getMessage(), e);
            }
        }
        return sUrl;
    }

    public static String appendMultipleParamsToUrl(String sUrl, Map<String, String> paramMap) {
        if (paramMap != null && paramMap.size() > 0) {
            sUrl = sUrl + (sUrl.indexOf("?") < 0 ? "?" : "");
            for (Map.Entry<String, String> paramEntry : paramMap.entrySet()) {
                sUrl = URLUtil.appendParamToUrl(sUrl, paramEntry.getKey(), paramEntry.getValue());
            }
        }
        return sUrl;
    }

    public static String getUrlParam(String url, String paramKey) {
        if (StringUtils.isNotBlank(url) && StringUtils.isNotBlank(url = url.substring(url.indexOf("?") + 1))) {
            String[] arrParamPairStr;
            for (String paramPairStr : arrParamPairStr = url.split("[&]")) {
                String[] paramPair = paramPairStr.split("[=]");
                if (paramPair.length <= 1 || !paramKey.equals(paramPair[0])) continue;
                return paramPair[1];
            }
        }
        return null;
    }
}

