/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util.pagination;

import com.kingdee.bos.qing.util.pagination.PaginationRequestData;

public class PaginationUtil {
    public static PaginationRequestData getCorrectRequestData(Integer totalRow, Integer targetPage, Integer pageSize) {
        PaginationRequestData paginationRequestData = new PaginationRequestData();
        if (pageSize == null || pageSize <= 0) {
            return new PaginationRequestData(0, 1, pageSize, 1);
        }
        if (totalRow == null || totalRow <= 0) {
            paginationRequestData.setTotalRow(0);
            paginationRequestData.setTotalPage(1);
            paginationRequestData.setTargetPage(1);
            paginationRequestData.setPageSize(pageSize);
            paginationRequestData.setOffSet(0);
            return paginationRequestData;
        }
        Integer totalPage = (int)Math.ceil(totalRow.floatValue() / pageSize.floatValue());
        if (targetPage < 0) {
            paginationRequestData.setTargetPage(1);
        } else if (targetPage > totalPage) {
            paginationRequestData.setTargetPage(totalPage);
        } else {
            paginationRequestData.setTargetPage(targetPage);
        }
        paginationRequestData.setTotalRow(totalRow);
        paginationRequestData.setPageSize(pageSize);
        paginationRequestData.setTotalPage(totalPage);
        paginationRequestData.setOffSet((targetPage - 1) * pageSize);
        return paginationRequestData;
    }
}

