/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.corelayer.proxy.ProxyFactory;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CtrlDBUtil {
    private static final Logger logger = Logger.getLogger(CtrlDBUtil.class);

    public static ResultSet executeQuerySet(Object ctx, String sql, List params) throws Exception {
        CtrlDBUtil.prepareParams(params);
        return ProxyFactory.createDBProxy(ctx).executeQuery(sql, params, -1, null, false);
    }

    public static ResultSet executeQuerySet(Object ctx, String sql, List params, int start, int rows) throws Exception {
        CtrlDBUtil.prepareParams(params);
        return ProxyFactory.createDBProxy(ctx).executeQuery(sql, params, rows, null, false);
    }

    public static Map<String, Object> callProcedureLocal(Object ctx, String procedureName, int dbType, String resultNumberName, List paramList, int start, int rows, CtrlDesignQueryModel model) throws BOSException {
        KSQLReportInfo info = new KSQLReportInfo();
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        IQuery query = model.getQuery();
        IXmlElement xml = CtrlDesignUtil.toXml(ctx, commonQuery, query);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XmlUtil.saveXmlStream((OutputStream)out, (IXmlElement)xml);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        info.setContent(out.toByteArray());
        info.setCustomType(2);
        info.setObject("queryParams", paramList);
        return ProxyFactory.createDBProxy(ctx).callProcedure(info);
    }

    public static Map<String, Object> callProcedureOutBD(Object ctx, DataCenterInfo vo, String procedureName, int dbType, String resultNumberName, List paramList, int start, int rows, CtrlDesignQueryModel model) throws BOSException {
        KSQLReportInfo info = new KSQLReportInfo();
        if (model != null) {
            ByteArrayOutputStream out = null;
            CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
            IQuery query = model.getQuery();
            IXmlElement xml = CtrlDesignUtil.toXml(ctx, commonQuery, query);
            out = new ByteArrayOutputStream();
            try {
                XmlUtil.saveXmlStream((OutputStream)out, (IXmlElement)xml);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            info.setContent(out.toByteArray());
        }
        info.setCustomType(2);
        info.setObject("queryParams", paramList);
        return ProxyFactory.createDBProxy(ctx).callProcedure(info);
    }

    public static ResultSet executeQuerySet(Object ctx, DataCenterInfo vo, String sql, List params, int start, int rows) throws Exception {
        CtrlDBUtil.prepareParams(params);
        return ProxyFactory.createDBProxy(ctx).executeQuery(sql, params, rows, vo, false);
    }

    public static ResultSet executeQuerySet(Object ctx, DataCenterInfo vo, String sql, List params) throws Exception {
        CtrlDBUtil.prepareParams(params);
        return ProxyFactory.createDBProxy(ctx).executeQuery(sql, params, -1, vo, false);
    }

    private static void prepareParams(List params) {
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                Object obj = params.get(i);
                if (!(obj instanceof Map)) continue;
                Map map = (Map)obj;
                byte[] bContent = (byte[])map.get("Blob");
                params.add(i, bContent);
            }
        }
    }

    public static boolean isDataCenterName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        return name.startsWith("datacenter_");
    }

    public static boolean isSuperQuerySource(String outDB) {
        if (StringUtil.isEmptyString((String)outDB)) {
            return false;
        }
        return outDB.startsWith("sysSuperQuery_") || outDB.startsWith("userSuperQuery_");
    }

    public static boolean isSysSuperQuerySource(String outDB) {
        if (StringUtil.isEmptyString((String)outDB)) {
            return false;
        }
        return outDB.startsWith("sysSuperQuery_");
    }

    public static String getAppNumber(String dataCenterName) {
        if (StringUtils.isEmpty((String)dataCenterName)) {
            throw new IllegalArgumentException("dataCenterName is null.");
        }
        if (!dataCenterName.startsWith("datacenter_")) {
            return dataCenterName;
        }
        return dataCenterName.substring("datacenter_".length());
    }

    public static String getDisSysSuperQueryName(String outName) {
        if (!CtrlDBUtil.isSuperQuerySource(outName)) {
            return outName;
        }
        String sysSuperQuery = outName.substring("sysSuperQuery_".length());
        return sysSuperQuery.trim();
    }

    public static String getDisUserSuperQueryName(String outName) {
        if (!CtrlDBUtil.isSuperQuerySource(outName)) {
            return outName;
        }
        String userSuperQuery = outName.substring("userSuperQuery_".length());
        return userSuperQuery.trim();
    }

    public static String getRealSysSuperQueryName(String outName) {
        return "sysSuperQuery_" + outName;
    }

    public static String getRealUserSuperQueryName(String outName) {
        return "userSuperQuery_" + outName;
    }
}

