/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.data;

import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.bos.framework.core.util.Messages;

public class ReportSnapType {
    public static final int INT_EMPTY = -1;
    public static final int INT_UNKNOW = 0;
    public static final int INT_YEAR = 1;
    public static final int INT_YEARHALF = 2;
    public static final int INT_QUARTER = 3;
    public static final int INT_MONTH = 4;
    public static final int INT_MONTHHALF = 5;
    public static final int INT_WEEK = 6;
    public static final int INT_DAY = 7;
    public static final ReportSnapType EMPTY = new ReportSnapType(-1);
    public static final ReportSnapType UNKNOW = new ReportSnapType(0);
    public static final ReportSnapType YEAR = new ReportSnapType(1);
    public static final ReportSnapType YEARHALF = new ReportSnapType(2);
    public static final ReportSnapType QUARTER = new ReportSnapType(3);
    public static final ReportSnapType MONTH = new ReportSnapType(4);
    public static final ReportSnapType MONTHHALF = new ReportSnapType(5);
    public static final ReportSnapType WEEK = new ReportSnapType(6);
    public static final ReportSnapType DAY = new ReportSnapType(7);
    public static final ReportSnapType[] ReportSnapTypes = new ReportSnapType[]{EMPTY, YEAR, YEARHALF, QUARTER, MONTH, MONTHHALF, WEEK, DAY, UNKNOW};
    private int intValue;

    private ReportSnapType(int i) {
        this.intValue = i;
    }

    public int intValue() {
        return this.intValue;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        switch (this.intValue) {
            case -1: {
                return "";
            }
            case 0: {
                return Messages.getMLS("other", "\u5176\u4ed6");
            }
            case 1: {
                return Messages.getMLS("annualReport", "\u5e74\u62a5");
            }
            case 2: {
                return Messages.getMLS("semiAnnualReport", "\u534a\u5e74\u62a5");
            }
            case 3: {
                return Messages.getMLS("quarterlyReport", "\u5b63\u62a5");
            }
            case 4: {
                return Messages.getMLS("monthlyReport", "\u6708\u62a5");
            }
            case 5: {
                return Messages.getMLS("semiMonthlyReport", "\u534a\u6708\u62a5");
            }
            case 6: {
                return Messages.getMLS("weeklyReport", "\u5468\u62a5");
            }
            case 7: {
                return Messages.getMLS("dailyReport", "\u65e5\u62a5");
            }
        }
        return "";
    }

    public static final ReportSnapType getDataType(int intValue) {
        switch (intValue) {
            case -1: {
                return EMPTY;
            }
            case 0: {
                return UNKNOW;
            }
            case 1: {
                return YEAR;
            }
            case 2: {
                return YEARHALF;
            }
            case 3: {
                return QUARTER;
            }
            case 4: {
                return MONTH;
            }
            case 5: {
                return MONTHHALF;
            }
            case 6: {
                return WEEK;
            }
            case 7: {
                return DAY;
            }
        }
        return EMPTY;
    }

    public static final ReportSnapType getDataType(String strValue) {
        if (StringUtils.isEmpty(strValue)) {
            return EMPTY;
        }
        int intValue = Integer.parseInt(strValue);
        return ReportSnapType.getDataType(intValue);
    }
}

