/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.macro.exec;

import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroType;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroVO;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroValue;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroValueType;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ext.MacroParameterImpl;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtRptContentChecker;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.MacroUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ExtRptMacroExecuteFacade {
    private static Logger logger = Logger.getLogger(ExtRptMacroExecuteFacade.class);
    private static Pattern MACRO_PARAM_PATTERN = Pattern.compile("[$]{1}[a-zA-Z]{1}[a-zA-Z0-9_]+");

    public static ExtMacroValue execute(Object easCtx, String macroUid) throws ExtMacroException {
        if (macroUid == null) {
            throw ExtMacroException.newNonExisitMacroException("");
        }
        ExtMacroValue macroValue = MacroUtil.loadMacroValuesByUid(easCtx, macroUid, -1);
        return macroValue;
    }

    public static IParameter translate(DesignParameter param) {
        String value = param.getCurentValue();
        int dataType = param.getDesignDataType().intValue();
        ParameterImpl p = new ParameterImpl();
        p.setName(param.getName());
        p.setAlias(param.getAlias());
        p.setValue(RunReportParam.getVariant(value, dataType));
        p.setDataType(dataType);
        return p;
    }

    public static HashMap<String, IParameter> fetchMacroParameters(Object easCtx, Book template) throws ExtMacroException {
        return ExtRptMacroExecuteFacade.fetchMacroParameters(easCtx, template, new HashMap());
    }

    public static HashMap<String, IParameter> fetchMacroParameters(Object easCtx, Book template, HashMap mapDesignParams) throws ExtMacroException {
        HashMap<String, IParameter> mapParameterImpl = new HashMap<String, IParameter>();
        HashSet<String> names = new HashSet<String>();
        ExtRptContentChecker.analysisMacroUsage(easCtx, names, mapDesignParams, template);
        if (!names.isEmpty()) {
            ArrayList<ExtMacroValue> macroValueList = new ArrayList<ExtMacroValue>(names.size());
            for (String macroName : names) {
                if (macroName == null || macroName.trim().length() <= 0) continue;
                try {
                    ExtMacroValue macroValue = ExtRptMacroExecuteFacade.execute(easCtx, macroName);
                    if (macroValue.getAllColumnNames() == null) continue;
                    macroValueList.add(macroValue);
                }
                catch (Exception e) {
                    logger.error((Object)"loadMacroError:", (Throwable)e);
                }
            }
            if (macroValueList != null) {
                for (ExtMacroValue macro : macroValueList) {
                    MacroParameterImpl p = new MacroParameterImpl(easCtx);
                    String name = macro.getMacroUid();
                    p.setName(name);
                    p.setAlias(name);
                    p.setDataType(0);
                    mapParameterImpl.put(name + "_temp_macro_param_suffix", (IParameter)p);
                }
            }
        }
        for (Map.Entry<String, ExtMacroVO> entry : ExtRptMacroExecuteFacade.loadUsedMacros(template).entrySet()) {
            MacroParameterImpl p = new MacroParameterImpl(easCtx);
            p.setName(entry.getKey());
            p.setAlias(entry.getKey());
            p.setDataType(0);
            mapParameterImpl.put(entry.getKey() + "_temp_macro_param_suffix", (IParameter)p);
        }
        return mapParameterImpl;
    }

    public static Map<String, ExtMacroVO> loadUsedMacros(Book book) {
        HashMap<String, ExtMacroVO> innerMacroDefineMap = new HashMap<String, ExtMacroVO>();
        if (book == null) {
            return innerMacroDefineMap;
        }
        Object value = book.getUserObjectValue("EXT_REPORT_USED_MACRO_DEFINE");
        try {
            if (value instanceof String) {
                ByteArrayInputStream in = new ByteArrayInputStream(((String)value).getBytes("UTF-8"));
                IXmlElement macros = XmlUtil.loadRootElement((InputStream)in);
                for (Object o : macros.searchChildren("macro")) {
                    if (!(o instanceof IXmlElement)) continue;
                    IXmlElement m = (IXmlElement)o;
                    innerMacroDefineMap.put(m.getAttribute("name").toUpperCase(), new ExtMacroVO(m.getAttribute("name"), m.getChild("description").getText(), ExtMacroType.valueOf(m.getAttribute("mType")), ExtMacroValueType.valueOf(m.getAttribute("vType"))));
                }
            }
        }
        catch (Throwable th) {
            logger.error((Object)th.getMessage());
        }
        return innerMacroDefineMap;
    }

    static HashMap<String, IParameter> translate(HashMap<String, DesignParameter> sysParams) {
        HashMap<String, IParameter> params = new HashMap<String, IParameter>();
        for (Map.Entry<String, DesignParameter> entry : sysParams.entrySet()) {
            params.put(entry.getKey(), ExtRptMacroExecuteFacade.translate(entry.getValue()));
        }
        return params;
    }

    public static String evaluateMacro(Object ctx, String value) {
        String replaceMultipleSelectedValue = value.replaceAll("0xx1xx", "");
        TreeSet<String> names = new TreeSet<String>();
        ExtRptMacroExecuteFacade.analysisParamMacroUsage(names, replaceMultipleSelectedValue);
        if (!names.isEmpty()) {
            for (String macroUid : names) {
                if (macroUid == null || macroUid.trim().equals("")) continue;
                try {
                    List<List<Object>> allColumnMacroValues;
                    ExtMacroValue mv = ExtRptMacroExecuteFacade.execute(ctx, macroUid);
                    if (mv == null || mv.getAllColumnNames() == null || mv.getAllColumnValues() == null || null == (allColumnMacroValues = mv.getAllColumnValues()) || allColumnMacroValues.isEmpty()) continue;
                    StringBuilder replacement = new StringBuilder();
                    int index = 0;
                    for (Object columnMacroValue : allColumnMacroValues.get(0)) {
                        if (index != 0) {
                            replacement.append("0xx1xx");
                        }
                        replacement.append(columnMacroValue);
                        ++index;
                    }
                    while (value.indexOf("$" + macroUid) > -1) {
                        value = value.replace("$" + macroUid, replacement.toString().trim());
                    }
                }
                catch (ExtMacroException e) {
                    logger.error((Object)e.getErrorMessage(), (Throwable)e);
                    throw new RuntimeException(e.getErrorMessage(), e);
                }
            }
        }
        return value;
    }

    public static void analysisParamMacroUsage(Set<String> names, String value) {
        if (value == null) {
            return;
        }
        ExtRptMacroExecuteFacade.checkAndFill(names, value);
    }

    private static void checkAndFill(Set<String> names, String content) {
        if (content == null) {
            return;
        }
        Matcher m = MACRO_PARAM_PATTERN.matcher(content);
        while (m.find()) {
            names.add(m.group().substring(1));
        }
    }
}

