/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.model;

import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtStringUtil;
import com.kingdee.cosmic.ctrl.common.DataType;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import java.awt.Component;
import java.awt.Window;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CtrlReportUtil {
    private static final Logger log = LogUtil.getLogger(CtrlReportUtil.class);
    public static final ThreadLocal<DateFormat> sdf_yyyy_MM_dd_HH_mm_ss = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        }
    };
    public static final ThreadLocal<DateFormat> sdf_yyyy_MM_dd = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(CtrlReportUtil.sstr_yyyy_MM_dd);
        }
    };
    public static final ThreadLocal<DateFormat> sdfDateTime = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    public static final ThreadLocal<DateFormat> sdfTime = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss");
        }
    };
    private static final String sstr_yyyy_MM_dd_HH_mm_ss_S = "yyyy-MM-dd HH:mm:ss.S";
    private static final String sstr_yyyy_MM_dd_HH_mm = "yyyy-MM-dd HH:mm";
    private static final String sstr_yyyy_MM_dd = "yyyy-MM-dd";
    public static final String strNull = "null";
    public static final String empty = "";

    private CtrlReportUtil() {
    }

    public static final String getObjectString(Object obj) {
        if (obj == null) {
            return empty;
        }
        String str = String.valueOf(obj).trim();
        if (str.equalsIgnoreCase(strNull) || str.length() == 0) {
            str = empty;
        }
        return str;
    }

    public static String getDataSetType(String strValue) {
        if (String.valueOf(9).equals(strValue)) {
            return "9";
        }
        return "2";
    }

    public static final String getToDay() {
        return sdf_yyyy_MM_dd_HH_mm_ss.get().format(new Date());
    }

    public static final String getDateFromTimestamp(Timestamp ts) {
        Date date = new Date(ts.getTime());
        return sdf_yyyy_MM_dd_HH_mm_ss.get().format(date);
    }

    public static final String formatDate(String in, String out, String date) {
        String strResult = empty;
        if (date != null && !date.replaceAll(strNull, empty).equals(empty)) {
            SimpleDateFormat sdfIn = new SimpleDateFormat(in);
            SimpleDateFormat sdfOut = new SimpleDateFormat(out);
            Date dat = null;
            try {
                dat = sdfIn.parse(date);
            }
            catch (ParseException e) {
                throw new RuntimeException("Unable to parse date format:" + in, e);
            }
            strResult = sdfOut.format(dat);
        }
        return strResult;
    }

    public static final boolean isDate(String date) {
        boolean flag = false;
        if (!CtrlReportUtil.getObjectString(date).equals(empty)) {
            try {
                sdf_yyyy_MM_dd.get().parse(date);
                flag = true;
            }
            catch (ParseException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return flag;
    }

    public static final String formatDateTime(String date) {
        return CtrlReportUtil.formatDate(sstr_yyyy_MM_dd_HH_mm_ss_S, "yyyy-MM-dd HH:mm:ss", date);
    }

    public static final String formatDateTimeHHmm(String date) {
        return CtrlReportUtil.formatDate(sstr_yyyy_MM_dd_HH_mm_ss_S, sstr_yyyy_MM_dd_HH_mm, date);
    }

    public static final String formatDateYMD(String date) {
        return CtrlReportUtil.formatDate(sstr_yyyy_MM_dd_HH_mm_ss_S, sstr_yyyy_MM_dd, date);
    }

    public static final String formatDateTimeByStr(String date) {
        return CtrlReportUtil.formatDate(sstr_yyyy_MM_dd, sstr_yyyy_MM_dd, date);
    }

    public static final String formatDateTime(Date date) {
        return sdfDateTime.get().format(date);
    }

    public static final String formatTime(Date date) {
        return sdfTime.get().format(date);
    }

    public static final String formatDate(Date date) {
        return sdf_yyyy_MM_dd.get().format(date);
    }

    public static final long getDateLong(String str) throws ParseException {
        Date date = sdfDateTime.get().parse(str);
        return date.getTime();
    }

    public static final long getTimeLong(String str) throws ParseException {
        Date date = sdfTime.get().parse(str);
        return date.getTime();
    }

    public static final Date getStringDate(String str) throws ParseException {
        Date date = sdf_yyyy_MM_dd.get().parse(str);
        return date;
    }

    public static final Date getStringDateTime(String str) throws ParseException {
        Date date = sdfDateTime.get().parse(str);
        return date;
    }

    public static final String bosToEasLang(String lstring) {
        String currentName = empty;
        if (lstring.equalsIgnoreCase("l1")) {
            currentName = "en_US";
        } else if (lstring.equalsIgnoreCase("l2")) {
            currentName = "zh_CN";
        } else if (lstring.equalsIgnoreCase("l3")) {
            currentName = "zh_TW";
        }
        return currentName;
    }

    public static final String easToBasLang(String estring) {
        String currentName = empty;
        if (estring.equalsIgnoreCase("en") || estring.equalsIgnoreCase("en_US")) {
            currentName = "l1";
        } else if (estring.equalsIgnoreCase("zh_CN")) {
            currentName = "l2";
        } else if (estring.equalsIgnoreCase("zh_TW")) {
            currentName = "l3";
        }
        return currentName;
    }

    public static final List<Object> getMultiLangInsertParams(HashMap<?, ?> mapMultiLang) {
        ArrayList<Object> lst = new ArrayList<Object>(10);
        ArrayList queryValue = new ArrayList(10);
        StringBuilder sb = new StringBuilder();
        StringBuilder sbsign = new StringBuilder();
        Iterator<?> it = mapMultiLang.keySet().iterator();
        while (it.hasNext()) {
            String strNext = it.next().toString();
            sb.append(strNext).append(", ");
            sbsign.append("?, ");
            queryValue.add(mapMultiLang.get(strNext));
        }
        String insertSQL = sb.substring(0, sb.toString().length() - 2);
        String sign = sbsign.substring(0, sbsign.toString().length() - 2);
        lst.add(insertSQL);
        lst.add(sign);
        lst.add(queryValue);
        return lst;
    }

    public static final String getMultiLangUpdateSql(HashMap<?, ?> mapMultiLang) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = mapMultiLang.keySet().iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append(" = ?, ");
        }
        return sb.substring(0, sb.toString().length() - 2);
    }

    public static final int javaType2DbType(String str) {
        int ret = 0;
        if (str.equalsIgnoreCase("NUMERIC") || str.equalsIgnoreCase("DECIMAL")) {
            return 2;
        }
        if (str.equalsIgnoreCase("DATE") || str.equalsIgnoreCase("TIME") || str.equalsIgnoreCase("DATETIME") || str.equalsIgnoreCase("TIMESTAMP")) {
            return 91;
        }
        if (str.equalsIgnoreCase("BOOLEAN")) {
            return 16;
        }
        if (str.equalsIgnoreCase("FLOAT") || str.equalsIgnoreCase("REAL") || str.equalsIgnoreCase("DOUBLE")) {
            return 8;
        }
        if (str.equalsIgnoreCase("INT") || str.equalsIgnoreCase("INTEGER") || str.equalsIgnoreCase("TINYINT") || str.equalsIgnoreCase("SMALLINT") || str.equalsIgnoreCase("NUMBER")) {
            return 4;
        }
        if (str.equalsIgnoreCase("BIGINT")) {
            return -5;
        }
        if (str.equalsIgnoreCase("STRING") || str.equalsIgnoreCase("CHAR")) {
            return 12;
        }
        return ret;
    }

    public static final int toExtColumnType(DataType datatype) {
        switch (datatype.intValue()) {
            case 0: {
                return 16;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case 6: 
            case 7: {
                return 8;
            }
            case 8: {
                return 12;
            }
            case 9: {
                return 91;
            }
        }
        return 0;
    }

    public static final long getSystemTime() {
        return System.currentTimeMillis();
    }

    public static final void closeWin(Component ui) {
        Window parent = SwingUtilities.getWindowAncestor(ui);
        parent.setVisible(false);
        parent.dispose();
    }

    public static final String trimStr(String str) {
        str = str.trim();
        while (str.indexOf("  ") != -1) {
            str = ExtStringUtil.replace(str, "  ", " ");
        }
        return str;
    }

    public static final String removeSpace(String str) {
        str = str.trim();
        while (str.indexOf(" ") != -1) {
            str = ExtStringUtil.replace(str, " ", empty);
        }
        return str;
    }

    public static final String strFilterSQL(String str) {
        if (str != null) {
            // empty if block
        }
        return str;
    }

    public static final String artToExart(String str) {
        if (str != null && str.indexOf("@") != -1) {
            Pattern p = Pattern.compile("@");
            Matcher m = p.matcher(str);
            str = m.replaceAll("2xx3xx");
        }
        return str;
    }

    public static final String exartToArt(String str) {
        if (str != null && str.indexOf("2xx3xx") != -1) {
            Pattern p = Pattern.compile("2xx3xx");
            Matcher m = p.matcher(str);
            str = m.replaceAll("@");
        }
        return str;
    }
}

