/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.model;

import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignDataType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.SqlWhereParser;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.data.engine.NotFoundVarException;
import com.kingdee.cosmic.ctrl.data.invoke.IEnvProvider;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlInListExpr;
import org.apache.log4j.Logger;

public class BindParam {
    private static final Logger log = LogUtil.getPackageLogger(BindParam.class);
    private static final String PATTERN_PARAM_STR = "@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*";
    private static final String PATTERN_ENV_STR = "@@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*";
    public static final Pattern PARAM = Pattern.compile("@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*", 32);
    public static final Pattern ENV = Pattern.compile("@@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*", 32);
    private static final String PATTERN_SIMPLE_PARAM_STR = "@\\w+";
    private static final String PATTERN_SIMPLE_ENV_STR = "@@\\w+";
    public static final Pattern SIMPLE_PARAM = Pattern.compile("@\\w+", 32);
    public static final Pattern SIMPLE_ENV = Pattern.compile("@@\\w+", 32);

    public static final String replaceVariants(String expr, Map params, boolean simpleStyle) throws NotFoundVarException {
        return BindParam.replaceVariants(expr, params, null, simpleStyle, true);
    }

    public static final String replaceVariants(String expr, Map params, IEnvProvider envProvider, boolean simpleStyle, boolean param) throws NotFoundVarException {
        Matcher mch = null;
        mch = simpleStyle ? SIMPLE_PARAM.matcher(expr) : PARAM.matcher(expr);
        StringBuilder sb1 = new StringBuilder();
        int j = 0;
        while (mch.find()) {
            int i = mch.start();
            sb1.append(expr.substring(j, i));
            j = mch.end();
            String token = expr.substring(i, j);
            int index = token.lastIndexOf(64);
            String realName = token.substring(index + 1);
            String solveResult = BindParam.getVar(params, envProvider, realName, param);
            if (solveResult == null) {
                throw new NotFoundVarException(realName, param);
            }
            sb1.append(solveResult);
        }
        sb1.append(expr.substring(j));
        return sb1.toString();
    }

    public static final String replaceVariantEXKSQL(SqlExpr sqlExpr, String expr, Map params, boolean simpleStyle, Map mapDesignParam, int dbType) throws NotFoundVarException {
        Matcher mch = null;
        mch = simpleStyle ? SIMPLE_PARAM.matcher(expr) : PARAM.matcher(expr);
        StringBuilder sb1 = new StringBuilder();
        int j = 0;
        String realName = null;
        boolean isEmpty = false;
        boolean isIgnoreEmpty = true;
        while (mch.find()) {
            int i = mch.start();
            sb1.append(expr.substring(j, i));
            j = mch.end();
            String token = expr.substring(i, j);
            int index = token.lastIndexOf(64);
            realName = token.substring(index + 1);
            String solveResult = BindParam.getVar(params, null, realName, true);
            solveResult = CtrlReportUtil.getObjectString(solveResult);
            if (StringUtils.isEmpty(solveResult)) {
                DesignParameter dp = (DesignParameter)((Object)mapDesignParam.get(realName));
                if (dp != null) {
                    isIgnoreEmpty = dp.isIgnoreNull();
                    if (DesignDataType.TXT.intValue() != dp.getDesignDataType().intValue()) {
                        solveResult = "null";
                    }
                }
                if (!isIgnoreEmpty) {
                    isEmpty = true;
                } else {
                    throw new NotFoundVarException(realName, true);
                }
            }
            sb1.append(solveResult);
        }
        sb1.append(expr.substring(j));
        if (isEmpty) {
            BindParam.handleParamEmpty(sqlExpr, sb1, expr, realName, dbType);
        }
        return sb1.toString().replace("'null'", "null");
    }

    private static void handleParamEmpty(SqlExpr sqlExpr, StringBuilder sb1, String expr, String realName, int dbType) throws NotFoundVarException {
        if (sqlExpr instanceof SqlBinaryOpExpr) {
            switch (((SqlBinaryOpExpr)sqlExpr).operator) {
                case 12: {
                    if (3 == dbType) {
                        throw new NotFoundVarException(realName, true);
                    }
                    if (expr.indexOf("'") > 0) {
                        BindParam.addIsNull(sb1, ((SqlBinaryOpExpr)sqlExpr).left);
                        break;
                    }
                    BindParam.replaceByIsOrNotNull(sb1, ((SqlBinaryOpExpr)sqlExpr).left + " is null");
                    break;
                }
                case 15: {
                    if (3 != dbType) {
                        throw new NotFoundVarException(realName, true);
                    }
                    if (expr.indexOf("'") > 0) {
                        BindParam.addIsNull(sb1, ((SqlBinaryOpExpr)sqlExpr).left);
                        break;
                    }
                    BindParam.replaceByIsOrNotNull(sb1, ((SqlBinaryOpExpr)sqlExpr).left + " is null");
                    break;
                }
                case 10: {
                    if (expr.indexOf("'") > 0) {
                        BindParam.addIsNull(sb1, ((SqlBinaryOpExpr)sqlExpr).left);
                        break;
                    }
                    BindParam.replaceByIsOrNotNull(sb1, ((SqlBinaryOpExpr)sqlExpr).left + " is null");
                    break;
                }
                case 16: {
                    if (3 == dbType && expr.indexOf("'") >= 0) break;
                    BindParam.replaceByIsOrNotNull(sb1, ((SqlBinaryOpExpr)sqlExpr).left + " is not null");
                    break;
                }
                case 18: {
                    if (!((SqlBinaryOpExpr)sqlExpr).right.toString().equals("@" + realName)) break;
                    BindParam.addIsNull(sb1, ((SqlBinaryOpExpr)sqlExpr).left);
                    break;
                }
                case 40: {
                    if (3 == dbType || !((SqlBinaryOpExpr)sqlExpr).right.toString().equals("@" + realName)) break;
                    BindParam.replaceByIsOrNotNull(sb1, ((SqlBinaryOpExpr)sqlExpr).left + " is not null");
                    break;
                }
                case 13: {
                    BindParam.replaceByIsOrNotNull(sb1, ((SqlBinaryOpExpr)sqlExpr).left + " is null");
                    break;
                }
                case 41: {
                    BindParam.replaceByIsOrNotNull(sb1, ((SqlBinaryOpExpr)sqlExpr).left + " is not null");
                }
            }
        } else if (sqlExpr instanceof SqlInListExpr) {
            if (!((SqlInListExpr)sqlExpr).not) {
                if (expr.indexOf("'") > 0) {
                    BindParam.addIsNull(sb1, ((SqlInListExpr)sqlExpr).expr);
                } else {
                    BindParam.replaceByIsOrNotNull(sb1, ((SqlInListExpr)sqlExpr).expr + " is null");
                }
            } else if (3 != dbType || expr.indexOf("'") < 0) {
                BindParam.replaceByIsOrNotNull(sb1, ((SqlInListExpr)sqlExpr).expr + " is not null");
            }
        }
        log.error((Object)(Messages.getMLS("sqlUsingNullFilter", "\u4f7f\u7528\u7a7a\u503c\u8fc7\u6ee4\u7684SQL:") + sb1));
    }

    private static void addIsNull(StringBuilder sb1, SqlExpr expr) {
        String strIsNull = " or " + expr + " is null";
        if (sb1.charAt(0) == '(') {
            int offset = sb1.lastIndexOf(")");
            if (offset > 0) {
                sb1.insert(offset, strIsNull);
            }
        } else {
            sb1.append(strIsNull);
        }
    }

    private static void replaceByIsOrNotNull(StringBuilder sb1, String isOrNotNull) {
        if (sb1.charAt(0) == '(') {
            sb1.replace(1, sb1.length() - 1, isOrNotNull);
        } else {
            sb1.replace(0, sb1.length(), isOrNotNull);
        }
    }

    public static final String replaceVariantDialect(String sql, Map mapDesignParam, int DBType, Map warnMap, boolean isRun) throws CtrlReportException {
        StringBuilder logParamSystem = new StringBuilder();
        StringBuilder logParamCustom = new StringBuilder();
        Iterator it = mapDesignParam.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
            if (name.startsWith("Ext")) {
                logParamSystem.append(Messages.getMLS("builtInParameter", "\u5185\u7f6e\u53c2\u6570:"));
                logParamSystem.append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
                continue;
            }
            logParamSystem.append(Messages.getMLS("customizedParameter", "\u5b9a\u5236\u53c2\u6570:"));
            logParamCustom.append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
        }
        StringBuilder logParam = new StringBuilder();
        logParam.append("\r\n").append((CharSequence)logParamCustom).append((CharSequence)logParamSystem);
        if (log.isDebugEnabled()) {
            log.debug((Object)("source:" + sql));
            String paramLog = logParam.toString();
            log.debug((Object)paramLog);
        }
        MiscUtil.log((int)4, (String)logParam.toString());
        try {
            sql = SqlWhereParser.parseDialectDateTime(sql, mapDesignParam, 0, DBType);
            while (sql.indexOf(64) != -1) {
                sql = SqlWhereParser.parseDialect(sql, mapDesignParam, warnMap, isRun, DBType);
            }
            sql = CtrlReportUtil.exartToArt(sql);
            log.debug((Object)("sql:" + sql));
            return sql;
        }
        catch (CtrlReportException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw CtrlReportException.makeException(Messages.getMLS("decompose1Error", "\u5206\u89e3#1\u9519\u8bef").replace("#1", "Dialect SQL"), e);
        }
    }

    public static final String replaceVariants2(String expr, Map params, boolean simpleStyle) {
        return BindParam.replaceVariants2(expr, params, null, simpleStyle, true);
    }

    public static final String replaceVariants2(String expr, Map params, IEnvProvider envProvider, boolean simpleStyle, boolean param) {
        Matcher mch = null;
        mch = simpleStyle ? SIMPLE_PARAM.matcher(expr) : PARAM.matcher(expr);
        StringBuilder sb1 = new StringBuilder();
        int j = 0;
        while (mch.find()) {
            int i = mch.start();
            sb1.append(expr.substring(j, i));
            j = mch.end();
            String token = expr.substring(i, j);
            int index = token.lastIndexOf(64);
            String realName = token.substring(index + 1);
            String solveResult = BindParam.getVar(params, envProvider, realName, param);
            if (solveResult == null) {
                solveResult = "";
            }
            sb1.append(solveResult);
        }
        sb1.append(expr.substring(j));
        return sb1.toString();
    }

    private static final String getVar(Map params, IEnvProvider envProvider, String name, boolean param) {
        Object objVal = null;
        if (param) {
            if (params == null) {
                return null;
            }
            objVal = params.get(name);
            if (objVal instanceof String && objVal.toString().contains("0xx1xx") && ((String)(objVal = objVal.toString().replace("0xx1xx", ","))).endsWith(",")) {
                objVal = objVal + "\"\"";
            }
        } else {
            if (envProvider == null) {
                return null;
            }
            objVal = envProvider.get(name);
        }
        return objVal == null ? null : objVal.toString();
    }
}

