/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.boslayer.eas.framework.report.util.RptParams;
import com.kingdee.bos.datawizard.edd.ctrlreport.app.CtrlDBUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtRptContentChecker;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtStringUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignDataType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InOutputParamVO;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InputType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.JavaModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.OQLModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureDataType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureParamData;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.SuperQueryNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.BindParam;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlSolver;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.SqlWhereParser;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.param.IJavaDataSet;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.bos.report.filter.parameter.data.Entry;
import com.kingdee.cosmic.ctrl.common.datacenter.DataCenterDBType;
import com.kingdee.cosmic.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import java.awt.Window;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.util.StringUtil;
import org.apache.log4j.Logger;

public class CtrlDesignDataExecutor {
    private static final Logger log = LogUtil.getPackageLogger(CtrlDesignDataExecutor.class);
    private static Pattern outDBLinkPattern = Pattern.compile("[a-z0-9_]+@[a-z0-9_]+", 2);
    public static final String REMARK_REG = "(?ms)('(?:''|[^']*)')|--[^\r\n]*|/\\*.*?\\*/|#[^\r\n]*";

    public static ResultSet previewTitle(Object ctx, CtrlDesignQueryModel model, Map<String, DesignParameter> mapDesignParam, Map<String, String> logMap) throws Exception {
        Map mapResult = CtrlDesignDataExecutor.execute(ctx, model, mapDesignParam, logMap, 0, 0, false, null, true);
        return (ResultSet)mapResult.get("6xx8xxRowset");
    }

    public static Map execute(Object ctx, CtrlDesignQueryModel model, Map<String, DesignParameter> mapDesignParam, Map<String, String> logMap, int start, int rows, boolean isRun, Window parent) throws Exception {
        return CtrlDesignDataExecutor.execute(ctx, model, mapDesignParam, logMap, start, rows, isRun, parent, false);
    }

    private static String buildOql(Object ctx, CtrlDesignQueryModel model, Map<String, DesignParameter> mapDesignParam, Map<String, String> logMap, int start, int rows, boolean isRun, Window parent, boolean forTitle) throws CtrlReportException {
        String realName;
        OQLModel oqlModel = model.getOqlModel();
        String oql = oqlModel.getContent();
        if ((oql = oql.trim()).endsWith(";")) {
            oql = oql.substring(0, oql.length() - 1);
        }
        if (oql.length() > 0) {
            Pattern p = Pattern.compile(REMARK_REG);
            oql = p.matcher(oql).replaceAll("$1");
        }
        while (oql == null || oql.indexOf(63) != -1) {
            realName = SqlWhereParser.getRealParamNameBySymbol(oql, '?');
            if (!StringUtils.isEmpty(realName)) {
                if (mapDesignParam.containsKey(realName)) {
                    DesignParameter p = mapDesignParam.get(realName);
                    String value = CtrlReportUtil.getObjectString(p.getCurentValue());
                    if (StringUtils.isEmpty(value)) {
                        value = CtrlReportUtil.getObjectString(p.getDefaultValue());
                    }
                    if (StringUtils.isEmpty(value)) {
                        throw new CtrlReportException(Messages.getMLS("macroReplacementParameterValueCannotBeEmptyPleaseSetDefaultValue", "\u5b8f\u66ff\u6362\u7684\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u53c2\u6570\u9ed8\u8ba4\u503c\uff1a") + realName);
                    }
                    oql = ExtStringUtil.replaceFirst(oql, "?" + realName, value);
                    continue;
                }
                throw new CtrlReportException(Messages.getMLS("macroReplacementParameterNotFound", "\u6ca1\u6709\u627e\u5230\u5b8f\u66ff\u6362\u7684\u53c2\u6570\uff1a") + realName);
            }
            oql = ExtStringUtil.replaceFirst(oql, "?", "0x1x2x3x4x");
        }
        oql = ExtStringUtil.replace(oql, "0x1x2x3x4x", "?");
        while (oql.indexOf(36) > -1) {
            realName = SqlWhereParser.getRealParamNameBySymbol(oql, '$');
            if (!StringUtil.isEmpty((String)realName)) {
                oql = ExtStringUtil.replaceFirst(oql, '$' + realName, "@" + realName + "_temp_macro_param_suffix");
                DesignParameter dp = mapDesignParam.get(realName + "_temp_macro_param_suffix");
                if (dp == null || dp.getName().endsWith("_temp_macro_param_suffix")) continue;
                dp.setName(dp.getName() + "_temp_macro_param_suffix");
                continue;
            }
            oql = ExtStringUtil.replaceFirst(oql, String.valueOf('$'), "0x1x2x3x4x");
        }
        oql = ExtStringUtil.replace(oql, "0x1x2x3x4x", String.valueOf('$'));
        oql = CtrlDesignDataExecutor.handleEmptyParam(mapDesignParam, oql);
        return CtrlDesignDataExecutor.applyParameterMap(oql, mapDesignParam, isRun);
    }

    private static String applyParameterMap(String oql, Map<String, DesignParameter> mapDesignParam, boolean isRun) {
        int index = -1;
        while (oql.indexOf("@") > index) {
            index = oql.indexOf("@");
            String oqlBefore = oql.substring(0, index + 1);
            String oqlAfter = oql.substring(index + 1);
            boolean hasMarks = false;
            if (oqlBefore.contains("('@") && oqlAfter.contains("'")) {
                hasMarks = true;
            }
            String paramName = SqlWhereParser.getRealParamNameBySymbol("@" + oqlAfter, '@');
            String replaceValue = "@" + paramName;
            String paramKey = SqlWhereParser.containsKeyIgnoreCase(mapDesignParam, paramName);
            ++index;
            DesignParameter param = null;
            if (StringUtils.isNotEmpty(paramKey)) {
                param = mapDesignParam.get(paramKey);
            }
            if (param == null) continue;
            String curentValue = param.getCurentValue();
            oql = oqlBefore + CtrlDesignDataExecutor.processOqlIgnoreNull(oqlAfter, curentValue, param.isAllowNull(), param.isIgnoreNull(), isRun);
            if (curentValue == null) {
                curentValue = "";
            }
            String replaceString = "";
            if (StringUtils.isEmpty(curentValue)) {
                if (DesignDataType.TXT.intValue() != param.getDesignDataType().intValue()) {
                    replaceString = "null";
                }
                oql = ExtStringUtil.replaceFirst(oql, replaceValue, replaceString);
                continue;
            }
            if (curentValue.contains("0xx1xx")) {
                String[] valueList = curentValue.split("0xx1xx");
                if (curentValue.endsWith("0xx1xx") && hasMarks) {
                    ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(valueList));
                    arrayList.add("");
                    valueList = arrayList.toArray(new String[0]);
                }
                StringBuilder valueString = new StringBuilder();
                for (int i = 0; i < valueList.length; ++i) {
                    String value = valueList[i];
                    if (StringUtils.isEmpty(value) && DesignDataType.TXT.intValue() != param.getDesignDataType().intValue()) {
                        value = "null";
                    }
                    if (param.getDesignDataType().intValue() == DesignDataType.TXT.intValue()) {
                        if (hasMarks) {
                            if (i == 0) {
                                valueString.append(value).append("'");
                            } else if (i > 0 && i < valueList.length - 1) {
                                valueString.append("'").append(value).append("'");
                            } else {
                                valueString.append("'").append(value);
                            }
                        } else {
                            valueString.append(value);
                        }
                    } else if (param.getDesignDataType().intValue() == DesignDataType.DATE.intValue() || param.getDesignDataType().intValue() == DesignDataType.DATETIME.intValue()) {
                        valueString.append("to_date('").append(value).append("')");
                    } else if (param.getDesignDataType().intValue() == DesignDataType.TIME.intValue()) {
                        valueString.append("to_date('1970-01-01 ").append(value).append("')");
                    } else {
                        valueString.append(value);
                    }
                    if (i >= valueList.length - 1) continue;
                    valueString.append(",");
                }
                oql = ExtStringUtil.replaceFirst(oql, replaceValue, valueString.toString());
                continue;
            }
            StringBuilder valueString = new StringBuilder();
            if (param.getDesignDataType().intValue() == DesignDataType.DATE.intValue() || param.getDesignDataType().intValue() == DesignDataType.DATETIME.intValue()) {
                valueString.append("to_date('").append(curentValue).append("')");
            } else if (param.getDesignDataType().intValue() == DesignDataType.TIME.intValue()) {
                valueString.append("to_date('1970-01-01 ").append(curentValue).append("')");
            } else {
                valueString.append(curentValue);
            }
            oql = ExtStringUtil.replaceFirst(oql, replaceValue, valueString.toString());
        }
        return oql.replace("'null'", "null");
    }

    private static String handleEmptyParam(Map<String, DesignParameter> mapDesignParam, String oql) {
        if (null != oql) {
            while (oql.indexOf(64) != -1) {
                int startPos = oql.indexOf("@");
                String oAfter = oql.substring(startPos + 1);
                String paramName = SqlWhereParser.getRealParamName("@" + oAfter);
                String pName = SqlWhereParser.containsKeyIgnoreCase(mapDesignParam, paramName);
                if (StringUtil.isEmpty((String)pName)) {
                    DesignParameter tmp = new DesignParameter();
                    tmp.setName(paramName);
                    tmp.setAlias(paramName);
                    tmp.setInputType(InputType.LIST);
                    tmp.setDesignDataType(DesignDataType.TXT);
                    mapDesignParam.put(paramName, tmp);
                    mapDesignParam.put(paramName + "_text", tmp);
                }
                oql = oql.replaceFirst("@", "3xx4xx");
            }
            oql = oql.replaceAll("3xx4xx", "@");
        }
        return oql;
    }

    private static String processOqlIgnoreNull(String oqlAfter, String paramValue, boolean isAllowNull, boolean isIgnoreNull, boolean isRun) {
        boolean isFindIgnoreTag = false;
        int wh = oqlAfter.indexOf("?");
        int art = oqlAfter.indexOf("@");
        if (wh != -1 && art != -1 && wh < art) {
            isFindIgnoreTag = true;
        } else if (wh != -1 && art == -1) {
            isFindIgnoreTag = true;
        }
        if (isFindIgnoreTag) {
            oqlAfter = paramValue == null || paramValue.length() == 0 ? ExtStringUtil.replaceFirst(oqlAfter, " ? ", " null ") : ExtStringUtil.replaceFirst(oqlAfter, " ? ", " \"0\" ");
        }
        if (!isFindIgnoreTag && isAllowNull && isIgnoreNull && !isRun) {
            throw new RuntimeException(Messages.getMLS("whereClauseForDialectQueryIfParameterAllowsEmpty", "\u65b9\u8a00dialect\u67e5\u8be2\u7684Where\u5b50\u53e5\uff0c\u5982\u679c\u53c2\u6570\u5141\u8bb8\u7a7a\uff0c\u4e3a\u8fbe\u5230\u5ffd\u7565\u53c2\u6570\u7684\u76ee\u7684\uff0c\u8bf7\u52a0\u5165\" or ? is null\"\uff0c\u4f8b\u5982"));
        }
        return oqlAfter;
    }

    private static String buildSql(Object ctx, CtrlDesignQueryModel model, Map<String, DesignParameter> mapDesignParam, Map<String, String> logMap, int start, int rows, boolean isRun, Window parent, boolean forTitle) throws CtrlReportException {
        String keyword;
        Object p;
        IQuery query = model.getQuery();
        String sql = null;
        sql = CtrlDesignQueryModel.makeSQL(model);
        if ((sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if (sql != null && sql.length() > 0) {
            boolean bDialect = false;
            if (sql.startsWith("/*dialect*/")) {
                bDialect = true;
            }
            p = Pattern.compile(REMARK_REG);
            sql = p.matcher(sql).replaceAll("$1");
            if (bDialect) {
                sql = "/*dialect*/" + sql;
            }
        }
        while (sql == null || sql.indexOf(63) != -1) {
            String realName = SqlWhereParser.getRealParamNameBySymbol(sql, '?');
            if (!StringUtils.isEmpty(realName)) {
                if (mapDesignParam.containsKey(realName)) {
                    p = mapDesignParam.get(realName);
                    String value = CtrlReportUtil.getObjectString(((DesignParameter)((Object)p)).getCurentValue());
                    if (StringUtils.isEmpty(value)) {
                        value = CtrlReportUtil.getObjectString(p.getDefaultValue());
                    }
                    if (StringUtils.isEmpty(value)) {
                        throw new CtrlReportException(Messages.getMLS("macroReplacementParameterValueCannotBeEmptyPleaseSetDefaultValue", "\u5b8f\u66ff\u6362\u7684\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u53c2\u6570\u9ed8\u8ba4\u503c\uff1a") + realName);
                    }
                    sql = ExtStringUtil.replaceFirst(sql, "?" + realName, value);
                    continue;
                }
                throw new CtrlReportException(Messages.getMLS("macroReplacementParameterNotFound", "\u6ca1\u6709\u627e\u5230\u5b8f\u66ff\u6362\u7684\u53c2\u6570\uff1a") + realName);
            }
            sql = ExtStringUtil.replaceFirst(sql, "?", "0x1x2x3x4x");
        }
        sql = ExtStringUtil.replace(sql, "0x1x2x3x4x", "?");
        while (sql.indexOf(36) > -1) {
            String realName = SqlWhereParser.getRealParamNameBySymbol(sql, '$');
            if (!StringUtil.isEmpty((String)realName)) {
                sql = ExtStringUtil.replaceFirst(sql, '$' + realName, "@" + realName + "_temp_macro_param_suffix");
                DesignParameter dp = mapDesignParam.get(realName + "_temp_macro_param_suffix");
                if (dp == null || dp.getName().endsWith("_temp_macro_param_suffix")) continue;
                dp.setName(dp.getName() + "_temp_macro_param_suffix");
                continue;
            }
            sql = ExtStringUtil.replaceFirst(sql, String.valueOf('$'), "0x1x2x3x4x");
        }
        sql = ExtStringUtil.replace(sql, "0x1x2x3x4x", String.valueOf('$'));
        boolean isDialect = false;
        String sqllc = sql.toLowerCase(Locale.ENGLISH);
        if (sqllc.startsWith("/*dialect*/")) {
            isDialect = true;
        }
        if (!isRun && null != (keyword = ExtStringUtil.getExcludeSqlKeyword(ExtStringUtil.ignoreQuotation(sqllc)))) {
            throw new CtrlReportException(Messages.getMLS("unsupportedOperation1", "\u4e0d\u652f\u6301#1\u64cd\u4f5c\u3002").replace("#1", keyword));
        }
        String sqlNoRN = null;
        sqlNoRN = ExtStringUtil.replace(sqllc, "\r", " ");
        sqlNoRN = ExtStringUtil.replace(sqlNoRN, "\n", " ");
        sqlNoRN = CtrlReportUtil.trimStr(sqlNoRN);
        int dbType = -1;
        if (!isDialect && !CtrlDBUtil.isSuperQuerySource(((CtrlDesignKsqlQuery)query).getOutDB())) {
            HashMap dateTypeMap = new HashMap();
            String sqlNoSpace = CtrlReportUtil.removeSpace(sqllc);
            try {
                Set<Map.Entry<String, DesignParameter>> entrySet = mapDesignParam.entrySet();
                for (Map.Entry<String, DesignParameter> entry : entrySet) {
                    String name = entry.getKey();
                    DesignParameter p2 = entry.getValue();
                    String value = CtrlReportUtil.getObjectString(p2.getCurentValue());
                    value = CtrlReportUtil.strFilterSQL(value);
                    p2.setCurentValue(value);
                    boolean bl = false;
                    int dataType = p2.getDesignDataType().intValue();
                    if (dataType == 2) {
                        String msg;
                        boolean isDateToDateTime = false;
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1) {
                            msg = Messages.getMLS("warningDateParameterRecommendedUseTS1NotRecommendedD2", "\u8b66\u544a\uff1a\u65e5\u671f\u7c7b\u578b\u7684\u53c2\u6570\uff0c\u63a8\u8350\u4f7f\u7528{TS '#1'}\uff0c\u4e0d\u63a8\u8350{D '@#2'}").replace("#1", name).replace("#2", name);
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        } else if (sqlNoSpace.indexOf("{t'@" + name.toLowerCase() + "'}") != -1) {
                            msg = Messages.getMLS("warningDateParameterRecommendedUseTS1NotRecommendedT2", "\u8b66\u544a\uff1a\u65e5\u671f\u7c7b\u578b\u7684\u53c2\u6570\uff0c\u63a8\u8350\u4f7f\u7528{TS '@#1'}\uff0c\u4e0d\u63a8\u8350{T '@#2'}").replace("#1", name).replace("#2", name);
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        } else if (sqlNoSpace.indexOf("{ts'@" + name.toLowerCase() + "'}") != -1) {
                            isDateToDateTime = true;
                        }
                        bl = true;
                        if (StringUtils.isEmpty(value) && p2.isIgnoreNull()) {
                            dateTypeMap.put(name, null);
                        } else if (isDateToDateTime && !value.endsWith("01:02:03")) {
                            value = value + " " + "01:02:03";
                            p2.setCurentValue(value);
                        }
                    } else if (dataType == 4) {
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1 || sqlNoSpace.indexOf("{t'@" + name.toLowerCase() + "'}") != -1) {
                            String msg = Messages.getMLS("warningTimestampParameterUseTS1NotRecommendedD2", "\u8b66\u544a\uff1a\u65f6\u95f4\u6233\u7c7b\u578b\u7684\u53c2\u6570\uff0c\u8bf7\u4f7f\u7528 {TS '@#1'}\uff0c\u4e0d\u63a8\u8350{D '@#2'}").replace("#1", name).replace("#2", name);
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        }
                        bl = true;
                        if (StringUtils.isEmpty(value)) {
                            value = "";
                            p2.setCurentValue(value);
                            if (p2.isIgnoreNull()) {
                                dateTypeMap.put(name, null);
                            }
                        }
                    } else if (dataType == 5) {
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1 || sqlNoSpace.indexOf("{ts'@" + name.toLowerCase() + "'}") != -1) {
                            String msg = Messages.getMLS("warningTimeParameterUseTParameterNameSyntax", "\u8b66\u544a\uff1a\u65f6\u95f4\u7c7b\u578b\u7684\u53c2\u6570\uff0c\u8bf7\u4f7f\u7528 {T '@\u53c2\u6570\u540d\u79f0'} \u7684\u8bed\u6cd5");
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        }
                        if (StringUtils.isEmpty(value) && p2.isIgnoreNull()) {
                            dateTypeMap.put(name, null);
                        }
                        bl = true;
                    }
                    if (!bl) continue;
                    String oldvalue = "'@" + name + "'";
                    String newValue = "'" + value + "'";
                    if (StringUtils.isEmpty(p2.getCurentValue())) {
                        oldvalue = "{ts" + oldvalue + "}";
                        newValue = "NULL";
                    }
                    sql = ExtStringUtil.replace(sql, oldvalue, newValue);
                }
            }
            catch (Exception ex) {
                throw CtrlReportException.makeException(Messages.getMLS("failParseDate", "\u89e3\u6790\u65e5\u671f\u53c2\u6570\u9519\u8bef") + ex.getMessage(), ex);
            }
            String[] arr = CtrlDesignDataExecutor.getDBType(ctx, query);
            dbType = Integer.parseInt(arr[0]);
            try {
                sql = CtrlDesignKsqlSolver.solve(sql, mapDesignParam, dateTypeMap, true, dbType);
                for (String key : dateTypeMap.keySet()) {
                    DesignParameter dp = mapDesignParam.get(key);
                    dp.setCurentValue("");
                }
            }
            catch (CtrlReportException e) {
                throw e;
            }
            catch (Exception e) {
                throw CtrlReportException.makeException(Messages.getMLS("failParseSQL", "\u89e3\u6790SQL\u8bed\u53e5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7b26\u5408KSQL\u8bed\u6cd5") + e.getMessage(), e);
            }
            if (!isRun && forTitle) {
                sql = CtrlDesignDataExecutor.buildDialectTopNSQL(Pattern.compile("select\\s+top\\s+\\d+\\s+", 2), sql, " select top " + (dbType == DataCenterDBType.DB2.intValue() ? (rows <= 0 ? 1 : rows) : rows) + " ", Pattern.compile("\\s*select\\s+", 2));
            }
            sql = SqlWhereParser.parseKSQLTime(sql, dbType);
            CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)query;
            String outDB = CtrlReportUtil.getObjectString(ksqlQuery.getOutDB());
            if (!StringUtils.isEmpty(outDB)) {
                try {
                    sql = "/*dialect*/" + TransUtil.translate((String)sql, (int)dbType);
                }
                catch (SqlTranslateException e) {
                    throw CtrlReportException.makeException(Messages.getMLS("failTranslateKSQLToExternalDataCenter", "\u8fde\u63a5\u5230\u5916\u90e8\u6570\u636e\u4e2d\u5fc3\u7684KSQL\u7ffb\u8bd1\u5931\u8d25") + e.getMessage(), e);
                }
            }
        } else {
            String[] arr = CtrlDesignDataExecutor.getDBType(ctx, query);
            dbType = Integer.parseInt(arr[0]);
            HashMap<String, String> warnMap = new HashMap<String, String>();
            warnMap.put("sqlNoRN", sqlNoRN);
            StringBuilder sb = new StringBuilder();
            int bIndex = 0;
            Matcher m = outDBLinkPattern.matcher(sql);
            ArrayList tmpTables = new ArrayList();
            while (m.find()) {
                String outDBLink = m.group();
                sb.append(sql.substring(bIndex, m.start()));
                sb.append(" ");
                String tmpTableRes = "tmpTableRes" + outDBLink.hashCode();
                sb.append(tmpTableRes);
                sb.append(" ");
                bIndex = m.end();
                Entry<String, String> entry = new Entry<String, String>();
                entry.setText(tmpTableRes);
                entry.setValue(outDBLink);
                tmpTables.add(entry);
            }
            sb.append(sql.substring(bIndex));
            sql = sb.toString();
            for (Map.Entry<String, DesignParameter> entry : mapDesignParam.entrySet()) {
                DesignParameter designParameter = entry.getValue();
                String value = designParameter.getCurentValue();
                if (value == null || !value.startsWith("@ExtRpt")) continue;
                designParameter.setCurentValue(mapDesignParam.get(value.substring(1)).getCurentValue());
                designParameter.setCurentValueAlias(mapDesignParam.get(value.substring(1)).getCurentValueAlias());
            }
            sql = BindParam.replaceVariantDialect(sql, mapDesignParam, dbType, warnMap, isRun);
            String warnMsg = CtrlReportUtil.getObjectString(warnMap.get("warnMsg"));
            if (!StringUtils.isEmpty(warnMsg) && !isRun) {
                throw new RuntimeException(warnMsg);
            }
            if (!isRun && forTitle) {
                if (dbType == DataCenterDBType.ORACLE.intValue()) {
                    sql = CtrlDesignDataExecutor.buildOracleTopNSQL(Pattern.compile("\\s+rownum\\s*<{1}={0,1}\\s*\\d+\\s*", 2), sql, " rownum<=" + rows + " and ", Pattern.compile("\\s+where\\s+", 2));
                    if (sql.endsWith(" and ")) {
                        sql = sql.substring(0, sql.lastIndexOf(" and "));
                    }
                    String baseSql = "rownum<=" + rows;
                    String string = baseSql + " and ";
                    String errorSql = baseSql + " and and";
                    if (sql.indexOf(errorSql) >= 0) {
                        sql = sql.replaceAll(errorSql, string);
                    }
                    errorSql = baseSql + " and order";
                    String string2 = baseSql + " order";
                    if (sql.indexOf(errorSql) >= 0) {
                        sql = sql.replaceAll(errorSql, string2);
                    }
                } else if (dbType == DataCenterDBType.SQLSERVER.intValue()) {
                    sql = CtrlDesignDataExecutor.buildDialectTopNSQL(Pattern.compile("select\\s+top\\s+\\d+\\s+", 2), sql, " select top " + rows + " ", Pattern.compile("\\s*select\\s+", 2));
                } else if (dbType == DataCenterDBType.DB2.intValue()) {
                    sql = CtrlDesignDataExecutor.buildDialectTopNSQL(Pattern.compile("\\s+fetch\\s+first\\s+\\d+\\s+rows\\s+only\\s*", 2), sql, " fetch first " + (rows <= 0 ? 1 : rows) + " rows only ", Pattern.compile("\\s*\\z", 2));
                } else if (dbType == DataCenterDBType.POSTGRESQL.intValue()) {
                    sql = CtrlDesignDataExecutor.buildDialectTopNSQL(Pattern.compile("\\s+limit\\s+\\d+\\s+rows\\s*", 2), sql, " limit " + rows, Pattern.compile("\\s*\\z", 2));
                }
            }
            for (Entry entry : tmpTables) {
                sql = sql.replaceFirst((String)entry.getText(), (String)entry.getValue());
            }
        }
        logMap.put("sql", sql);
        logMap.put("dbType", String.valueOf(dbType));
        MiscUtil.log((int)4, (String)sql);
        return sql;
    }

    private static Map execute(Object ctx, CtrlDesignQueryModel model, Map<String, DesignParameter> mapDesignParam, Map<String, String> logMap, int start, int rows, boolean isRun, Window parent, boolean forTitle) throws Exception {
        if (logMap == null) {
            logMap = new HashMap<String, String>();
        }
        logMap.clear();
        if (mapDesignParam == null) {
            mapDesignParam = new HashMap<String, DesignParameter>();
        }
        HashSet<String> macroNames = new HashSet<String>();
        ExtRptContentChecker.analysisMacroUsage(ctx, macroNames, (HashMap<String, DesignParameter>)((HashMap)mapDesignParam), model);
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        String customType = CtrlReportUtil.getObjectString(commonQuery.getProperties().get(CtrlDesignUtil.CustomType));
        if (customType.equals(String.valueOf(2))) {
            return CtrlDesignDataExecutor.callProcedure(ctx, model, mapDesignParam, logMap, start, rows);
        }
        if (customType.equals(String.valueOf(3)) || customType.equals(String.valueOf(7)) || customType.equals(String.valueOf(8))) {
            return CtrlDesignDataExecutor.executeJavaCode(ctx, model, mapDesignParam, logMap, start, rows, parent);
        }
        if (customType.equals(String.valueOf(9))) {
            String oql = CtrlDesignDataExecutor.buildOql(ctx, model, mapDesignParam, logMap, start, rows, isRun, parent, forTitle);
            return CtrlDesignDataExecutor.executeOQL(ctx, oql, start, rows, logMap);
        }
        IQuery query = model.getQuery();
        String sql = CtrlDesignDataExecutor.buildSql(ctx, model, mapDesignParam, logMap, start, rows, isRun, parent, forTitle);
        model.setSql(sql);
        return CtrlDesignDataExecutor.doExecute(ctx, sql, start, rows, query, logMap);
    }

    private static Map doExecute(Object ctx, String sql, int start, int rows, IQuery query, Map logMap) throws Exception {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDBPageSizeInfoBySQL");
        pr.setString("sql", sql);
        pr.setString("ownerId", (String)query.getProperties().get("ownerId"));
        pr.setInt("start", start);
        pr.setInt("rows", rows);
        CtrlDesignDataExecutor.setOutDBToPR(pr, query);
        RptParams psR = null;
        try {
            long startTime = CtrlReportUtil.getSystemTime();
            psR = FacadeFactory.commonExecute(ctx, pr);
            logMap.put("useTime", CtrlReportUtil.getSystemTime() - startTime + " " + Messages.getMLS("millisecond", "\u6beb\u79d2"));
        }
        catch (Exception e2) {
            BOSException e2;
            Throwable bosCause;
            String excMsg = "";
            Throwable t = e2.getCause();
            excMsg = null != t ? CtrlReportUtil.getObjectString(t.getMessage()) : e2.getMessage();
            if (t != null && (bosCause = t.getCause()) instanceof BOSException) {
                e2 = (BOSException)bosCause;
                Throwable realCause = bosCause.getCause();
                if (realCause instanceof SuperQueryNoPermissionException || (realCause = realCause.getCause()) instanceof SuperQueryNoPermissionException) {
                    throw (SuperQueryNoPermissionException)((Object)realCause);
                }
            }
            String msg1 = Messages.getMLS("executeSQLFail", "\u6267\u884cSQL\u5931\u8d25");
            throw CtrlReportException.makeException(msg1 + "\r\n" + excMsg, e2);
        }
        ResultSet irs = (ResultSet)psR.getObject("object");
        HashMap<String, ResultSet> mapResult = new HashMap<String, ResultSet>();
        mapResult.put("6xx8xxRowset", irs);
        return mapResult;
    }

    private static String buildOracleTopNSQL(Pattern topNFinder, String sql, String topNReplaceMement, Pattern insertPlaceFinder) {
        StringBuilder sb = new StringBuilder();
        Matcher m = topNFinder.matcher(sql);
        boolean found = false;
        int lastEnd = 0;
        while (m.find()) {
            found = true;
            m.group();
            sb.append(sql.substring(lastEnd, m.start()));
            sb.append(topNReplaceMement);
            lastEnd = m.end();
        }
        if (found) {
            sb.append(sql.substring(lastEnd));
        }
        if (!found) {
            m = insertPlaceFinder.matcher(sql);
            while (m.find()) {
                m.group();
                found = true;
                sb.append(sql.substring(lastEnd, m.start()));
                sb.append(" \nwhere ");
                sb.append(topNReplaceMement);
                lastEnd = m.end();
            }
            if (!found) {
                sb.append(sql);
            } else {
                sb.append(sql.substring(lastEnd));
            }
        }
        sql = sb.toString();
        sb = new StringBuilder();
        found = false;
        lastEnd = 0;
        Pattern distinctFinder = Pattern.compile("\\s*select\\s+top\\s+\\d+\\s+distinct\\s+", 2);
        m = distinctFinder.matcher(sql);
        Pattern numberFinder = Pattern.compile("\\s+\\d+\\s+");
        while (m.find()) {
            found = true;
            String group = m.group();
            Matcher t = numberFinder.matcher(group);
            t.find();
            sb.append(sql.substring(lastEnd, m.start()));
            sb.append(" select distinct top ");
            sb.append(t.group());
            sb.append(" ");
            lastEnd = m.end();
        }
        if (!found) {
            sb.append(sql);
        } else {
            sb.append(sql.substring(lastEnd));
            found = false;
            lastEnd = 0;
            Pattern doubleTopFinder = Pattern.compile("\\s*select\\s+distinct\\s+top\\s+\\d+\\s+top\\s+\\d+\\s+", 2);
            sql = sb.toString();
            sb = new StringBuilder();
            m = doubleTopFinder.matcher(sql);
            while (m.find()) {
                found = true;
                String group = m.group();
                Matcher t = numberFinder.matcher(group);
                t.find();
                sb.append(sql.substring(lastEnd, m.start()));
                sb.append(" select distinct top ");
                sb.append(t.group());
                sb.append(" ");
                lastEnd = m.end();
            }
            if (found) {
                sb.append(sql.substring(lastEnd));
                sql = sb.toString();
            } else {
                sb.append(sql);
            }
        }
        sql = sb.toString();
        return sql;
    }

    private static String buildDialectTopNSQL(Pattern topNFinder, String sql, String topNReplaceMement, Pattern insertPlaceFinder) {
        StringBuilder sb = new StringBuilder();
        Matcher m = topNFinder.matcher(sql);
        boolean found = false;
        int lastEnd = 0;
        while (m.find()) {
            found = true;
            m.group();
            sb.append(sql.substring(lastEnd, m.start()));
            sb.append(topNReplaceMement);
            lastEnd = m.end();
        }
        if (found) {
            sb.append(sql.substring(lastEnd));
        }
        if (!found) {
            m = insertPlaceFinder.matcher(sql);
            while (m.find()) {
                m.group();
                found = true;
                sb.append(sql.substring(lastEnd, m.start()));
                sb.append(topNReplaceMement);
                lastEnd = m.end();
            }
            if (!found) {
                sb.append(sql);
            } else {
                sb.append(sql.substring(lastEnd));
            }
        }
        sql = sb.toString();
        sb = new StringBuilder();
        found = false;
        lastEnd = 0;
        Pattern distinctFinder = Pattern.compile("\\s*select\\s+top\\s+\\d+\\s+distinct\\s+", 2);
        m = distinctFinder.matcher(sql);
        Pattern numberFinder = Pattern.compile("\\s+\\d+\\s+");
        while (m.find()) {
            found = true;
            String group = m.group();
            Matcher t = numberFinder.matcher(group);
            t.find();
            sb.append(sql.substring(lastEnd, m.start()));
            sb.append(" select distinct top ");
            sb.append(t.group());
            sb.append(" ");
            lastEnd = m.end();
        }
        if (!found) {
            sb.append(sql);
        } else {
            sb.append(sql.substring(lastEnd));
            found = false;
            lastEnd = 0;
            Pattern doubleTopFinder = Pattern.compile("\\s*select\\s+distinct\\s+top\\s+\\d+\\s+top\\s+\\d+\\s+", 2);
            sql = sb.toString();
            sb = new StringBuilder();
            m = doubleTopFinder.matcher(sql);
            while (m.find()) {
                found = true;
                String group = m.group();
                Matcher t = numberFinder.matcher(group);
                t.find();
                sb.append(sql.substring(lastEnd, m.start()));
                sb.append(" select distinct top ");
                sb.append(t.group());
                sb.append(" ");
                lastEnd = m.end();
            }
            if (found) {
                sb.append(sql.substring(lastEnd));
                sql = sb.toString();
            } else {
                sb.append(sql);
            }
        }
        sql = sb.toString();
        return sql;
    }

    public static ResultSet preview(Object ctx, CtrlDesignQueryModel model, Map mapDesignParam, Map logMap) throws Exception {
        Map mapResult = CtrlDesignDataExecutor.execute(ctx, model, mapDesignParam, logMap, 0, 0, false, null);
        return (ResultSet)mapResult.get("6xx8xxRowset");
    }

    public static String[] getDBType(Object ctx, IQuery query) throws CtrlReportException {
        String[] arr = new String[2];
        int ret = CtrlDesignDataExecutor.getOutDBType(ctx, query);
        if (ret != -1) {
            DataCenterDBType dbType = DataCenterDBType.getDBType((int)ret);
            arr[0] = String.valueOf(dbType.intValue());
            arr[1] = dbType.getName();
        } else {
            int dbType = ExtDBUtil.getDBType(ctx);
            arr[0] = String.valueOf(dbType);
            DataCenterDBType type = DataCenterDBType.getDBType((int)dbType);
            arr[1] = type != null ? type.getName() : "unknow db type";
        }
        return arr;
    }

    private static int getOutDBType(Object ctx, IQuery query) throws CtrlReportException {
        int ret = -1;
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)query;
        String outDB = CtrlReportUtil.getObjectString(ksqlQuery.getOutDB());
        if (StringUtils.isEmpty(outDB)) {
            return ret;
        }
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDataCenterVo");
        pr.setObject("outDB", outDB);
        try {
            RptParams psR = FacadeFactory.commonExecute(ctx, pr);
            Object obj = psR.getObject("getDataCenterVo");
            if (obj == null) {
                throw new CtrlReportException(outDB + "\uff1a" + Messages.getMLS("dataSourceNotExist", "\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u8bbe\u7f6e"));
            }
            DataCenterInfo vo = (DataCenterInfo)obj;
            return vo.getDbType();
        }
        catch (UndeclaredThrowableException e) {
            int count = 0;
            for (Throwable cause = e.getCause(); cause != null && count++ <= 20; cause = cause.getCause()) {
                if (!(cause instanceof DataCenterNoPermissionException)) continue;
                throw new DataCenterNoPermissionException(e);
            }
            throw new CtrlReportException(outDB + "\uff1a" + Messages.getMLS("dataSourceNotExist", "\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u8bbe\u7f6e"), (Throwable)e);
        }
        catch (Exception e) {
            throw new CtrlReportException(outDB + "\uff1a" + Messages.getMLS("dataSourceNotExist", "\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u8bbe\u7f6e"), (Throwable)e);
        }
    }

    private static final void setOutDBToPR(RptParams pr, IQuery query) {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)query;
        String outDB = CtrlReportUtil.getObjectString(ksqlQuery.getOutDB());
        if (!StringUtils.isEmpty(outDB)) {
            pr.setObject("outDB", outDB);
        }
    }

    public static ResultSet execute(Object ctx, String outDB, String sql, HashMap logMap, int start, int rows) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDBPageSizeInfoBySQL");
        pr.setString("sql", sql);
        pr.setInt("start", start);
        pr.setInt("rows", rows);
        pr.setObject("outDB", outDB);
        logMap.clear();
        logMap.put("sql", sql);
        long startTime = CtrlReportUtil.getSystemTime();
        RptParams psR = FacadeFactory.commonExecute(ctx, pr);
        logMap.put("useTime", CtrlReportUtil.getSystemTime() - startTime + " " + Messages.getMLS("millisecond", "\u6beb\u79d2"));
        return (ResultSet)psR.getObject("object");
    }

    public static Map callProcedure(Object ctx, CtrlDesignQueryModel model, Map mapDesignParam, Map logMap, int start, int rows) throws CtrlReportException {
        ProcedureModel pm = model.getCommonQuery().getProcedureModel();
        ArrayList<InOutputParamVO> procedureVOList = new ArrayList<InOutputParamVO>();
        StringBuilder logProcedureParam = new StringBuilder();
        boolean hasCursor = false;
        ArrayList paramList = pm.getParamList();
        if (paramList != null && !paramList.isEmpty()) {
            int size = paramList.size();
            for (int i = 0; i < size; ++i) {
                ProcedureParamData pmd = (ProcedureParamData)((Object)paramList.get(i));
                String name = pmd.getName();
                int ioType = pmd.getIoType().intValue();
                int dataType = pmd.getDataType().intValue();
                Object objValue = null;
                if (ioType == 0) {
                    objValue = CtrlDesignDataExecutor.getProcedureValue(pmd, mapDesignParam);
                }
                if (ProcedureDataType.CURSOR.equals(pmd.getDataType())) {
                    hasCursor = true;
                }
                InOutputParamVO vo = new InOutputParamVO();
                vo.setName(name);
                vo.setIoType(ioType);
                vo.setDataType(dataType);
                vo.setValue(objValue);
                procedureVOList.add(vo);
                logProcedureParam.append(Messages.getMLS("storedProcedureParameter", "\u5b58\u50a8\u8fc7\u7a0b\u53c2\u6570:")).append(name).append(", value =").append(objValue);
                logProcedureParam.append(", ioType = ").append(pmd.getIoType()).append(", DataType = ").append(pmd.getDataType()).append("\r\n");
            }
        }
        String resultNumberName = null;
        resultNumberName = pm.getDbType() == 2 || pm.getDbType() == 5 && hasCursor ? pm.getResultCursor() : String.valueOf(pm.getResultNumber());
        RptParams pr = new RptParams();
        pr.setString("MethodName", "callProcedure");
        pr.setString("procedureName", pm.getName());
        pr.setInt("dbType", pm.getDbType());
        pr.setString("resultNumberName", resultNumberName);
        pr.setObject("paramList", procedureVOList);
        pr.setInt("start", start);
        pr.setInt("rows", rows);
        CtrlDesignDataExecutor.setOutDBToPR(pr, model.getQuery());
        RptParams psR = null;
        try {
            String paramLog = logProcedureParam.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("start call storeProcedure: " + pm.getName()));
                log.debug((Object)("\r\n" + paramLog));
            }
            MiscUtil.log((int)4, (String)("start call storeProcedure: " + pm.getName()));
            MiscUtil.log((int)4, (String)("\r\n" + paramLog));
            long startTime = CtrlReportUtil.getSystemTime();
            psR = FacadeFactory.commonExecute(ctx, pr);
            logMap.put("useTime", CtrlReportUtil.getSystemTime() - startTime + " " + Messages.getMLS("millisecond", "\u6beb\u79d2"));
        }
        catch (BOSException e) {
            String excMsg = "";
            Throwable t = e.getCause();
            excMsg = null != t ? CtrlReportUtil.getObjectString(t.getMessage()) : e.getMessage();
            throw CtrlReportException.makeException(Messages.getMLS("executeStoredProcedureFailed", "\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u5931\u8d25:\r\n") + excMsg, e);
        }
        return (Map)psR.getObject("object");
    }

    private static Map executeJavaCode(Object ctx, CtrlDesignQueryModel model, Map mapDesignParam, Map logMap, int start, int rows, Window parent) throws CtrlReportException {
        HashMap<String, Object> toJavaMap = new HashMap<String, Object>(mapDesignParam.size());
        toJavaMap.put("CtrlDesignQueryModel", model);
        StringBuilder logParamSystem = new StringBuilder();
        StringBuilder logParamCustom = new StringBuilder();
        Iterator it = mapDesignParam.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
            toJavaMap.put(p.getName(), CtrlReportUtil.getObjectString(p.getCurentValue()));
            if (name.startsWith("ExtRpt")) {
                logParamSystem.append(Messages.getMLS("builtInParameter", "\u5185\u7f6e\u53c2\u6570:")).append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
                continue;
            }
            logParamCustom.append(Messages.getMLS("customizedParameter", "\u5b9a\u5236\u53c2\u6570:")).append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
        }
        StringBuilder logParam = new StringBuilder();
        logParam.append("\r\n").append((CharSequence)logParamCustom).append((CharSequence)logParamSystem);
        if (log.isDebugEnabled()) {
            String paramLog = logParam.toString();
            log.debug((Object)paramLog);
        }
        MiscUtil.log((int)4, (String)logParam.toString());
        JavaModel jm = model.getCommonQuery().getJavaModel();
        int interfaceType = jm.getInterfaceType();
        int executeType = jm.getExecuteType();
        IJavaDataSet iJavaDataSet = null;
        String customSQL = "";
        ResultSet irs = null;
        if (executeType == 0) {
            String strFullName = jm.getFullname();
            if (StringUtils.isEmpty(strFullName)) {
                throw new CtrlReportException(Messages.getMLS("javaDataSetDoesNotSpecifyFullPathOfReflectionClass", "Java\u6570\u636e\u96c6\u6ca1\u6709\u6307\u5b9a\u53cd\u5c04\u7c7b\u5168\u8def\u5f84"));
            }
            try {
                iJavaDataSet = (IJavaDataSet)Class.forName(strFullName).newInstance();
                iJavaDataSet.setFilterParam(toJavaMap);
                iJavaDataSet.setContext(ctx);
                if (interfaceType == 0) {
                    customSQL = iJavaDataSet.getCustomSQL(parent);
                }
            }
            catch (Exception e) {
                throw CtrlReportException.makeException(Messages.getMLS("errorInReflectionClassFullPath", "\u53cd\u5c04\u7c7b\u5168\u8def\u5f84\u9519\u8bef") + e.getMessage(), e);
            }
            catch (Throwable t) {
                throw CtrlReportException.makeException(Messages.getMLS("errorInReflectionClassFullPath", "\u53cd\u5c04\u7c7b\u5168\u8def\u5f84\u9519\u8bef") + t.getMessage(), t);
            }
        }
        String[] arr = CtrlDesignDataExecutor.getDBType(ctx, model.getQuery());
        int dbType = Integer.parseInt(arr[0]);
        logMap.put("sql", customSQL);
        logMap.put("dbType", String.valueOf(dbType));
        MiscUtil.log((int)4, (String)customSQL);
        if (interfaceType == 0) {
            throw CtrlReportException.makeException(Messages.getMLS("unsupportedJavaDatasetSQLMethod", "\u4e0d\u652f\u6301\u901a\u8fc7java\u6570\u636e\u96c6\u83b7\u53d6SQL\u7684\u73a9\u6cd5\uff01"), null);
        }
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)model.getQuery();
        String outDB = CtrlReportUtil.getObjectString(ksqlQuery.getOutDB());
        if (iJavaDataSet == null) {
            throw CtrlReportException.makeException(Messages.getMLS("unsupportedJavaDatasetEmpty", "\u4e0d\u652f\u6301java\u6570\u636e\u96c6\u4e3a\u7a7a"), null);
        }
        try {
            ResultSet[] iRowSets = iJavaDataSet.getCustomRowSet(parent, outDB);
            irs = iRowSets[0];
        }
        catch (Exception e) {
            String excMsg = "";
            Throwable t = e.getCause();
            if (null != t) {
                excMsg = CtrlReportUtil.getObjectString(t.getMessage());
            }
            String msg1 = Messages.getMLS("failureInExecutingGetCustomRowSetInterfaceOfJavaDataSet", "\u6267\u884cjava\u6570\u636e\u96c6\u63a5\u53e3getCustomRowSet()\u5931\u8d25");
            throw CtrlReportException.makeException(msg1 + "\r\n" + excMsg, e);
        }
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        mapResult.put("6xx8xxRowset", irs);
        StringBuilder logProcedureParam = new StringBuilder();
        try {
            Map mapFromJava = iJavaDataSet.getOutputParam();
            ArrayList paramList = jm.getParamList();
            if (paramList != null && !paramList.isEmpty()) {
                int size = paramList.size();
                for (int i = 0; i < size; ++i) {
                    ProcedureParamData pmd = (ProcedureParamData)((Object)paramList.get(i));
                    String name = pmd.getName();
                    String value = CtrlReportUtil.getObjectString(mapFromJava.get(name));
                    InOutputParamVO vo = new InOutputParamVO();
                    vo.setName(name);
                    vo.setDataType(pmd.getDataType().intValue());
                    vo.setValue(value);
                    mapResult.put(name, vo);
                    logProcedureParam.append(Messages.getMLS("outputParameter2", "\u8f93\u51fa\u53c2\u6570:")).append(name).append(", value =").append(value);
                    logProcedureParam.append(", DataType = ").append(pmd.getDataType()).append("\r\n");
                }
            }
            String paramLog = logProcedureParam.toString();
            log.debug((Object)("\r\n" + paramLog));
            MiscUtil.log((int)4, (String)("\r\n" + paramLog));
        }
        catch (Throwable t) {
            log.debug((Object)Messages.getMLS("getOutputParameterError", "\u53d6\u8f93\u51fa\u53c2\u6570\u9519\u8bef"), t);
            MiscUtil.log((Throwable)t);
        }
        return mapResult;
    }

    private static Map executeOQL(Object ctx, String oql, int start, int rows, Map logMap) throws CtrlReportException {
        RptParams psR;
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getPageSizeInfoByOQL");
        pr.setString("oql", oql);
        pr.setInt("start", start);
        pr.setInt("rows", rows);
        logMap.clear();
        logMap.put("oql", oql);
        long startTime = CtrlReportUtil.getSystemTime();
        try {
            psR = FacadeFactory.commonExecute(ctx, pr);
        }
        catch (BOSException e) {
            String excMsg = "";
            Throwable t = e.getCause();
            excMsg = null != t ? CtrlReportUtil.getObjectString(t.getMessage()) : e.getMessage();
            String msg1 = Messages.getMLS("executeSQLFail", "\u6267\u884cSQL\u5931\u8d25");
            throw CtrlReportException.makeException(msg1 + "\r\n" + excMsg, e);
        }
        logMap.put("useTime", CtrlReportUtil.getSystemTime() - startTime + " " + Messages.getMLS("millisecond", "\u6beb\u79d2"));
        ResultSet irs = (ResultSet)psR.getObject("object");
        HashMap<String, ResultSet> mapResult = new HashMap<String, ResultSet>();
        mapResult.put("6xx8xxRowset", irs);
        return mapResult;
    }

    private static Object getProcedureValue(ProcedureParamData pmd, Map mapDesignParam) throws CtrlReportException {
        String bindFilterParamName = CtrlReportUtil.getObjectString(pmd.getBindFilterParamName());
        int dataType = pmd.getDataType().intValue();
        String value = null;
        if (StringUtils.isEmpty(bindFilterParamName) || !mapDesignParam.containsKey(bindFilterParamName)) {
            value = pmd.getDefaultValue();
            log.debug((Object)(Messages.getMLS("warningNoBoundFilterParameterUsingDefaultValue", "\u8b66\u544a\uff1a\u6ca1\u6709\u7ed1\u5b9a\u8fc7\u6ee4\u53c2\u6570\uff0c\u53d6\u9ed8\u8ba4\u503c ") + bindFilterParamName));
            MiscUtil.log((int)4, (String)(Messages.getMLS("warningNoBoundFilterParameterUsingDefaultValue", "\u8b66\u544a\uff1a\u6ca1\u6709\u7ed1\u5b9a\u8fc7\u6ee4\u53c2\u6570\uff0c\u53d6\u9ed8\u8ba4\u503c ") + bindFilterParamName));
        } else {
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(bindFilterParamName));
            value = CtrlReportUtil.getObjectString(p.getCurentValue());
            if (StringUtils.isEmpty(value)) {
                value = pmd.getDefaultValue();
            }
        }
        try {
            if (value == null || value.length() == 0) {
                return null;
            }
            switch (dataType) {
                case 0: {
                    return value;
                }
                case 1: {
                    return Integer.valueOf(value);
                }
                case 2: {
                    return new BigDecimal(value);
                }
                case 3: {
                    long longDate = CtrlReportUtil.sdf_yyyy_MM_dd.get().parse(value).getTime();
                    return new Date(longDate);
                }
                case 4: {
                    return new Timestamp(CtrlReportUtil.getDateLong(value));
                }
                case 5: {
                    return new Time(CtrlReportUtil.getTimeLong(value));
                }
            }
            return null;
        }
        catch (Exception e) {
            String msg = "#1\r\n#2#3\r\n#4#5\r\n#6".replace("#1", Messages.getMLS("storedProcedureInputParameterDataTypeError", "\u5b58\u50a8\u8fc7\u7a0b\u7684\u8f93\u5165\u53c2\u6570\u6570\u636e\u7c7b\u578b\u9519\u8bef")).replace("#2", Messages.getMLS("parameterName", "\u53c2\u6570\u540d\u79f0\uff1a")).replace("#3", pmd.getName()).replace("#4", Messages.getMLS("dataType2", "\u6570\u636e\u7c7b\u578b\uff1a")).replace("#5", pmd.getDataType().toString()).replace("#6", Messages.getMLS("filterValue", "\u8fc7\u6ee4\u503c\uff1a"));
            throw CtrlReportException.makeException(msg, e);
        }
    }
}

