/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.model;

import com.kingdee.bos.datawizard.edd.ctrlreport.bo.KSQLReportBO;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CycleException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataSetContentNotExistsIOException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.code.AInputStream;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StreamUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.log4j.Logger;

public class CtrlDesignInputStream
extends AInputStream {
    private static final Logger log = LogUtil.getPackageLogger(CtrlDesignInputStream.class);
    private String datasetID;
    private String dbsourcename;
    private String groupID;
    private String groupName;
    private String isolateTag;
    private Object ctx;
    private boolean isFound = true;
    KSQLReportInfo info;
    byte[] dataModel;

    public CtrlDesignInputStream(Object ctx, String datasetID) {
        this.ctx = ctx;
        this.datasetID = datasetID;
        try {
            this.reset();
        }
        catch (IOException e) {
            this.isFound = false;
            log.warn((Object)"reset CtrlDesignInputStream failed", (Throwable)e);
            StreamUtil.closeStream((InputStream)((Object)this));
        }
    }

    public CtrlDesignInputStream(Object ctx, String groupID, String groupName, String datasetID, String dbsourcename, String isolateTag) {
        this.ctx = ctx;
        this.groupID = groupID;
        this.groupName = groupName;
        this.dbsourcename = dbsourcename;
        this.isolateTag = isolateTag;
        this.datasetID = datasetID;
        try {
            this.reset();
        }
        catch (IOException e) {
            this.isFound = false;
            log.warn((Object)"rest CtrlDesignInputStream failed", (Throwable)e);
            StreamUtil.closeStream((InputStream)((Object)this));
        }
    }

    public CtrlDesignInputStream(Object ctx, byte[] data) {
        this.ctx = ctx;
        this.dataModel = data;
        try {
            this.reset();
        }
        catch (IOException e) {
            this.isFound = false;
            log.warn((Object)"rest CtrlDesignInputStream failed", (Throwable)e);
            StreamUtil.closeStream((InputStream)((Object)this));
        }
    }

    public final void reset() throws IOException {
        byte[] data = null;
        if (null != this.dataModel) {
            data = this.dataModel;
        } else {
            try {
                this.info = StringUtils.isEmpty(this.groupID) ? KSQLReportBO.getKSQLReportInfo(this.ctx, this.datasetID) : KSQLReportBO.getKSQLReportInfo(this.ctx, this.groupID, this.groupName, this.datasetID, this.dbsourcename, this.isolateTag);
                if (this.info == null) {
                    this.isFound = false;
                    return;
                }
                data = this.info.getContent();
            }
            catch (Exception e) {
                this.isFound = false;
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (data == null) {
            throw new DataSetContentNotExistsIOException(Messages.getMLS("undefinedDatasetContent", "\u672a\u5b9a\u4e49\u6570\u636e\u96c6\u5185\u5bb9"));
        }
        this.setProvider(new ByteArrayInputStream(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInputObject(CtrlDesignQueryModel model, Set<String> circularDependencySet) throws CycleException {
        IXmlElement xml = null;
        try {
            xml = XmlUtil.loadXmlStream((InputStream)((Object)this));
        }
        catch (Exception ex) {
            log.warn((Object)Messages.getMLS("deserializeDatasetMetaFailed", "\u53cd\u5e8f\u5217\u5316\u6570\u636e\u96c6meta\u5931\u8d25"), (Throwable)ex);
        }
        finally {
            StreamUtil.closeStream((InputStream)((Object)this));
        }
        if (xml != null) {
            CtrlDesignUtil.toObject(this.ctx, model, xml, circularDependencySet);
        } else {
            model.setQuery((IQuery)new CtrlDesignKsqlQuery(true));
        }
    }

    public String getXmlString() {
        IXmlElement xml = null;
        try {
            xml = XmlUtil.loadXmlStream((InputStream)((Object)this));
            String string = XmlUtil.outputString((IXmlElement)xml);
            return string;
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            StreamUtil.closeStream((InputStream)((Object)this));
        }
        return null;
    }

    public boolean isFound() {
        return this.isFound;
    }

    public void setIsolateTag(String isolateTag) {
        this.isolateTag = isolateTag;
    }
}

