/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.model;

import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtStringUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.BindParam;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.SqlWhereParser;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlUnionSelect;
import kd.bos.ksql.dom.expr.QueryExpr;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlDateTimeExpr;
import kd.bos.ksql.dom.expr.SqlDoubleExpr;
import kd.bos.ksql.dom.expr.SqlExistsExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlInListExpr;
import kd.bos.ksql.dom.expr.SqlInSubQueryExpr;
import kd.bos.ksql.dom.expr.SqlIntExpr;
import kd.bos.ksql.dom.expr.SqlLongExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlNotExpr;
import kd.bos.ksql.dom.expr.SqlNullExpr;
import kd.bos.ksql.dom.stmt.SqlSelectStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SqlExprParser;
import kd.bos.ksql.parser.SqlParser;
import kd.bos.ksql.visitor.ASTVisitor;
import org.apache.log4j.Logger;

public class CtrlDesignKsqlSolver {
    private static final Logger log = LogUtil.getPackageLogger(CtrlDesignKsqlSolver.class);
    private Map params = new HashMap(10);
    private int dbType;
    private Map dateTypeMap;
    private boolean simpleVarStyle;
    private Map mapDesignParam = new HashMap(10);

    public CtrlDesignKsqlSolver(Map mapDesignParam, Map dateTypeMap, boolean simpleVarStyle, int dbType) {
        this.dbType = dbType;
        this.dateTypeMap = dateTypeMap;
        this.simpleVarStyle = simpleVarStyle;
        this.mapDesignParam = mapDesignParam;
        StringBuilder logParamSystem = new StringBuilder();
        StringBuilder logParamCustom = new StringBuilder();
        Iterator it = mapDesignParam.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
            DesignParameter oldp = null;
            String value = null;
            String key = p.getName();
            for (int times = 0; times < 10; ++times) {
                if (null == p) continue;
                value = p.getCurentValue();
                if (value.startsWith("@ExtRpt")) {
                    value = value.substring(1);
                    oldp = p;
                    p = (DesignParameter)((Object)mapDesignParam.get(value));
                    p = p != null ? p : oldp;
                    continue;
                }
                value = StringUtil.isEmptyString((String)value) ? p.getDefaultValue() : value;
                value = value == null ? "" : value;
                break;
            }
            this.params.put(key, value);
            if (p == null) continue;
            if (name != null && name.startsWith("ExtRpt")) {
                logParamSystem.append(Messages.getMLS("builtInParameter", "\u5185\u7f6e\u53c2\u6570:")).append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
                continue;
            }
            logParamCustom.append(Messages.getMLS("customizedParameter", "\u5b9a\u5236\u53c2\u6570:")).append(key).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
        }
        StringBuilder logParam = new StringBuilder();
        logParam.append("\r\n").append((CharSequence)logParamCustom).append((CharSequence)logParamSystem);
        if (log.isDebugEnabled()) {
            String paramLog = logParam.toString();
            log.debug((Object)paramLog);
        }
        MiscUtil.log((int)4, (String)logParam.toString());
    }

    public static final SqlSelectBase makeSqlSelect(String select) throws ParserException {
        Lexer lexer = new Lexer(select);
        SqlParser parser = new SqlParser(lexer);
        Collection c = parser.parseStmtList();
        SqlSelectBase sqlSelectBase = ((SqlSelectStmt)c.iterator().next()).select;
        return sqlSelectBase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String solve(String sql, Map mapDesignParam, Map dateTypeMap, boolean simpleVarStyle, int dbType) throws Exception {
        if (StringUtil.isEmptyString((String)sql)) {
            return sql;
        }
        log.debug((Object)("source:" + sql));
        CtrlDesignKsqlSolver solver = new CtrlDesignKsqlSolver(mapDesignParam, dateTypeMap, simpleVarStyle, dbType);
        String losql = sql.trim().toLowerCase(Locale.ENGLISH);
        String result = "";
        if (!losql.startsWith("select")) {
            if (!losql.startsWith("where") && !losql.startsWith("order by")) throw new ParserException("unsupport sql text");
            result = solver.solveEntityView(sql);
        } else {
            SqlSelectBase sb = solver.solveSelect(sql);
            result = sb.toString();
        }
        if (!log.isDebugEnabled()) return result;
        log.debug((Object)("result:" + result));
        return result;
    }

    private SqlExpr str2KsqlExpr(String exprStr) throws ParserException {
        Lexer lexer = new Lexer(exprStr);
        SqlExprParser parser = new SqlExprParser(lexer);
        SqlExpr expr = parser.expr();
        return expr;
    }

    private static void trimSqlIdentifierExpr(SqlIdentifierExpr expr) {
        String exprString = expr.value;
        if (exprString.charAt(0) == '\"') {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < exprString.length(); ++i) {
                if (exprString.charAt(i) == '\"') continue;
                sb.append(exprString.charAt(i));
            }
            expr.value = sb.toString();
        }
    }

    public static void covertSqlExpr_forEntityView(SqlExpr expr) {
        if (expr instanceof SqlIdentifierExpr) {
            CtrlDesignKsqlSolver.trimSqlIdentifierExpr((SqlIdentifierExpr)expr);
            return;
        }
        Stack<Object> stack = new Stack<Object>();
        stack.push(expr);
        while (!stack.isEmpty()) {
            SqlExpr subExpr = (SqlExpr)stack.pop();
            Field[] fields = subExpr.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    Field field = subExpr.getClass().getDeclaredField(fields[i].getName());
                    Object obj = field.get(subExpr);
                    if (obj == null || !SqlExpr.class.isAssignableFrom(obj.getClass())) continue;
                    if (obj instanceof SqlIdentifierExpr) {
                        CtrlDesignKsqlSolver.trimSqlIdentifierExpr((SqlIdentifierExpr)obj);
                        continue;
                    }
                    if (obj instanceof SqlLongExpr || obj instanceof SqlIntExpr || obj instanceof SqlDoubleExpr || obj instanceof SqlDateTimeExpr || obj instanceof SqlNCharExpr || obj instanceof SqlCharExpr || obj instanceof SqlNullExpr) continue;
                    stack.push(obj);
                    continue;
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private String orderBys2Str_forEntityView(List orderBys) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < orderBys.size(); ++i) {
            SqlOrderByItem item = (SqlOrderByItem)orderBys.get(i);
            CtrlDesignKsqlSolver.covertSqlExpr_forEntityView(item.expr);
            sb.append(item.expr.toString()).append(' ').append(item.mode == 0 ? "ASC" : "DESC");
            if (i == orderBys.size() - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private SqlExpr solvePureSqlExpr(SqlExpr expr) throws CtrlReportException {
        try {
            String newWhere;
            if (expr == null) {
                return expr;
            }
            String exprStr = expr.toString();
            String exprStrTemp = exprStr.toUpperCase();
            for (Map.Entry entry : this.dateTypeMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = CtrlReportUtil.getObjectString(entry.getValue());
                exprStr = ExtStringUtil.replace(exprStr, value, "@" + key, false, false);
            }
            String replaceExpr = exprStr;
            boolean isFind = false;
            if (exprStr.indexOf(64) != -1) {
                isFind = true;
            }
            int inFlag = -1;
            String field = null;
            String operatorString = null;
            String paramString = null;
            boolean isDate = false;
            boolean isTime = false;
            if (exprStrTemp.indexOf("{TS") != -1 || exprStrTemp.indexOf("{D") != -1 || exprStrTemp.indexOf("{T") != -1) {
                isDate = true;
                if (exprStrTemp.indexOf("{T") != -1) {
                    isTime = true;
                }
            }
            if (isFind || isDate) {
                SqlInListExpr binOp;
                if (expr instanceof SqlInListExpr) {
                    binOp = (SqlInListExpr)expr;
                    field = binOp.expr.toString();
                    operatorString = binOp.getExprWord();
                    paramString = ((SqlExpr)binOp.targetList.get(0)).toString();
                    inFlag = 1;
                } else if (expr instanceof SqlBinaryOpExpr) {
                    binOp = (SqlBinaryOpExpr)expr;
                    int operator = binOp.operator;
                    operatorString = SqlWhereParser.getOperator(operator);
                    field = binOp.left.toString();
                    paramString = binOp.right.toString();
                    inFlag = 0;
                }
            }
            if (isDate) {
                if (inFlag == 0) {
                    if (paramString == null || paramString.startsWith("{TS") || paramString.startsWith("{D") || paramString.startsWith("{T")) {
                        if (isFind) {
                            return this.replaceParam(expr, exprStr, replaceExpr, isTime);
                        }
                        newWhere = SqlWhereParser.parseKSQLDateTime(field, operatorString, paramString);
                        if (null != newWhere) {
                            replaceExpr = newWhere;
                        }
                    }
                } else if (inFlag == 1) {
                    if (paramString != null && (paramString.startsWith("{TS") || paramString.startsWith("{D") || paramString.startsWith("{T"))) {
                        throw new CtrlReportException(Messages.getMLS("useOperatorForDateTimeField", "\u65e5\u671f\u3001\u671f\u65f6\u95f4\u3001\u65f6\u95f4\u7c7b\u578b\u8bf7\u4f7f\u7528=\u3001>\u3001>=\u3001<\u3001<=\u3001<>\u64cd\u4f5c\u7b26"));
                    }
                } else {
                    throw new CtrlReportException(Messages.getMLS("failParseDateTime", "\u65e0\u6cd5\u89e3\u6790\u65e5\u671f\u578b\u5b57\u6bb5\uff0c\u8bf7\u8bd5\u8bd5\u53e6\u5916\u7684\u65b9\u5f0f\u6784\u9020SQL\uff0c\u65e5\u671f\u3001\u65f6\u95f4\u3001\u65e5\u671f\u65f6\u95f4\u7c7b\u578b\u8bf7\u4f7f\u7528=\u3001>\u3001>=\u3001<\u3001<=\u3001<>\u64cd\u4f5c\u7b26"));
                }
            }
            if (isFind) {
                for (Map.Entry entry : this.dateTypeMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = CtrlReportUtil.getObjectString(entry.getValue());
                    paramString = ExtStringUtil.replace(paramString, value, "@" + key, false, false);
                }
                newWhere = SqlWhereParser.parseKSQLList(exprStr, field, operatorString, paramString, this.mapDesignParam, this.params);
                if (null != newWhere) {
                    replaceExpr = newWhere;
                }
            }
            return this.replaceParam(expr, exprStr, replaceExpr, isTime);
        }
        catch (Exception e) {
            throw CtrlReportException.makeException(Messages.getMLS("solvePureSqlExprError", "solvePureSqlExpr\u68c0\u67e5\u9519\u8bef"), e);
        }
    }

    private SqlExpr replaceParam(SqlExpr expr, String oriExprStr, String replaceExpr, boolean isTime) {
        try {
            String newExprStr = BindParam.replaceVariantEXKSQL(expr, replaceExpr, this.params, this.simpleVarStyle, this.mapDesignParam, this.dbType);
            if (StringUtil.equals((String)newExprStr, (String)oriExprStr)) {
                return expr;
            }
            return this.str2KsqlExpr(newExprStr);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return UnkownBoolValueSqlExpr.instance;
        }
    }

    private SqlExpr solveWhere(SqlExpr expr) throws ParserException, CtrlReportException {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binOp = (SqlBinaryOpExpr)expr;
            if (binOp.operator == 7 || binOp.operator == 8) {
                binOp.left = this.solveWhere(binOp.left);
                binOp.right = this.solveWhere(binOp.right);
                if (binOp.left == UnkownBoolValueSqlExpr.instance) {
                    return binOp.right;
                }
                if (binOp.right == UnkownBoolValueSqlExpr.instance) {
                    return binOp.left;
                }
                return expr;
            }
        } else {
            if (expr instanceof SqlNotExpr) {
                SqlNotExpr notOp = (SqlNotExpr)expr;
                notOp.expr = this.solveWhere(notOp.expr);
                if (notOp.expr == UnkownBoolValueSqlExpr.instance) {
                    return UnkownBoolValueSqlExpr.instance;
                }
                return expr;
            }
            if (expr instanceof SqlInSubQueryExpr || expr instanceof SqlExistsExpr || expr instanceof QueryExpr) {
                SqlSelect subSelect = expr instanceof SqlInSubQueryExpr ? (SqlSelect)((SqlInSubQueryExpr)expr).subQuery : (expr instanceof SqlExistsExpr ? (SqlSelect)((SqlExistsExpr)expr).subQuery : (SqlSelect)((QueryExpr)expr).subQuery);
                if (subSelect.condition != null) {
                    subSelect.condition = this.solveWhere(subSelect.condition);
                    if (subSelect.condition == UnkownBoolValueSqlExpr.instance) {
                        subSelect.condition = null;
                    }
                }
                return expr;
            }
        }
        return this.solvePureSqlExpr(expr);
    }

    private void solveOrderBy(List orderBys) {
        if (orderBys == null) {
            return;
        }
        for (int i = 0; i < orderBys.size(); ++i) {
            SqlOrderByItem item = (SqlOrderByItem)orderBys.get(i);
            String exprStr = item.expr.toString();
            try {
                String newExprStr = BindParam.replaceVariantEXKSQL(null, exprStr, this.params, this.simpleVarStyle, this.mapDesignParam, this.dbType);
                if (StringUtil.equals((String)newExprStr, (String)exprStr)) continue;
                item.expr = this.str2KsqlExpr(newExprStr);
                continue;
            }
            catch (Exception e) {
                orderBys.remove(i);
                --i;
            }
        }
    }

    private String solveEntityView(String viewStr) throws Exception {
        if (viewStr == null || viewStr.length() == 0) {
            return viewStr;
        }
        SqlSelect select = (SqlSelect)this.solveSelect("SELECT * FROM T " + viewStr);
        viewStr = "";
        if (select.condition != null) {
            CtrlDesignKsqlSolver.covertSqlExpr_forEntityView(select.condition);
            viewStr = "WHERE " + select.condition.toString() + " ";
        }
        if (select.orderBy != null && select.orderBy.size() > 0) {
            viewStr = viewStr + "ORDER BY " + this.orderBys2Str_forEntityView(select.orderBy);
        }
        return viewStr;
    }

    private SqlSelectBase solveSelect(String select) throws Exception {
        SqlSelectBase sqlSelect = null;
        try {
            sqlSelect = CtrlDesignKsqlSolver.makeSqlSelect(select);
        }
        catch (Exception e) {
            throw CtrlReportException.makeException(Messages.getMLS("invalidKSQLSyntax", "SQL\u8bed\u53e5\u4e0d\u7b26\u5408KSQL\u8bed\u6cd5\uff0c\u8bf7\u67e5\u770b\u5e76\u4fee\u6539SQL\u8bed\u53e5"), e);
        }
        for (String key : this.dateTypeMap.keySet()) {
            if (!this.params.containsKey(key)) continue;
            this.params.remove(key);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("remove dateType insert temp:" + key));
        }
        this.solveSelect(sqlSelect);
        return sqlSelect;
    }

    private void solveSelect(SqlSelectBase sqlSelectBase) throws ParserException, CtrlReportException {
        if (sqlSelectBase instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)sqlSelectBase;
            this.solveSelect(unionSelect.left);
            this.solveSelect(unionSelect.right);
            if (unionSelect.orderBy != null) {
                this.solveOrderBy(unionSelect.orderBy);
            }
        } else if (sqlSelectBase instanceof SqlSelect) {
            SqlExpr newExpr;
            SqlSelect sqlSelect = (SqlSelect)sqlSelectBase;
            if (sqlSelect.condition != null) {
                newExpr = this.solveWhere(sqlSelect.condition);
                sqlSelect.condition = newExpr == UnkownBoolValueSqlExpr.instance ? null : newExpr;
            }
            this.solveSubQueryList(sqlSelect.subQueries);
            this.solveTableSource(sqlSelect.tableSource);
            this.solveOrderBy(sqlSelect.orderBy);
            if (sqlSelect.having != null) {
                newExpr = this.solveWhere(sqlSelect.having);
                sqlSelect.having = newExpr == UnkownBoolValueSqlExpr.instance ? null : newExpr;
            }
        }
    }

    private void solveTableSource(SqlTableSourceBase tableSource) throws ParserException, CtrlReportException {
        if (tableSource == null) {
            return;
        }
        if (tableSource instanceof SqlSubQueryTableSource) {
            this.solveSelect(((SqlSubQueryTableSource)tableSource).subQuery);
        } else if (tableSource instanceof SqlJoinedTableSource) {
            this.solveTableSource(((SqlJoinedTableSource)tableSource).left);
            this.solveTableSource(((SqlJoinedTableSource)tableSource).right);
            this.solveWhere(((SqlJoinedTableSource)tableSource).condition);
        }
        this.solveSubQueryList(tableSource.subQueries);
    }

    private void solveSubQueryList(List subQueries) throws ParserException, CtrlReportException {
        if (subQueries == null) {
            return;
        }
        Iterator iter = subQueries.iterator();
        while (iter.hasNext()) {
            this.solveSelect((SqlSelectBase)iter.next());
        }
    }

    private static class UnkownBoolValueSqlExpr
    extends SqlExpr {
        private static final UnkownBoolValueSqlExpr instance = new UnkownBoolValueSqlExpr();

        private UnkownBoolValueSqlExpr() {
            super(Short.MAX_VALUE);
        }

        public <T> T accept(ASTVisitor<? extends T> arg0) {
            return null;
        }

        public String toString() {
            return "UnkownBoolValueSqlExpr";
        }
    }
}

