/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.model;

import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class DateUtil {
    private static final Logger log = Logger.getLogger(DateUtil.class);
    public static final int[] CalendarWeek = new int[]{2, 3, 4, 5, 6, 7, 1};

    public static final String getMonthFirstDay(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-01");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 0);
        return sdf.format(cal.getTime());
    }

    public static final String getMonthLastDay(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDay = DateUtil.getMonthFirstDay(date);
        Calendar cal = Calendar.getInstance();
        try {
            Date firstDate = sdf.parse(firstDay);
            cal.setTime(firstDate);
            cal.add(2, 1);
            cal.add(5, -1);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sdf.format(cal.getTime());
    }

    public static final String tuneDate(String date, int amount) {
        String yesterday = null;
        try {
            Date curr = CtrlReportUtil.sdf_yyyy_MM_dd.get().parse(date);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(curr);
            gc.add(5, amount);
            curr = gc.getTime();
            yesterday = CtrlReportUtil.formatDate(curr);
        }
        catch (ParseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return yesterday;
    }

    public static final String tuneSecond(String date, int amount) {
        String yesterday = null;
        try {
            Date curr = CtrlReportUtil.sdfDateTime.get().parse(date);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(curr);
            gc.add(13, amount);
            curr = gc.getTime();
            yesterday = CtrlReportUtil.formatDateTime(curr);
        }
        catch (ParseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return yesterday;
    }

    public static final String tuneDate(Date date, int amount) {
        String dateString = CtrlReportUtil.sdf_yyyy_MM_dd.get().format(date);
        return DateUtil.tuneDate(dateString, amount);
    }

    public static final String tuneDateTime(Date date, int amount) {
        String dateTimeString = CtrlReportUtil.sdf_yyyy_MM_dd_HH_mm_ss.get().format(date);
        String[] arr = dateTimeString.split(" ");
        String dateString = arr[0];
        String timeString = arr[1];
        return DateUtil.tuneDate(dateString, amount) + " " + timeString;
    }

    public static final String[] getDateTimeArr(String datetime) {
        if (datetime.indexOf(" ") != -1) {
            String[] arr = datetime.split(" ");
            String date = arr[0];
            String time = arr[1];
            String[] dateArr = date.split("-");
            String[] timeArr = time.split(":");
            String[] resultArr = new String[]{dateArr[0], dateArr[1], dateArr[2], timeArr[0], timeArr[1], timeArr[2]};
            return resultArr;
        }
        if (datetime.indexOf("-") != -1) {
            return datetime.split("-");
        }
        if (datetime.indexOf(":") != -1) {
            return datetime.split(":");
        }
        return null;
    }

    public static String getDateOfWeek(Date date, int week) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(7, CalendarWeek[week]);
        String result = CtrlReportUtil.sdf_yyyy_MM_dd.get().format(cal.getTime());
        return result;
    }

    public static String tuneDateOfWeek(Date date, int amount, int week) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(3, amount);
        return DateUtil.getDateOfWeek(cal.getTime(), week);
    }

    public static String tuneDateOfWeek(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(3, amount);
        return CtrlReportUtil.sdf_yyyy_MM_dd.get().format(cal.getTime());
    }

    public static String tuneDateOfMonth(Date date, int amount, boolean firstOfDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, amount);
        if (firstOfDay) {
            return DateUtil.getMonthFirstDay(cal.getTime());
        }
        return DateUtil.getMonthLastDay(cal.getTime());
    }

    public static void main(String[] args) throws ParseException {
        Date date = CtrlReportUtil.sdf_yyyy_MM_dd.get().parse("2022-03-31");
        String dateOfMonth = DateUtil.tuneDateOfMonth(date, -1, false);
        System.out.println(dateOfMonth);
        String dateOfQuarter = DateUtil.tuneDateOfQuarter(date, 4, false);
        System.out.println(dateOfQuarter);
        String dateOfyear = DateUtil.tuneDateOfyear(date, 3, false);
        System.out.println(dateOfyear);
    }

    public static String tuneDateOfQuarter(Date date, int amount, boolean firstOfDay) {
        String dateOfMonth = DateUtil.tuneDateOfMonth(date, amount * 3, true);
        return DateUtil.getDateOfQuarter(dateOfMonth, firstOfDay);
    }

    public static String tuneDateOfyear(Date date, int amount, boolean firstOfDay) {
        String dateOfMonth = DateUtil.tuneDateOfMonth(date, amount * 12, true);
        String[] arr = DateUtil.getDateTimeArr(dateOfMonth);
        assert (arr != null);
        if (firstOfDay) {
            return arr[0] + "-01-01";
        }
        return arr[0] + "-12-31";
    }

    public static String getDateOfQuarter(String date, boolean isBegin) {
        String quarBegin = "";
        String quarEnd = "";
        String[] arr = DateUtil.getDateTimeArr(date);
        if (arr != null) {
            String year = arr[0];
            String month = arr[1];
            switch (Integer.parseInt(month)) {
                case 1: 
                case 2: 
                case 3: {
                    quarBegin = year + "-01-01";
                    quarEnd = year + "-03-31";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    quarBegin = year + "-04-01";
                    quarEnd = year + "-06-30";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    quarBegin = year + "-07-01";
                    quarEnd = year + "-09-30";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    quarBegin = year + "-10-01";
                    quarEnd = year + "-12-31";
                    break;
                }
            }
        }
        if (isBegin) {
            return quarBegin;
        }
        return quarEnd;
    }
}

